/*
 * Decompiled with CFR 0.152.
 */
package com.xycoding.richtext;

import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.text.Layout;
import android.text.Spannable;
import android.text.method.LinkMovementMethod;
import android.text.method.MovementMethod;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.widget.TextView;
import com.xycoding.richtext.typeface.ClickSpan;

public class LinkTouchMovementMethod
extends LinkMovementMethod {
    private static volatile LinkMovementMethod sInstance;
    private ClickSpan mClickSpan;
    private float mClickDownX;
    private float mClickDownY;
    private final Path mPath = new Path();
    private final RectF mRectF = new RectF();
    private final Rect mRect = new Rect();
    private int mClickSpanStart;
    private int mClickSpanEnd;
    private GestureDetector mGestureDetector;

    private LinkTouchMovementMethod() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MovementMethod getInstance() {
        if (sInstance != null) return sInstance;
        Class<LinkTouchMovementMethod> clazz = LinkTouchMovementMethod.class;
        synchronized (LinkTouchMovementMethod.class) {
            if (sInstance != null) return sInstance;
            sInstance = new LinkTouchMovementMethod();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    public boolean onTouchEvent(final TextView textView, final Spannable spannable, MotionEvent event) {
        if (this.mGestureDetector == null) {
            this.mGestureDetector = new GestureDetector(textView.getContext().getApplicationContext(), (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

                public boolean onSingleTapUp(MotionEvent e) {
                    LinkTouchMovementMethod.this.mClickSpan = LinkTouchMovementMethod.this.getPressedSpan(textView, spannable, e);
                    if (LinkTouchMovementMethod.this.mClickSpan != null) {
                        LinkTouchMovementMethod.this.mClickSpanStart = spannable.getSpanStart((Object)LinkTouchMovementMethod.this.mClickSpan);
                        LinkTouchMovementMethod.this.mClickSpanEnd = spannable.getSpanEnd((Object)LinkTouchMovementMethod.this.mClickSpan);
                        LinkTouchMovementMethod.this.calcWordCenter(textView, LinkTouchMovementMethod.this.mClickSpanStart, LinkTouchMovementMethod.this.mClickSpanEnd);
                        LinkTouchMovementMethod.this.mClickSpan.onClick(textView, textView.getText().subSequence(LinkTouchMovementMethod.this.mClickSpanStart, LinkTouchMovementMethod.this.mClickSpanEnd).toString(), LinkTouchMovementMethod.this.mClickDownX, LinkTouchMovementMethod.this.mClickDownY, spannable, LinkTouchMovementMethod.this.mClickSpanStart, LinkTouchMovementMethod.this.mClickSpanEnd);
                    }
                    textView.invalidate();
                    return true;
                }
            });
        }
        boolean handled = this.mGestureDetector.onTouchEvent(event);
        if (event.getAction() == 1 || event.getAction() == 3) {
            this.mClickSpan = null;
            this.mGestureDetector = null;
        }
        return handled;
    }

    private ClickSpan getPressedSpan(TextView textView, Spannable spannable, MotionEvent event) {
        int line;
        Layout layout;
        int x = (int)event.getX();
        int y = (int)event.getY();
        x -= textView.getTotalPaddingLeft();
        y -= textView.getTotalPaddingTop();
        if ((float)(x += textView.getScrollX()) < (layout = textView.getLayout()).getLineLeft(line = layout.getLineForVertical(y += textView.getScrollY())) || (float)x > layout.getLineRight(line)) {
            return null;
        }
        int off = layout.getOffsetForHorizontal(line, (float)x);
        ClickSpan[] link = (ClickSpan[])spannable.getSpans(off, off, ClickSpan.class);
        if (link.length > 0) {
            return link[link.length - 1];
        }
        return null;
    }

    private void calcWordCenter(TextView textView, int start, int end) {
        this.mPath.reset();
        textView.getLayout().getCursorPath(start, this.mPath, textView.getText());
        this.mPath.computeBounds(this.mRectF, false);
        int horizontalPadding = textView.getCompoundPaddingLeft();
        int verticalPadding = textView.getExtendedPaddingTop() + this.getVerticalOffset(textView);
        int left = (int)Math.floor((float)horizontalPadding + this.mRectF.left);
        int top = (int)Math.floor((float)verticalPadding + this.mRectF.top);
        int bottom = (int)Math.ceil((float)verticalPadding + this.mRectF.bottom);
        this.mPath.reset();
        textView.getLayout().getCursorPath(end, this.mPath, textView.getText());
        this.mPath.computeBounds(this.mRectF, false);
        int right = (int)Math.floor((float)horizontalPadding + this.mRectF.left);
        textView.getGlobalVisibleRect(this.mRect);
        this.mClickDownX = this.mRect.left + left + (right - left) / 2;
        this.mClickDownY = this.mRect.top + top + (bottom - top) / 2;
        textView.getLocalVisibleRect(this.mRect);
        this.mClickDownY -= (float)this.mRect.top;
    }

    private int getVerticalOffset(TextView textView) {
        int gravity = textView.getGravity() & 0x70;
        Layout layout = textView.getLayout();
        int vOffset = 0;
        if (gravity != 48) {
            int boxHeight = textView.getMeasuredHeight() - (textView.getExtendedPaddingTop() + textView.getExtendedPaddingBottom());
            int textHeight = layout.getHeight();
            if (textHeight < boxHeight) {
                vOffset = gravity == 80 ? boxHeight - textHeight : boxHeight - textHeight >> 1;
            }
        }
        return vOffset;
    }
}

