/*
 * Decompiled with CFR 0.152.
 */
package com.android.tony.defenselib;

import android.content.Context;
import android.os.Build;
import android.util.Log;
import com.android.hidden.pass.HiddenApiBypass;
import com.android.tony.defenselib.handler.ExceptionDispatcher;
import com.android.tony.defenselib.handler.IExceptionHandler;
import com.android.tony.defenselib.hook.HookHandler;
import com.android.tony.defenselib.hook.HookInstrumentation;
import com.android.tony.defenselib.hook.HookThreadLoop;
import com.android.tony.defenselib.hook.IHook;
import com.android.tony.defenselib.hook.SafeMode;

public final class DefenseCrash {
    public static final String TAG = "DefenseCrash";
    private static ExceptionDispatcher mExceptionDispatcher;
    private static volatile boolean installed;
    private static volatile boolean initialized;
    private static IHook hookThread;
    private static IHook hookInstrumentation;
    private static IHook hookHandler;

    private DefenseCrash() {
    }

    public static void initialize(Context context) {
        if (initialized) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 28) {
            HiddenApiBypass.addHiddenApiExemptions((String[])new String[]{"L"});
        }
        initialized = true;
        mExceptionDispatcher = new ExceptionDispatcher();
        hookThread = new HookThreadLoop(mExceptionDispatcher);
        hookInstrumentation = new HookInstrumentation(mExceptionDispatcher, context);
        hookHandler = new HookHandler(mExceptionDispatcher);
    }

    public static boolean install(IExceptionHandler handler) {
        return DefenseCrash.install(handler, true, true, true);
    }

    public static boolean install(IExceptionHandler handler, boolean isHookIns, boolean isHookThread, boolean isHookHandler) {
        if (!initialized) {
            Log.e((String)TAG, (String)"need call DefenseCrash.initialize() first");
            return false;
        }
        if (installed) {
            return true;
        }
        installed = true;
        mExceptionDispatcher.setIExceptionHandler(handler);
        if (isHookIns) {
            hookInstrumentation.hook();
        }
        if (isHookThread) {
            hookThread.hook();
        }
        if (isHookHandler) {
            hookHandler.hook();
        }
        return true;
    }

    public static boolean unInstall() {
        if (!initialized) {
            Log.e((String)TAG, (String)"need call DefenseCrash.initialize() first");
            return false;
        }
        if (!installed) {
            return false;
        }
        installed = false;
        hookInstrumentation.unHook();
        hookThread.unHook();
        hookHandler.unHook();
        return true;
    }

    public static boolean isIsSafeMode() {
        return SafeMode.isIsSafeMode();
    }

    static {
        installed = false;
        initialized = false;
    }
}

