/*
 * Decompiled with CFR 0.152.
 */
package com.android.tony.defenselib.hook;

import android.app.Instrumentation;
import android.content.Context;
import com.android.tony.defenselib.handler.ExceptionDispatcher;
import com.android.tony.defenselib.hook.IHook;
import com.android.tony.defenselib.hook.InstrumentationProxy;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class HookInstrumentation
implements IHook {
    private volatile boolean isHooked;
    private Context mContext;
    private ExceptionDispatcher mExceptionDispatcher;
    private Instrumentation mEvilInstrumentation;
    private Instrumentation mOriginInstrumentation;

    public HookInstrumentation(ExceptionDispatcher exceptionDispatcher, Context context) {
        this.mExceptionDispatcher = exceptionDispatcher;
        this.mContext = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void hook() {
        if (this.isHooked()) {
            return;
        }
        try {
            Class<?> activityThreadClass = Class.forName("android.app.ActivityThread");
            Method currentActivityThreadMethod = activityThreadClass.getDeclaredMethod("currentActivityThread", new Class[0]);
            currentActivityThreadMethod.setAccessible(true);
            Object currentActivityThread = currentActivityThreadMethod.invoke(null, new Object[0]);
            Field mInstrumentationField = activityThreadClass.getDeclaredField("mInstrumentation");
            mInstrumentationField.setAccessible(true);
            this.mOriginInstrumentation = (Instrumentation)mInstrumentationField.get(currentActivityThread);
            InstrumentationProxy proxy = new InstrumentationProxy(this.mContext, this.mOriginInstrumentation, this.mExceptionDispatcher);
            Instrumentation evilInstrumentation = this.mEvilInstrumentation = proxy.getProxy(Instrumentation.class);
            mInstrumentationField.set(currentActivityThread, evilInstrumentation);
            HookInstrumentation hookInstrumentation = this;
            synchronized (hookInstrumentation) {
                this.isHooked = true;
            }
        }
        catch (Throwable ignored) {
            ignored.printStackTrace();
            HookInstrumentation hookInstrumentation = this;
            synchronized (hookInstrumentation) {
                this.isHooked = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unHook() {
        if (!this.isHooked()) {
            return;
        }
        try {
            Class<?> activityThreadClass = Class.forName("android.app.ActivityThread");
            Method currentActivityThreadMethod = activityThreadClass.getDeclaredMethod("currentActivityThread", new Class[0]);
            currentActivityThreadMethod.setAccessible(true);
            Object currentActivityThread = currentActivityThreadMethod.invoke(null, new Object[0]);
            Field mInstrumentationField = activityThreadClass.getDeclaredField("mInstrumentation");
            mInstrumentationField.setAccessible(true);
            mInstrumentationField.set(currentActivityThread, this.mOriginInstrumentation);
            HookInstrumentation hookInstrumentation = this;
            synchronized (hookInstrumentation) {
                this.isHooked = false;
            }
        }
        catch (Throwable ignored) {
            ignored.printStackTrace();
            HookInstrumentation hookInstrumentation = this;
            synchronized (hookInstrumentation) {
                this.isHooked = true;
            }
        }
    }

    @Override
    public boolean isHooked() {
        return this.isHooked;
    }
}

