/*
 * Decompiled with CFR 0.152.
 */
package com.android.tony.defenselib.handler;

import com.android.tony.defenselib.exception.ExemptCaughtException;
import com.android.tony.defenselib.handler.IExceptionHandler;
import com.android.tony.defenselib.hook.SafeMode;

public class ExceptionDispatcher {
    private IExceptionHandler mIExceptionHandler;

    public final void uncaughtExceptionHappened(Thread thread, Throwable throwable) throws ExemptCaughtException {
        if (this.mIExceptionHandler == null) {
            return;
        }
        try {
            this.mIExceptionHandler.onCaughtException(thread, throwable, SafeMode.isIsSafeMode(), this.maybeChoreographerException(throwable));
        }
        catch (Throwable e) {
            throw new ExemptCaughtException(e);
        }
    }

    public void setIExceptionHandler(IExceptionHandler IExceptionHandler2) {
        this.mIExceptionHandler = IExceptionHandler2;
    }

    private boolean maybeChoreographerException(Throwable e) {
        if (e == null) {
            return false;
        }
        StackTraceElement[] elements = e.getStackTrace();
        if (elements == null) {
            return false;
        }
        for (int i = elements.length - 1; i > -1; --i) {
            if (elements.length - i > 20) {
                return false;
            }
            StackTraceElement element = elements[i];
            if (!"android.view.Choreographer".equals(element.getClassName()) || !"Choreographer.java".equals(element.getFileName()) || !"doFrame".equals(element.getMethodName())) continue;
            return true;
        }
        return false;
    }

    public static boolean hasExemptException(Throwable throwable) {
        if (throwable == null) {
            return false;
        }
        if (throwable instanceof ExemptCaughtException) {
            return true;
        }
        if (throwable.equals(throwable.getCause())) {
            return false;
        }
        return ExceptionDispatcher.hasExemptException(throwable.getCause());
    }
}

