/*
 * Decompiled with CFR 0.152.
 */
package com.android.cglib.proxy;

import android.content.Context;
import com.android.cglib.proxy.Const;
import com.android.cglib.proxy.EnhancerInterface;
import com.android.cglib.proxy.MethodInterceptor;
import com.android.cglib.proxy.MethodProxyExecuter;
import com.android.dx.Code;
import com.android.dx.Comparison;
import com.android.dx.DexMaker;
import com.android.dx.FieldId;
import com.android.dx.Label;
import com.android.dx.Local;
import com.android.dx.MethodId;
import com.android.dx.TypeId;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class Enhancer {
    private Context context;
    private Class<?> superclass;
    private MethodInterceptor interceptor;

    public Enhancer(Context context) {
        this.context = context;
    }

    public void setSuperclass(Class<?> cls) {
        this.superclass = cls;
    }

    public void setInterceptor(MethodInterceptor interceptor) {
        this.interceptor = interceptor;
    }

    public Object create() {
        String superClsName = this.superclass.getName().replace(".", "/");
        String subClsName = superClsName + "$Enhancer$";
        TypeId interfaceTypeId = TypeId.get(EnhancerInterface.class);
        TypeId superType = TypeId.get((String)("L" + superClsName + ";"));
        TypeId subType = TypeId.get((String)("L" + subClsName + ";"));
        String cacheDir = this.context.getDir("dexfiles", 0).getAbsolutePath();
        DexMaker dexMaker = new DexMaker();
        dexMaker.declare(subType, superClsName + ".proxy", 1, superType, new TypeId[]{interfaceTypeId});
        this.generateFieldsAndMethods(dexMaker, superType, subType);
        try {
            ClassLoader loader = dexMaker.generateAndLoad(Enhancer.class.getClassLoader(), new File(cacheDir));
            Class<?> subCls = loader.loadClass(this.superclass.getName() + "$Enhancer$");
            Object obj = subCls.newInstance();
            ((EnhancerInterface)obj).setMethodInterceptor$Enhancer$(this.interceptor);
            return obj;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    private <S> void generateFieldsAndMethods(DexMaker dexMaker, TypeId<?> superType, TypeId<S> subType) {
        TypeId methodInterceptorType = TypeId.get(MethodInterceptor.class);
        TypeId methodProxyExecuterType = TypeId.get(MethodProxyExecuter.class);
        TypeId classType = TypeId.get(Class.class);
        TypeId classesType = TypeId.get(Class[].class);
        TypeId stringType = TypeId.get(String.class);
        TypeId objectType = TypeId.get(Object.class);
        TypeId objectsType = TypeId.get(Object[].class);
        FieldId fieldId = subType.getField(methodInterceptorType, "methodInterceptor");
        dexMaker.declare(fieldId, 2, null);
        Code code = dexMaker.declare(subType.getConstructor(new TypeId[0]), 1);
        Local thisRef = code.getThis(subType);
        code.invokeDirect(superType.getConstructor(new TypeId[0]), null, thisRef, new Local[0]);
        code.returnVoid();
        MethodId setMethodInterceptorMethodId = subType.getMethod(TypeId.VOID, "setMethodInterceptor$Enhancer$", new TypeId[]{methodInterceptorType});
        code = dexMaker.declare(setMethodInterceptorMethodId, 1);
        code.iput(fieldId, code.getThis(subType), code.getParameter(0, methodInterceptorType));
        code.returnVoid();
        MethodId executeSuperMethodMethodId = subType.getMethod(TypeId.OBJECT, "executeSuperMethod$Enhancer$", new TypeId[]{stringType, classesType, objectsType});
        code = dexMaker.declare(executeSuperMethodMethodId, 1);
        Local retObjLocal = code.newLocal(objectType);
        Local subClassLocal = code.newLocal(classType);
        Local thisLocal = code.getThis(subType);
        code.invokeVirtual(subType.getMethod(classType, "getClass", new TypeId[0]), subClassLocal, thisLocal, new Local[0]);
        MethodId methodId = methodProxyExecuterType.getMethod(TypeId.OBJECT, "executeMethod", new TypeId[]{classType, stringType, classesType, objectsType, objectType});
        code.invokeStatic(methodId, retObjLocal, new Local[]{subClassLocal, code.getParameter(0, stringType), code.getParameter(1, classesType), code.getParameter(2, objectsType), thisLocal});
        code.returnValue(retObjLocal);
        Method[] methods = this.superclass.getDeclaredMethods();
        MethodId superMethodId = null;
        MethodId subMethodId = null;
        TypeId[] argsTypeId = null;
        TypeId methodReturnType = null;
        String methodName = null;
        boolean isVoid = false;
        boolean hasParams = false;
        Class<?> retClass = null;
        for (Method method : methods) {
            int modifiers = method.getModifiers();
            if (Modifier.isStatic(modifiers) || Modifier.isFinal(modifiers) || (methodName = method.getName()).contains("$")) continue;
            retClass = method.getReturnType();
            isVoid = retClass.getSimpleName().equals("void");
            methodReturnType = TypeId.get(retClass);
            Class<?>[] argsClass = method.getParameterTypes();
            boolean bl = hasParams = argsClass != null && argsClass.length > 0;
            if (hasParams) {
                argsTypeId = new TypeId[argsClass.length];
                for (int i = 0; i < argsClass.length; ++i) {
                    argsTypeId[i] = TypeId.get(argsClass[i]);
                }
                subMethodId = subType.getMethod(methodReturnType, methodName, argsTypeId);
            } else {
                subMethodId = subType.getMethod(methodReturnType, methodName, new TypeId[0]);
            }
            code = dexMaker.declare(subMethodId, method.getModifiers());
            Local retLocal = code.newLocal(methodReturnType);
            Local retPackLocal = null;
            if (retClass.isPrimitive()) {
                retPackLocal = code.newLocal(TypeId.get((Class)Const.getPackedType(retClass)));
            }
            Local intLocal = code.newLocal(TypeId.INT);
            Local methodInterceptorLocal = code.newLocal(methodInterceptorType);
            Local methodNameLocal = code.newLocal(TypeId.get(String.class));
            Local tmpClassLocal = code.newLocal(classType);
            subClassLocal = code.newLocal(classType);
            Local argsTypeLocal = code.newLocal(classesType);
            Local argsValueLocal = code.newLocal(objectsType);
            Local tmpNumberLocal = code.newLocal(objectType);
            retObjLocal = code.newLocal(TypeId.OBJECT);
            thisLocal = code.getThis(subType);
            code.iget(fieldId, methodInterceptorLocal, thisLocal);
            code.loadConstant(methodNameLocal, (Object)methodName);
            code.invokeVirtual(subType.getMethod(classType, "getClass", new TypeId[0]), subClassLocal, thisLocal, new Local[0]);
            if (hasParams) {
                code.loadConstant(intLocal, (Object)argsClass.length);
                code.newArray(argsTypeLocal, intLocal);
                code.newArray(argsValueLocal, intLocal);
                for (int i = 0; i < argsClass.length; ++i) {
                    code.loadConstant(intLocal, (Object)i);
                    code.loadConstant(tmpClassLocal, argsClass[i]);
                    code.aput(argsTypeLocal, intLocal, tmpClassLocal);
                    if (argsClass[i].isPrimitive()) {
                        TypeId packedClassType = TypeId.get((Class)Const.getPackedType(argsClass[i]));
                        methodId = packedClassType.getMethod(packedClassType, "valueOf", new TypeId[]{argsTypeId[i]});
                        code.invokeStatic(methodId, tmpNumberLocal, new Local[]{code.getParameter(i, argsTypeId[i])});
                        code.aput(argsValueLocal, intLocal, tmpNumberLocal);
                        continue;
                    }
                    code.aput(argsValueLocal, intLocal, code.getParameter(i, argsTypeId[i]));
                }
            } else {
                code.loadConstant(argsTypeLocal, null);
                code.loadConstant(argsValueLocal, null);
            }
            methodId = methodProxyExecuterType.getMethod(TypeId.OBJECT, "executeInterceptor", new TypeId[]{methodInterceptorType, classType, stringType, classesType, objectsType, objectType});
            code.invokeStatic(methodId, isVoid ? null : retObjLocal, new Local[]{methodInterceptorLocal, subClassLocal, methodNameLocal, argsTypeLocal, argsValueLocal, thisLocal});
            if (isVoid) {
                code.returnVoid();
            } else if (retClass.isPrimitive()) {
                Label ifBody = new Label();
                code.loadConstant(retPackLocal, null);
                code.compare(Comparison.EQ, ifBody, retObjLocal, retPackLocal);
                code.cast(retPackLocal, retObjLocal);
                methodId = TypeId.get((Class)Const.getPackedType(retClass)).getMethod(methodReturnType, Const.getPrimitiveValueMethodName(retClass), new TypeId[0]);
                code.invokeVirtual(methodId, retLocal, retPackLocal, new Local[0]);
                code.returnValue(retLocal);
                code.mark(ifBody);
                code.loadConstant(retLocal, (Object)0);
                code.returnValue(retLocal);
            } else {
                code.cast(retLocal, retObjLocal);
                code.returnValue(retLocal);
            }
            if (hasParams) {
                subMethodId = subType.getMethod(methodReturnType, methodName + "$Super$", argsTypeId);
                superMethodId = superType.getMethod(methodReturnType, methodName, argsTypeId);
            } else {
                subMethodId = subType.getMethod(methodReturnType, methodName + "$Super$", new TypeId[0]);
                superMethodId = superType.getMethod(methodReturnType, methodName, new TypeId[0]);
            }
            code = dexMaker.declare(subMethodId, method.getModifiers());
            retLocal = code.newLocal(methodReturnType);
            Local[] superArgsValueLocal = null;
            thisLocal = code.getThis(subType);
            if (hasParams) {
                superArgsValueLocal = new Local[argsClass.length];
                for (int i = 0; i < argsClass.length; ++i) {
                    superArgsValueLocal[i] = code.getParameter(i, argsTypeId[i]);
                }
                code.invokeSuper(superMethodId, isVoid ? null : retLocal, thisLocal, superArgsValueLocal);
            } else {
                code.invokeSuper(superMethodId, isVoid ? null : retLocal, thisLocal, new Local[0]);
            }
            if (isVoid) {
                code.returnVoid();
                continue;
            }
            code.returnValue(retLocal);
        }
    }
}

