/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xupdate.widget;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.ActivityCompat;
import android.support.v7.app.AppCompatActivity;
import android.util.DisplayMetrics;
import android.view.KeyEvent;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.xuexiang.xupdate.R;
import com.xuexiang.xupdate._XUpdate;
import com.xuexiang.xupdate.entity.PromptEntity;
import com.xuexiang.xupdate.entity.UpdateEntity;
import com.xuexiang.xupdate.proxy.IPrompterProxy;
import com.xuexiang.xupdate.service.OnFileDownloadListener;
import com.xuexiang.xupdate.utils.ColorUtils;
import com.xuexiang.xupdate.utils.DrawableUtils;
import com.xuexiang.xupdate.utils.UpdateUtils;
import com.xuexiang.xupdate.widget.NumberProgressBar;
import java.io.File;

public class UpdateDialogActivity
extends AppCompatActivity
implements View.OnClickListener {
    private ImageView mIvTop;
    private TextView mTvTitle;
    private TextView mTvUpdateInfo;
    private Button mBtnUpdate;
    private Button mBtnBackgroundUpdate;
    private TextView mTvIgnore;
    private NumberProgressBar mNumberProgressBar;
    private LinearLayout mLlClose;
    private ImageView mIvClose;
    private UpdateEntity mUpdateEntity;
    private static IPrompterProxy sIPrompterProxy;
    private PromptEntity mPromptEntity;
    private OnFileDownloadListener mOnFileDownloadListener = new OnFileDownloadListener(){

        @Override
        public void onStart() {
            if (!UpdateDialogActivity.this.isFinishing()) {
                UpdateDialogActivity.this.mNumberProgressBar.setVisibility(0);
                UpdateDialogActivity.this.mNumberProgressBar.setProgress(0);
                UpdateDialogActivity.this.mBtnUpdate.setVisibility(8);
                if (UpdateDialogActivity.this.mPromptEntity.isSupportBackgroundUpdate()) {
                    UpdateDialogActivity.this.mBtnBackgroundUpdate.setVisibility(0);
                } else {
                    UpdateDialogActivity.this.mBtnBackgroundUpdate.setVisibility(8);
                }
            }
        }

        @Override
        public void onProgress(float progress, long total) {
            if (!UpdateDialogActivity.this.isFinishing()) {
                UpdateDialogActivity.this.mNumberProgressBar.setProgress(Math.round(progress * 100.0f));
                UpdateDialogActivity.this.mNumberProgressBar.setMax(100);
            }
        }

        @Override
        public boolean onCompleted(File file) {
            if (!UpdateDialogActivity.this.isFinishing()) {
                UpdateDialogActivity.this.mBtnBackgroundUpdate.setVisibility(8);
                if (UpdateDialogActivity.this.mUpdateEntity.isForce()) {
                    UpdateDialogActivity.this.showInstallButton(file);
                } else {
                    UpdateDialogActivity.this.dismissDialog();
                }
            }
            return true;
        }

        @Override
        public void onError(Throwable throwable) {
            if (!UpdateDialogActivity.this.isFinishing()) {
                UpdateDialogActivity.this.dismissDialog();
            }
        }
    };

    public static void show(@NonNull Context context, @NonNull UpdateEntity updateEntity, @NonNull IPrompterProxy prompterProxy, @NonNull PromptEntity promptEntity) {
        Intent intent = new Intent(context, UpdateDialogActivity.class);
        intent.putExtra("key_update_entity", (Parcelable)updateEntity);
        intent.putExtra("key_update_prompt_entity", (Parcelable)promptEntity);
        if (!(context instanceof Activity)) {
            intent.addFlags(0x10000000);
        }
        UpdateDialogActivity.setsIPrompterProxy(prompterProxy);
        context.startActivity(intent);
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.xupdate_dialog_app);
        _XUpdate.setIsShowUpdatePrompter(true);
        this.initView();
        this.initData();
    }

    private void initView() {
        this.mIvTop = (ImageView)this.findViewById(R.id.iv_top);
        this.mTvTitle = (TextView)this.findViewById(R.id.tv_title);
        this.mTvUpdateInfo = (TextView)this.findViewById(R.id.tv_update_info);
        this.mBtnUpdate = (Button)this.findViewById(R.id.btn_update);
        this.mBtnBackgroundUpdate = (Button)this.findViewById(R.id.btn_background_update);
        this.mTvIgnore = (TextView)this.findViewById(R.id.tv_ignore);
        this.mNumberProgressBar = (NumberProgressBar)this.findViewById(R.id.npb_progress);
        this.mLlClose = (LinearLayout)this.findViewById(R.id.ll_close);
        this.mIvClose = (ImageView)this.findViewById(R.id.iv_close);
    }

    private void initData() {
        Bundle bundle = this.getIntent().getExtras();
        if (bundle != null) {
            this.mPromptEntity = (PromptEntity)bundle.getParcelable("key_update_prompt_entity");
            if (this.mPromptEntity == null) {
                this.mPromptEntity = new PromptEntity();
            }
            this.initTheme(this.mPromptEntity.getThemeColor(), this.mPromptEntity.getTopResId());
            this.mUpdateEntity = (UpdateEntity)bundle.getParcelable("key_update_entity");
            if (this.mUpdateEntity != null) {
                this.initUpdateInfo(this.mUpdateEntity);
                this.initListeners();
            }
        }
    }

    private void initUpdateInfo(UpdateEntity updateEntity) {
        String newVersion = updateEntity.getVersionName();
        String updateInfo = UpdateUtils.getDisplayUpdateInfo((Context)this, updateEntity);
        this.mTvUpdateInfo.setText((CharSequence)updateInfo);
        this.mTvTitle.setText((CharSequence)String.format(this.getString(R.string.xupdate_lab_ready_update), newVersion));
        if (UpdateUtils.isApkDownloaded(this.mUpdateEntity)) {
            this.showInstallButton(UpdateUtils.getApkFileByUpdateEntity(this.mUpdateEntity));
        }
        if (updateEntity.isForce()) {
            this.mLlClose.setVisibility(8);
        } else if (updateEntity.isIgnorable()) {
            this.mTvIgnore.setVisibility(0);
        }
    }

    private void initTheme(@ColorInt int themeColor, @DrawableRes int topResId) {
        if (themeColor == -1) {
            themeColor = ColorUtils.getColor((Context)this, R.color.xupdate_default_theme_color);
        }
        if (topResId == -1) {
            topResId = R.drawable.xupdate_bg_app_top;
        }
        this.setDialogTheme(themeColor, topResId);
    }

    private void setDialogTheme(int color2, int topResId) {
        this.mIvTop.setImageResource(topResId);
        this.mBtnUpdate.setBackgroundDrawable((Drawable)DrawableUtils.getDrawable(UpdateUtils.dip2px(4, (Context)this), color2));
        this.mBtnBackgroundUpdate.setBackgroundDrawable((Drawable)DrawableUtils.getDrawable(UpdateUtils.dip2px(4, (Context)this), color2));
        this.mNumberProgressBar.setProgressTextColor(color2);
        this.mNumberProgressBar.setReachedBarColor(color2);
        this.mBtnUpdate.setTextColor(ColorUtils.isColorDark(color2) ? -1 : -16777216);
    }

    private void initListeners() {
        this.mBtnUpdate.setOnClickListener((View.OnClickListener)this);
        this.mBtnBackgroundUpdate.setOnClickListener((View.OnClickListener)this);
        this.mIvClose.setOnClickListener((View.OnClickListener)this);
        this.mTvIgnore.setOnClickListener((View.OnClickListener)this);
    }

    public void onStart() {
        super.onStart();
        this.initWindowStyle();
    }

    private void initWindowStyle() {
        Window window = this.getWindow();
        if (window != null) {
            window.setGravity(17);
            WindowManager.LayoutParams lp = window.getAttributes();
            DisplayMetrics displayMetrics = this.getResources().getDisplayMetrics();
            if (this.mPromptEntity.getWidthRatio() > 0.0f && this.mPromptEntity.getWidthRatio() < 1.0f) {
                lp.width = (int)((float)displayMetrics.widthPixels * this.mPromptEntity.getWidthRatio());
            }
            if (this.mPromptEntity.getHeightRatio() > 0.0f && this.mPromptEntity.getHeightRatio() < 1.0f) {
                lp.height = (int)((float)displayMetrics.heightPixels * this.mPromptEntity.getHeightRatio());
            }
            window.setAttributes(lp);
        }
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        return keyCode == 4 && this.mUpdateEntity != null && this.mUpdateEntity.isForce();
    }

    public void onClick(View view) {
        int i = view.getId();
        if (i == R.id.btn_update) {
            int flag = ActivityCompat.checkSelfPermission((Context)this, (String)"android.permission.WRITE_EXTERNAL_STORAGE");
            if (!UpdateUtils.isPrivateApkCacheDir(this.mUpdateEntity) && flag != 0) {
                ActivityCompat.requestPermissions((Activity)this, (String[])new String[]{"android.permission.WRITE_EXTERNAL_STORAGE"}, (int)111);
            } else {
                this.installApp();
            }
        } else if (i == R.id.btn_background_update) {
            if (sIPrompterProxy != null) {
                sIPrompterProxy.backgroundDownload();
            }
            this.dismissDialog();
        } else if (i == R.id.iv_close) {
            if (sIPrompterProxy != null) {
                sIPrompterProxy.cancelDownload();
            }
            this.dismissDialog();
        } else if (i == R.id.tv_ignore) {
            UpdateUtils.saveIgnoreVersion((Context)this, this.mUpdateEntity.getVersionName());
            this.dismissDialog();
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if (requestCode == 111) {
            if (grantResults.length > 0 && grantResults[0] == 0) {
                this.installApp();
            } else {
                _XUpdate.onUpdateError(4001);
                this.dismissDialog();
            }
        }
    }

    private void installApp() {
        if (UpdateUtils.isApkDownloaded(this.mUpdateEntity)) {
            this.onInstallApk();
            if (!this.mUpdateEntity.isForce()) {
                this.dismissDialog();
            } else {
                this.showInstallButton(UpdateUtils.getApkFileByUpdateEntity(this.mUpdateEntity));
            }
        } else {
            if (sIPrompterProxy != null) {
                sIPrompterProxy.startDownload(this.mUpdateEntity, this.mOnFileDownloadListener);
            }
            if (this.mUpdateEntity.isIgnorable()) {
                this.mTvIgnore.setVisibility(8);
            }
        }
    }

    private void showInstallButton(final File apkFile) {
        this.mNumberProgressBar.setVisibility(8);
        this.mBtnUpdate.setText(R.string.xupdate_lab_install);
        this.mBtnUpdate.setVisibility(0);
        this.mBtnUpdate.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                UpdateDialogActivity.this.onInstallApk(apkFile);
            }
        });
    }

    private void onInstallApk() {
        _XUpdate.startInstallApk((Context)this, UpdateUtils.getApkFileByUpdateEntity(this.mUpdateEntity), this.mUpdateEntity.getDownLoadEntity());
    }

    private void onInstallApk(File apkFile) {
        _XUpdate.startInstallApk((Context)this, apkFile, this.mUpdateEntity.getDownLoadEntity());
    }

    private void dismissDialog() {
        this.finish();
    }

    protected void onStop() {
        if (this.isFinishing()) {
            _XUpdate.setIsShowUpdatePrompter(false);
            UpdateDialogActivity.clearIPrompterProxy();
        }
        super.onStop();
    }

    private static void setsIPrompterProxy(IPrompterProxy sIPrompterProxy) {
        UpdateDialogActivity.sIPrompterProxy = sIPrompterProxy;
    }

    private static void clearIPrompterProxy() {
        if (sIPrompterProxy != null) {
            sIPrompterProxy.recycle();
            sIPrompterProxy = null;
        }
    }
}

