/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xupdate.widget;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.annotation.IdRes;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AppCompatDialog;
import android.view.MotionEvent;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import com.xuexiang.xupdate.R;

public abstract class BaseDialog
extends AppCompatDialog {
    private View mContentView;

    public BaseDialog(Context context, int layoutId) {
        this(context, R.style.XUpdate_Dialog, layoutId);
    }

    public BaseDialog(Context context, View contentView) {
        this(context, R.style.XUpdate_Dialog, contentView);
    }

    public BaseDialog(Context context) {
        super(context, R.style.XUpdate_Dialog);
    }

    public BaseDialog(Context context, int theme, int layoutId) {
        super(context, theme);
        this.init(layoutId);
    }

    public BaseDialog(Context context, int theme, View contentView) {
        super(context, theme);
        this.init(contentView);
    }

    private void init(int layoutId) {
        View view = this.getLayoutInflater().inflate(layoutId, null);
        this.init(view);
    }

    private void init(View view) {
        this.setContentView(view);
        this.mContentView = view;
        this.setCanceledOnTouchOutside(true);
        this.initViews();
        this.initListeners();
    }

    public <T extends View> T findViewById(@IdRes int id2) {
        return (T)this.mContentView.findViewById(id2);
    }

    protected abstract void initViews();

    protected abstract void initListeners();

    protected BaseDialog setDialogSize(int width, int height) {
        Window window = this.getWindow();
        if (window != null) {
            WindowManager.LayoutParams p = this.getWindow().getAttributes();
            p.width = width;
            p.height = height;
            window.setAttributes(p);
        }
        return this;
    }

    protected String getString(int resId) {
        return this.getContext().getResources().getString(resId);
    }

    protected Drawable getDrawable(int resId) {
        return ContextCompat.getDrawable((Context)this.getContext(), (int)resId);
    }

    public boolean onTouchEvent(MotionEvent ev) {
        View v;
        if (ev.getAction() == 0 && BaseDialog.isShouldHideKeyboard(v = this.getCurrentFocus(), ev)) {
            BaseDialog.hideSoftInput(v);
        }
        return super.onTouchEvent(ev);
    }

    private static boolean isShouldHideKeyboard(View v, MotionEvent event) {
        if (v != null && v instanceof EditText) {
            int[] l = new int[]{0, 0};
            v.getLocationInWindow(l);
            int left = l[0];
            int top = l[1];
            int bottom = top + v.getHeight();
            int right = left + v.getWidth();
            return !(event.getX() > (float)left && event.getX() < (float)right && event.getY() > (float)top && event.getY() < (float)bottom);
        }
        return false;
    }

    private static void hideSoftInput(View view) {
        InputMethodManager imm = (InputMethodManager)view.getContext().getSystemService("input_method");
        if (imm == null) {
            return;
        }
        imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
    }
}

