/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xupdate;

import android.app.Application;
import android.content.Context;
import android.support.annotation.NonNull;
import com.xuexiang.xupdate.UpdateManager;
import com.xuexiang.xupdate.entity.UpdateError;
import com.xuexiang.xupdate.listener.OnInstallListener;
import com.xuexiang.xupdate.listener.OnUpdateFailureListener;
import com.xuexiang.xupdate.listener.impl.DefaultInstallListener;
import com.xuexiang.xupdate.listener.impl.DefaultUpdateFailureListener;
import com.xuexiang.xupdate.logs.ILogger;
import com.xuexiang.xupdate.logs.UpdateLog;
import com.xuexiang.xupdate.proxy.IFileEncryptor;
import com.xuexiang.xupdate.proxy.IUpdateChecker;
import com.xuexiang.xupdate.proxy.IUpdateDownloader;
import com.xuexiang.xupdate.proxy.IUpdateHttpService;
import com.xuexiang.xupdate.proxy.IUpdateParser;
import com.xuexiang.xupdate.proxy.impl.DefaultFileEncryptor;
import com.xuexiang.xupdate.proxy.impl.DefaultUpdateChecker;
import com.xuexiang.xupdate.proxy.impl.DefaultUpdateDownloader;
import com.xuexiang.xupdate.proxy.impl.DefaultUpdateParser;
import com.xuexiang.xupdate.utils.ApkInstallUtils;
import java.util.Map;
import java.util.TreeMap;

public class XUpdate {
    private Application mContext;
    private static XUpdate sInstance;
    Map<String, Object> mParams;
    boolean mIsGet = false;
    boolean mIsWifiOnly = true;
    boolean mIsAutoMode = false;
    String mApkCacheDir;
    IUpdateHttpService mIUpdateHttpService;
    IUpdateChecker mIUpdateChecker = new DefaultUpdateChecker();
    IUpdateParser mIUpdateParser = new DefaultUpdateParser();
    IUpdateDownloader mIUpdateDownloader = new DefaultUpdateDownloader();
    IFileEncryptor mIFileEncryptor = new DefaultFileEncryptor();
    OnInstallListener mOnInstallListener = new DefaultInstallListener();
    OnUpdateFailureListener mOnUpdateFailureListener = new DefaultUpdateFailureListener();

    private XUpdate() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static XUpdate get() {
        if (sInstance != null) return sInstance;
        Class<XUpdate> clazz = XUpdate.class;
        synchronized (XUpdate.class) {
            if (sInstance != null) return sInstance;
            sInstance = new XUpdate();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    public void init(Application application) {
        this.mContext = application;
        UpdateError.init((Context)this.mContext);
    }

    private Application getApplication() {
        this.testInitialize();
        return this.mContext;
    }

    private void testInitialize() {
        if (this.mContext == null) {
            throw new ExceptionInInitializerError("\u8bf7\u5148\u5728\u5168\u5c40Application\u4e2d\u8c03\u7528 XUpdate.get().init() \u521d\u59cb\u5316\uff01");
        }
    }

    public static Context getContext() {
        return XUpdate.get().getApplication();
    }

    public static UpdateManager.Builder newBuild(@NonNull Context context) {
        return new UpdateManager.Builder(context);
    }

    public static UpdateManager.Builder newBuild(@NonNull Context context, String updateUrl) {
        return new UpdateManager.Builder(context).updateUrl(updateUrl);
    }

    public XUpdate param(@NonNull String key, @NonNull Object value) {
        if (this.mParams == null) {
            this.mParams = new TreeMap<String, Object>();
        }
        UpdateLog.d("\u8bbe\u7f6e\u5168\u5c40\u53c2\u6570, key:" + key + ", value:" + value.toString());
        this.mParams.put(key, value);
        return this;
    }

    public XUpdate params(@NonNull Map<String, Object> params) {
        this.logForParams(params);
        this.mParams = params;
        return this;
    }

    private void logForParams(@NonNull Map<String, Object> params) {
        StringBuilder sb = new StringBuilder("\u8bbe\u7f6e\u5168\u5c40\u53c2\u6570:{\n");
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            sb.append("key = ").append(entry.getKey()).append(", value = ").append(entry.getValue().toString()).append("\n");
        }
        sb.append("}");
        UpdateLog.d(sb.toString());
    }

    public XUpdate setIUpdateHttpService(@NonNull IUpdateHttpService updateHttpService) {
        UpdateLog.d("\u8bbe\u7f6e\u5168\u5c40\u66f4\u65b0\u7f51\u7edc\u8bf7\u6c42\u670d\u52a1:" + updateHttpService.getClass().getCanonicalName());
        this.mIUpdateHttpService = updateHttpService;
        return this;
    }

    public XUpdate setIUpdateChecker(@NonNull IUpdateChecker updateChecker) {
        this.mIUpdateChecker = updateChecker;
        return this;
    }

    public XUpdate setIUpdateParser(@NonNull IUpdateParser updateParser) {
        this.mIUpdateParser = updateParser;
        return this;
    }

    public XUpdate setIUpdateDownLoader(@NonNull IUpdateDownloader updateDownLoader) {
        this.mIUpdateDownloader = updateDownLoader;
        return this;
    }

    public XUpdate isGet(boolean isGet) {
        UpdateLog.d("\u8bbe\u7f6e\u5168\u5c40\u662f\u5426\u4f7f\u7528\u7684\u662fGet\u8bf7\u6c42:" + isGet);
        this.mIsGet = isGet;
        return this;
    }

    public XUpdate isWifiOnly(boolean isWifiOnly) {
        UpdateLog.d("\u8bbe\u7f6e\u5168\u5c40\u662f\u5426\u53ea\u5728wifi\u4e0b\u8fdb\u884c\u7248\u672c\u66f4\u65b0\u68c0\u67e5:" + isWifiOnly);
        this.mIsWifiOnly = isWifiOnly;
        return this;
    }

    public XUpdate isAutoMode(boolean isAutoMode) {
        UpdateLog.d("\u8bbe\u7f6e\u5168\u5c40\u662f\u5426\u662f\u81ea\u52a8\u7248\u672c\u66f4\u65b0\u6a21\u5f0f:" + isAutoMode);
        this.mIsAutoMode = isAutoMode;
        return this;
    }

    public XUpdate setApkCacheDir(String apkCacheDir) {
        UpdateLog.d("\u8bbe\u7f6e\u5168\u5c40apk\u7684\u7f13\u5b58\u8def\u5f84:" + apkCacheDir);
        this.mApkCacheDir = apkCacheDir;
        return this;
    }

    public XUpdate supportSilentInstall(boolean supportSilentInstall) {
        ApkInstallUtils.setSupportSilentInstall(supportSilentInstall);
        return this;
    }

    public XUpdate debug(boolean isDebug) {
        UpdateLog.debug(isDebug);
        return this;
    }

    public XUpdate setILogger(@NonNull ILogger logger) {
        UpdateLog.setLogger(logger);
        return this;
    }

    public XUpdate setIFileEncryptor(IFileEncryptor fileEncryptor) {
        this.mIFileEncryptor = fileEncryptor;
        return this;
    }

    public XUpdate setOnInstallListener(OnInstallListener onInstallListener) {
        this.mOnInstallListener = onInstallListener;
        return this;
    }

    public XUpdate setOnUpdateFailureListener(@NonNull OnUpdateFailureListener onUpdateFailureListener) {
        this.mOnUpdateFailureListener = onUpdateFailureListener;
        return this;
    }
}

