/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xupdate.widget;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.v4.app.ActivityCompat;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.xuexiang.xupdate.R;
import com.xuexiang.xupdate._XUpdate;
import com.xuexiang.xupdate.entity.PromptEntity;
import com.xuexiang.xupdate.entity.UpdateEntity;
import com.xuexiang.xupdate.proxy.IUpdateProxy;
import com.xuexiang.xupdate.service.OnFileDownloadListener;
import com.xuexiang.xupdate.utils.ColorUtils;
import com.xuexiang.xupdate.utils.DrawableUtils;
import com.xuexiang.xupdate.utils.UpdateUtils;
import com.xuexiang.xupdate.widget.BaseDialog;
import com.xuexiang.xupdate.widget.NumberProgressBar;
import java.io.File;

public class UpdateDialog
extends BaseDialog
implements View.OnClickListener {
    private ImageView mIvTop;
    private TextView mTvTitle;
    private TextView mTvUpdateInfo;
    private Button mBtnUpdate;
    private Button mBtnBackgroundUpdate;
    private TextView mTvIgnore;
    private NumberProgressBar mNumberProgressBar;
    private LinearLayout mLlClose;
    private ImageView mIvClose;
    private UpdateEntity mUpdateEntity;
    private IUpdateProxy mIUpdateProxy;
    private PromptEntity mPromptEntity;
    private OnFileDownloadListener mOnFileDownloadListener = new OnFileDownloadListener(){

        @Override
        public void onStart() {
            if (UpdateDialog.this.isShowing()) {
                UpdateDialog.this.mNumberProgressBar.setVisibility(0);
                UpdateDialog.this.mBtnUpdate.setVisibility(8);
                if (UpdateDialog.this.mPromptEntity.isSupportBackgroundUpdate()) {
                    UpdateDialog.this.mBtnBackgroundUpdate.setVisibility(0);
                } else {
                    UpdateDialog.this.mBtnBackgroundUpdate.setVisibility(8);
                }
            }
        }

        @Override
        public void onProgress(float progress, long total) {
            if (UpdateDialog.this.isShowing()) {
                UpdateDialog.this.mNumberProgressBar.setProgress(Math.round(progress * 100.0f));
                UpdateDialog.this.mNumberProgressBar.setMax(100);
            }
        }

        @Override
        public boolean onCompleted(File file) {
            if (UpdateDialog.this.isShowing()) {
                UpdateDialog.this.mBtnBackgroundUpdate.setVisibility(8);
                if (UpdateDialog.this.mUpdateEntity.isForce()) {
                    UpdateDialog.this.showInstallButton(file);
                } else {
                    UpdateDialog.this.dismiss();
                }
            }
            return true;
        }

        @Override
        public void onError(Throwable throwable) {
            if (UpdateDialog.this.isShowing()) {
                UpdateDialog.this.dismiss();
            }
        }
    };

    public static UpdateDialog newInstance(@NonNull UpdateEntity updateEntity, @NonNull IUpdateProxy updateProxy, PromptEntity promptEntity) {
        UpdateDialog dialog = new UpdateDialog(updateProxy.getContext());
        dialog.setIUpdateProxy(updateProxy).setUpdateEntity(updateEntity).setPromptEntity(promptEntity);
        dialog.initTheme(promptEntity.getThemeColor(), promptEntity.getTopResId(), promptEntity.getWidthRatio(), promptEntity.getHeightRatio());
        return dialog;
    }

    private UpdateDialog(Context context) {
        super(context, R.layout.xupdate_dialog_app);
    }

    public UpdateDialog setPromptEntity(PromptEntity promptEntity) {
        this.mPromptEntity = promptEntity;
        return this;
    }

    @Override
    protected void initViews() {
        this.mIvTop = (ImageView)this.findViewById(R.id.iv_top);
        this.mTvTitle = (TextView)this.findViewById(R.id.tv_title);
        this.mTvUpdateInfo = (TextView)this.findViewById(R.id.tv_update_info);
        this.mBtnUpdate = (Button)this.findViewById(R.id.btn_update);
        this.mBtnBackgroundUpdate = (Button)this.findViewById(R.id.btn_background_update);
        this.mTvIgnore = (TextView)this.findViewById(R.id.tv_ignore);
        this.mNumberProgressBar = (NumberProgressBar)((Object)this.findViewById(R.id.npb_progress));
        this.mLlClose = (LinearLayout)this.findViewById(R.id.ll_close);
        this.mIvClose = (ImageView)this.findViewById(R.id.iv_close);
    }

    @Override
    protected void initListeners() {
        this.mBtnUpdate.setOnClickListener((View.OnClickListener)this);
        this.mBtnBackgroundUpdate.setOnClickListener((View.OnClickListener)this);
        this.mIvClose.setOnClickListener((View.OnClickListener)this);
        this.mTvIgnore.setOnClickListener((View.OnClickListener)this);
        this.setCancelable(false);
        this.setCanceledOnTouchOutside(false);
    }

    public void show() {
        _XUpdate.setIsShowUpdatePrompter(true);
        super.show();
    }

    public void dismiss() {
        _XUpdate.setIsShowUpdatePrompter(false);
        super.dismiss();
    }

    public UpdateDialog setUpdateEntity(UpdateEntity updateEntity) {
        this.mUpdateEntity = updateEntity;
        this.initUpdateInfo(this.mUpdateEntity);
        return this;
    }

    private void initUpdateInfo(UpdateEntity updateEntity) {
        String newVersion = updateEntity.getVersionName();
        String updateInfo = UpdateUtils.getDisplayUpdateInfo(this.getContext(), updateEntity);
        this.mTvUpdateInfo.setText((CharSequence)updateInfo);
        this.mTvTitle.setText((CharSequence)String.format(this.getString(R.string.xupdate_lab_ready_update), newVersion));
        if (UpdateUtils.isApkDownloaded(this.mUpdateEntity)) {
            this.showInstallButton(UpdateUtils.getApkFileByUpdateEntity(this.mUpdateEntity));
        }
        if (updateEntity.isForce()) {
            this.mLlClose.setVisibility(8);
        } else if (updateEntity.isIgnorable()) {
            this.mTvIgnore.setVisibility(0);
        }
    }

    private void initTheme(@ColorInt int themeColor, @DrawableRes int topResId, float widthRatio, float heightRatio) {
        if (themeColor == -1) {
            themeColor = ColorUtils.getColor(this.getContext(), R.color.xupdate_default_theme_color);
        }
        if (topResId == -1) {
            topResId = R.drawable.xupdate_bg_app_top;
        }
        this.setDialogTheme(themeColor, topResId, widthRatio, heightRatio);
    }

    private void setDialogTheme(int themeColor, int topResId, float widthRatio, float heightRatio) {
        this.mIvTop.setImageResource(topResId);
        this.mBtnUpdate.setBackgroundDrawable((Drawable)DrawableUtils.getDrawable(UpdateUtils.dip2px(4, this.getContext()), themeColor));
        this.mBtnBackgroundUpdate.setBackgroundDrawable((Drawable)DrawableUtils.getDrawable(UpdateUtils.dip2px(4, this.getContext()), themeColor));
        this.mNumberProgressBar.setProgressTextColor(themeColor);
        this.mNumberProgressBar.setReachedBarColor(themeColor);
        this.mBtnUpdate.setTextColor(ColorUtils.isColorDark(themeColor) ? -1 : -16777216);
        Window window = this.getWindow();
        if (window != null) {
            WindowManager.LayoutParams lp = window.getAttributes();
            DisplayMetrics displayMetrics = this.getContext().getResources().getDisplayMetrics();
            if (widthRatio > 0.0f && widthRatio < 1.0f) {
                lp.width = (int)((float)displayMetrics.widthPixels * widthRatio);
            }
            if (heightRatio > 0.0f && heightRatio < 1.0f) {
                lp.height = (int)((float)displayMetrics.heightPixels * heightRatio);
            }
            window.setAttributes(lp);
        }
    }

    public UpdateDialog setIUpdateProxy(IUpdateProxy updateProxy) {
        this.mIUpdateProxy = updateProxy;
        return this;
    }

    public void onClick(View view) {
        int i = view.getId();
        if (i == R.id.btn_update) {
            int flag = ActivityCompat.checkSelfPermission((Context)this.getContext(), (String)"android.permission.WRITE_EXTERNAL_STORAGE");
            if (flag != 0) {
                ActivityCompat.requestPermissions((Activity)((Activity)this.mIUpdateProxy.getContext()), (String[])new String[]{"android.permission.WRITE_EXTERNAL_STORAGE"}, (int)111);
            } else {
                this.installApp();
            }
        } else if (i == R.id.btn_background_update) {
            this.mIUpdateProxy.backgroundDownload();
            this.dismiss();
        } else if (i == R.id.iv_close) {
            this.mIUpdateProxy.cancelDownload();
            this.dismiss();
        } else if (i == R.id.tv_ignore) {
            UpdateUtils.saveIgnoreVersion(this.getContext(), this.mUpdateEntity.getVersionName());
            this.dismiss();
        }
    }

    private void installApp() {
        if (UpdateUtils.isApkDownloaded(this.mUpdateEntity)) {
            this.onInstallApk();
            if (!this.mUpdateEntity.isForce()) {
                this.dismiss();
            } else {
                this.showInstallButton(UpdateUtils.getApkFileByUpdateEntity(this.mUpdateEntity));
            }
        } else {
            if (this.mIUpdateProxy != null) {
                this.mIUpdateProxy.startDownload(this.mUpdateEntity, this.mOnFileDownloadListener);
            }
            if (this.mUpdateEntity.isIgnorable()) {
                this.mTvIgnore.setVisibility(8);
            }
        }
    }

    private void showInstallButton(final File apkFile) {
        this.mNumberProgressBar.setVisibility(8);
        this.mBtnUpdate.setText(R.string.xupdate_lab_install);
        this.mBtnUpdate.setVisibility(0);
        this.mBtnUpdate.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                UpdateDialog.this.onInstallApk(apkFile);
            }
        });
    }

    private void onInstallApk() {
        _XUpdate.startInstallApk(this.getContext(), UpdateUtils.getApkFileByUpdateEntity(this.mUpdateEntity), this.mUpdateEntity.getDownLoadEntity());
    }

    private void onInstallApk(File apkFile) {
        _XUpdate.startInstallApk(this.getContext(), apkFile, this.mUpdateEntity.getDownLoadEntity());
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        _XUpdate.setIsShowUpdatePrompter(true);
    }

    public void onDetachedFromWindow() {
        _XUpdate.setIsShowUpdatePrompter(false);
        super.onDetachedFromWindow();
    }
}

