/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xupdate.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.View;
import com.xuexiang.xupdate.R;

public class NumberProgressBar
extends View {
    private static final String INSTANCE_STATE = "saved_instance";
    private static final String INSTANCE_TEXT_COLOR = "text_color";
    private static final String INSTANCE_TEXT_SIZE = "text_size";
    private static final String INSTANCE_REACHED_BAR_HEIGHT = "reached_bar_height";
    private static final String INSTANCE_REACHED_BAR_COLOR = "reached_bar_color";
    private static final String INSTANCE_UNREACHED_BAR_HEIGHT = "unreached_bar_height";
    private static final String INSTANCE_UNREACHED_BAR_COLOR = "unreached_bar_color";
    private static final String INSTANCE_MAX = "max";
    private static final String INSTANCE_PROGRESS = "progress";
    private static final String INSTANCE_SUFFIX = "suffix";
    private static final String INSTANCE_PREFIX = "prefix";
    private static final String INSTANCE_TEXT_VISIBILITY = "text_visibility";
    private static final int PROGRESS_TEXT_VISIBLE = 0;
    private int mMaxProgress = 100;
    private int mCurrentProgress = 0;
    private int mReachedBarColor;
    private int mUnreachedBarColor;
    private int mTextColor;
    private float mTextSize;
    private float mReachedBarHeight;
    private float mUnreachedBarHeight;
    private String mSuffix = "%";
    private String mPrefix = "";
    private float mDrawTextStart;
    private float mDrawTextEnd;
    private String mCurrentDrawText;
    private Paint mReachedBarPaint;
    private Paint mUnreachedBarPaint;
    private Paint mTextPaint;
    private RectF mUnreachedRectF = new RectF(0.0f, 0.0f, 0.0f, 0.0f);
    private RectF mReachedRectF = new RectF(0.0f, 0.0f, 0.0f, 0.0f);
    private float mOffset;
    private boolean mDrawUnreachedBar = true;
    private boolean mDrawReachedBar = true;
    private boolean mIfDrawText = true;
    private OnProgressBarListener mListener;

    public NumberProgressBar(Context context) {
        this(context, null);
    }

    public NumberProgressBar(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public NumberProgressBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        float default_reached_bar_height = this.dp2px(1.5f);
        float default_unreached_bar_height = this.dp2px(1.0f);
        float default_text_size = this.sp2px(10.0f);
        float default_progress_text_offset = this.dp2px(3.0f);
        TypedArray attributes = context.getTheme().obtainStyledAttributes(attrs, R.styleable.XUpdate_ProgressBar, defStyleAttr, 0);
        int default_reached_color = Color.rgb((int)66, (int)145, (int)241);
        this.mReachedBarColor = attributes.getColor(R.styleable.XUpdate_ProgressBar_progress_reached_color, default_reached_color);
        int default_unreached_color = Color.rgb((int)204, (int)204, (int)204);
        this.mUnreachedBarColor = attributes.getColor(R.styleable.XUpdate_ProgressBar_progress_unreached_color, default_unreached_color);
        int default_text_color = Color.rgb((int)66, (int)145, (int)241);
        this.mTextColor = attributes.getColor(R.styleable.XUpdate_ProgressBar_progress_text_color, default_text_color);
        this.mTextSize = attributes.getDimension(R.styleable.XUpdate_ProgressBar_progress_text_size, default_text_size);
        this.mReachedBarHeight = attributes.getDimension(R.styleable.XUpdate_ProgressBar_progress_reached_bar_height, default_reached_bar_height);
        this.mUnreachedBarHeight = attributes.getDimension(R.styleable.XUpdate_ProgressBar_progress_unreached_bar_height, default_unreached_bar_height);
        this.mOffset = attributes.getDimension(R.styleable.XUpdate_ProgressBar_progress_text_offset, default_progress_text_offset);
        int textVisible = attributes.getInt(R.styleable.XUpdate_ProgressBar_progress_text_visibility, 0);
        if (textVisible != 0) {
            this.mIfDrawText = false;
        }
        this.setProgress(attributes.getInt(R.styleable.XUpdate_ProgressBar_progress_current, 0));
        this.setMax(attributes.getInt(R.styleable.XUpdate_ProgressBar_progress_max, 100));
        attributes.recycle();
        this.initializePainters();
    }

    protected int getSuggestedMinimumWidth() {
        return (int)this.mTextSize;
    }

    protected int getSuggestedMinimumHeight() {
        return Math.max((int)this.mTextSize, Math.max((int)this.mReachedBarHeight, (int)this.mUnreachedBarHeight));
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(this.measure(widthMeasureSpec, true), this.measure(heightMeasureSpec, false));
    }

    private int measure(int measureSpec, boolean isWidth) {
        int result;
        int padding;
        int mode = View.MeasureSpec.getMode((int)measureSpec);
        int size = View.MeasureSpec.getSize((int)measureSpec);
        int n = padding = isWidth ? this.getPaddingLeft() + this.getPaddingRight() : this.getPaddingTop() + this.getPaddingBottom();
        if (mode == 0x40000000) {
            result = size;
        } else {
            result = isWidth ? this.getSuggestedMinimumWidth() : this.getSuggestedMinimumHeight();
            result += padding;
            if (mode == Integer.MIN_VALUE) {
                result = isWidth ? Math.max(result, size) : Math.min(result, size);
            }
        }
        return result;
    }

    protected void onDraw(Canvas canvas) {
        if (this.mIfDrawText) {
            this.calculateDrawRectF();
        } else {
            this.calculateDrawRectFWithoutProgressText();
        }
        if (this.mDrawReachedBar) {
            canvas.drawRect(this.mReachedRectF, this.mReachedBarPaint);
        }
        if (this.mDrawUnreachedBar) {
            canvas.drawRect(this.mUnreachedRectF, this.mUnreachedBarPaint);
        }
        if (this.mIfDrawText) {
            canvas.drawText(this.mCurrentDrawText, this.mDrawTextStart, this.mDrawTextEnd, this.mTextPaint);
        }
    }

    private void initializePainters() {
        this.mReachedBarPaint = new Paint(1);
        this.mReachedBarPaint.setColor(this.mReachedBarColor);
        this.mUnreachedBarPaint = new Paint(1);
        this.mUnreachedBarPaint.setColor(this.mUnreachedBarColor);
        this.mTextPaint = new Paint(1);
        this.mTextPaint.setColor(this.mTextColor);
        this.mTextPaint.setTextSize(this.mTextSize);
    }

    private void calculateDrawRectFWithoutProgressText() {
        this.mReachedRectF.left = this.getPaddingLeft();
        this.mReachedRectF.top = (float)this.getHeight() / 2.0f - this.mReachedBarHeight / 2.0f;
        this.mReachedRectF.right = (float)(this.getWidth() - this.getPaddingLeft() - this.getPaddingRight()) / ((float)this.getMax() * 1.0f) * (float)this.getProgress() + (float)this.getPaddingLeft();
        this.mReachedRectF.bottom = (float)this.getHeight() / 2.0f + this.mReachedBarHeight / 2.0f;
        this.mUnreachedRectF.left = this.mReachedRectF.right;
        this.mUnreachedRectF.right = this.getWidth() - this.getPaddingRight();
        this.mUnreachedRectF.top = (float)this.getHeight() / 2.0f + -this.mUnreachedBarHeight / 2.0f;
        this.mUnreachedRectF.bottom = (float)this.getHeight() / 2.0f + this.mUnreachedBarHeight / 2.0f;
    }

    @SuppressLint(value={"DefaultLocale"})
    private void calculateDrawRectF() {
        float unreachedBarStart;
        this.mCurrentDrawText = String.format("%d", this.getProgress() * 100 / this.getMax());
        this.mCurrentDrawText = this.mPrefix + this.mCurrentDrawText + this.mSuffix;
        float drawTextWidth = this.mTextPaint.measureText(this.mCurrentDrawText);
        if (this.getProgress() == 0) {
            this.mDrawReachedBar = false;
            this.mDrawTextStart = this.getPaddingLeft();
        } else {
            this.mDrawReachedBar = true;
            this.mReachedRectF.left = this.getPaddingLeft();
            this.mReachedRectF.top = (float)this.getHeight() / 2.0f - this.mReachedBarHeight / 2.0f;
            this.mReachedRectF.right = (float)(this.getWidth() - this.getPaddingLeft() - this.getPaddingRight()) / ((float)this.getMax() * 1.0f) * (float)this.getProgress() - this.mOffset + (float)this.getPaddingLeft();
            this.mReachedRectF.bottom = (float)this.getHeight() / 2.0f + this.mReachedBarHeight / 2.0f;
            this.mDrawTextStart = this.mReachedRectF.right + this.mOffset;
        }
        this.mDrawTextEnd = (int)((float)this.getHeight() / 2.0f - (this.mTextPaint.descent() + this.mTextPaint.ascent()) / 2.0f);
        if (this.mDrawTextStart + drawTextWidth >= (float)(this.getWidth() - this.getPaddingRight())) {
            this.mDrawTextStart = (float)(this.getWidth() - this.getPaddingRight()) - drawTextWidth;
            this.mReachedRectF.right = this.mDrawTextStart - this.mOffset;
        }
        if ((unreachedBarStart = this.mDrawTextStart + drawTextWidth + this.mOffset) >= (float)(this.getWidth() - this.getPaddingRight())) {
            this.mDrawUnreachedBar = false;
        } else {
            this.mDrawUnreachedBar = true;
            this.mUnreachedRectF.left = unreachedBarStart;
            this.mUnreachedRectF.right = this.getWidth() - this.getPaddingRight();
            this.mUnreachedRectF.top = (float)this.getHeight() / 2.0f + -this.mUnreachedBarHeight / 2.0f;
            this.mUnreachedRectF.bottom = (float)this.getHeight() / 2.0f + this.mUnreachedBarHeight / 2.0f;
        }
    }

    public int getTextColor() {
        return this.mTextColor;
    }

    public float getProgressTextSize() {
        return this.mTextSize;
    }

    public void setProgressTextSize(float textSize) {
        this.mTextSize = textSize;
        this.mTextPaint.setTextSize(this.mTextSize);
        this.invalidate();
    }

    public int getUnreachedBarColor() {
        return this.mUnreachedBarColor;
    }

    public void setUnreachedBarColor(int barColor) {
        this.mUnreachedBarColor = barColor;
        this.mUnreachedBarPaint.setColor(this.mUnreachedBarColor);
        this.invalidate();
    }

    public int getReachedBarColor() {
        return this.mReachedBarColor;
    }

    public void setReachedBarColor(int progressColor) {
        this.mReachedBarColor = progressColor;
        this.mReachedBarPaint.setColor(this.mReachedBarColor);
        this.invalidate();
    }

    public int getProgress() {
        return this.mCurrentProgress;
    }

    public void setProgress(int progress) {
        if (progress <= this.getMax() && progress >= 0) {
            this.mCurrentProgress = progress;
            this.invalidate();
        }
    }

    public int getMax() {
        return this.mMaxProgress;
    }

    public void setMax(int maxProgress) {
        if (maxProgress > 0) {
            this.mMaxProgress = maxProgress;
            this.invalidate();
        }
    }

    public float getReachedBarHeight() {
        return this.mReachedBarHeight;
    }

    public void setReachedBarHeight(float height) {
        this.mReachedBarHeight = height;
    }

    public float getUnreachedBarHeight() {
        return this.mUnreachedBarHeight;
    }

    public void setUnreachedBarHeight(float height) {
        this.mUnreachedBarHeight = height;
    }

    public void setProgressTextColor(int textColor) {
        this.mTextColor = textColor;
        this.mTextPaint.setColor(this.mTextColor);
        this.invalidate();
    }

    public String getSuffix() {
        return this.mSuffix;
    }

    public void setSuffix(String suffix) {
        this.mSuffix = suffix == null ? "" : suffix;
    }

    public String getPrefix() {
        return this.mPrefix;
    }

    public void setPrefix(String prefix) {
        this.mPrefix = prefix == null ? "" : prefix;
    }

    public void incrementProgressBy(int by) {
        if (by > 0) {
            this.setProgress(this.getProgress() + by);
        }
        if (this.mListener != null) {
            this.mListener.onProgressChange(this.getProgress(), this.getMax());
        }
    }

    protected Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable(INSTANCE_STATE, super.onSaveInstanceState());
        bundle.putInt(INSTANCE_TEXT_COLOR, this.getTextColor());
        bundle.putFloat(INSTANCE_TEXT_SIZE, this.getProgressTextSize());
        bundle.putFloat(INSTANCE_REACHED_BAR_HEIGHT, this.getReachedBarHeight());
        bundle.putFloat(INSTANCE_UNREACHED_BAR_HEIGHT, this.getUnreachedBarHeight());
        bundle.putInt(INSTANCE_REACHED_BAR_COLOR, this.getReachedBarColor());
        bundle.putInt(INSTANCE_UNREACHED_BAR_COLOR, this.getUnreachedBarColor());
        bundle.putInt(INSTANCE_MAX, this.getMax());
        bundle.putInt(INSTANCE_PROGRESS, this.getProgress());
        bundle.putString(INSTANCE_SUFFIX, this.getSuffix());
        bundle.putString(INSTANCE_PREFIX, this.getPrefix());
        bundle.putBoolean(INSTANCE_TEXT_VISIBILITY, this.getProgressTextVisibility());
        return bundle;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (state instanceof Bundle) {
            Bundle bundle = (Bundle)state;
            this.mTextColor = bundle.getInt(INSTANCE_TEXT_COLOR);
            this.mTextSize = bundle.getFloat(INSTANCE_TEXT_SIZE);
            this.mReachedBarHeight = bundle.getFloat(INSTANCE_REACHED_BAR_HEIGHT);
            this.mUnreachedBarHeight = bundle.getFloat(INSTANCE_UNREACHED_BAR_HEIGHT);
            this.mReachedBarColor = bundle.getInt(INSTANCE_REACHED_BAR_COLOR);
            this.mUnreachedBarColor = bundle.getInt(INSTANCE_UNREACHED_BAR_COLOR);
            this.initializePainters();
            this.setMax(bundle.getInt(INSTANCE_MAX));
            this.setProgress(bundle.getInt(INSTANCE_PROGRESS));
            this.setPrefix(bundle.getString(INSTANCE_PREFIX));
            this.setSuffix(bundle.getString(INSTANCE_SUFFIX));
            this.setProgressTextVisibility(bundle.getBoolean(INSTANCE_TEXT_VISIBILITY) ? ProgressTextVisibility.VISIBLE : ProgressTextVisibility.INVISIBLE);
            super.onRestoreInstanceState(bundle.getParcelable(INSTANCE_STATE));
            return;
        }
        super.onRestoreInstanceState(state);
    }

    public float dp2px(float dp) {
        float scale = this.getResources().getDisplayMetrics().density;
        return dp * scale + 0.5f;
    }

    public float sp2px(float sp) {
        float scale = this.getResources().getDisplayMetrics().scaledDensity;
        return sp * scale;
    }

    public boolean getProgressTextVisibility() {
        return this.mIfDrawText;
    }

    public void setProgressTextVisibility(ProgressTextVisibility visibility) {
        this.mIfDrawText = visibility == ProgressTextVisibility.VISIBLE;
        this.invalidate();
    }

    public void setOnProgressBarListener(OnProgressBarListener listener) {
        this.mListener = listener;
    }

    public static interface OnProgressBarListener {
        public void onProgressChange(int var1, int var2);
    }

    public static enum ProgressTextVisibility {
        VISIBLE,
        INVISIBLE;

    }
}

