/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xupdate.proxy.impl;

import android.text.TextUtils;
import com.xuexiang.xupdate.XUpdate;
import com.xuexiang.xupdate.entity.CheckVersionResult;
import com.xuexiang.xupdate.entity.UpdateEntity;
import com.xuexiang.xupdate.proxy.IUpdateParser;
import com.xuexiang.xupdate.utils.UpdateUtils;

public class DefaultUpdateParser
implements IUpdateParser {
    @Override
    public UpdateEntity parseJson(String json) {
        CheckVersionResult checkResult;
        if (!TextUtils.isEmpty((CharSequence)json) && (checkResult = UpdateUtils.fromJson(json, CheckVersionResult.class)) != null && checkResult.getCode() == 0) {
            checkResult = this.doLocalCompare(checkResult);
            UpdateEntity updateEntity = new UpdateEntity();
            if (checkResult.getUpdateStatus() == 0) {
                updateEntity.setHasUpdate(false);
            } else {
                if (checkResult.getUpdateStatus() == 2) {
                    updateEntity.setForce(true);
                }
                updateEntity.setHasUpdate(true).setUpdateContent(checkResult.getModifyContent()).setVersionCode(checkResult.getVersionCode()).setVersionName(checkResult.getVersionName()).setDownloadUrl(checkResult.getDownloadUrl()).setSize(checkResult.getApkSize()).setMd5(checkResult.getApkMd5());
            }
            return updateEntity;
        }
        return null;
    }

    private CheckVersionResult doLocalCompare(CheckVersionResult checkResult) {
        int lastVersionCode;
        if (checkResult.getUpdateStatus() != 0 && (lastVersionCode = checkResult.getVersionCode()) <= UpdateUtils.getVersionCode(XUpdate.getContext())) {
            checkResult.setRequireUpgrade(0);
        }
        return checkResult;
    }
}

