/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xupdate.proxy.impl;

import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.xuexiang.xupdate._XUpdate;
import com.xuexiang.xupdate.entity.UpdateEntity;
import com.xuexiang.xupdate.proxy.IUpdateChecker;
import com.xuexiang.xupdate.proxy.IUpdateHttpService;
import com.xuexiang.xupdate.proxy.IUpdateProxy;
import com.xuexiang.xupdate.service.DownloadService;
import com.xuexiang.xupdate.utils.UpdateUtils;
import java.util.Map;

public class DefaultUpdateChecker
implements IUpdateChecker {
    @Override
    public void onBeforeCheck() {
    }

    @Override
    public void checkVersion(boolean isGet, @NonNull String url, @NonNull Map<String, Object> params, final @NonNull IUpdateProxy updateProxy) {
        if (DownloadService.isRunning() || _XUpdate.isShowUpdatePrompter()) {
            updateProxy.onAfterCheck();
            _XUpdate.onUpdateError(2003);
            return;
        }
        if (isGet) {
            updateProxy.getIUpdateHttpService().asyncGet(url, params, new IUpdateHttpService.Callback(){

                @Override
                public void onSuccess(String result) {
                    DefaultUpdateChecker.this.onCheckSuccess(result, updateProxy);
                }

                @Override
                public void onError(Throwable error) {
                    DefaultUpdateChecker.this.onCheckError(updateProxy, error);
                }
            });
        } else {
            updateProxy.getIUpdateHttpService().asyncPost(url, params, new IUpdateHttpService.Callback(){

                @Override
                public void onSuccess(String result) {
                    DefaultUpdateChecker.this.onCheckSuccess(result, updateProxy);
                }

                @Override
                public void onError(Throwable error) {
                    DefaultUpdateChecker.this.onCheckError(updateProxy, error);
                }
            });
        }
    }

    @Override
    public void onAfterCheck() {
    }

    private void onCheckSuccess(String result, @NonNull IUpdateProxy updateProxy) {
        updateProxy.onAfterCheck();
        if (!TextUtils.isEmpty((CharSequence)result)) {
            this.processCheckResult(result, updateProxy);
        } else {
            _XUpdate.onUpdateError(2005);
        }
    }

    private void onCheckError(@NonNull IUpdateProxy updateProxy, Throwable error) {
        updateProxy.onAfterCheck();
        _XUpdate.onUpdateError(2000, error.getMessage());
    }

    @Override
    public void processCheckResult(@NonNull String result, @NonNull IUpdateProxy updateProxy) {
        try {
            UpdateEntity updateEntity = updateProxy.parseJson(result);
            if (updateEntity != null) {
                if (updateEntity.isHasUpdate()) {
                    if (UpdateUtils.isIgnoreVersion(updateProxy.getContext(), updateEntity.getVersionName())) {
                        _XUpdate.onUpdateError(2007);
                    } else if (TextUtils.isEmpty((CharSequence)updateEntity.getApkCacheDir())) {
                        _XUpdate.onUpdateError(2008);
                    } else {
                        updateProxy.findNewVersion(updateEntity, updateProxy);
                    }
                } else {
                    _XUpdate.onUpdateError(2004);
                }
            } else {
                _XUpdate.onUpdateError(2006, "json:" + result);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            _XUpdate.onUpdateError(2006, e.getMessage());
        }
    }
}

