/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.textview.autofit;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.os.Build;
import android.text.Editable;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.text.TextWatcher;
import android.text.method.SingleLineTransformationMethod;
import android.text.method.TransformationMethod;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.widget.TextView;
import com.xuexiang.xui.R;
import java.util.ArrayList;

public class AutoFitHelper {
    private static final int DEFAULT_MIN_TEXT_SIZE = 8;
    private static final float DEFAULT_PRECISION = 0.5f;
    private TextView mTextView;
    private TextPaint mPaint;
    private float mTextSize;
    private int mMaxLines;
    private float mMinTextSize;
    private float mMaxTextSize;
    private float mPrecision;
    private boolean mEnabled;
    private boolean mIsAutoFitting;
    private ArrayList<OnTextSizeChangeListener> mListeners;
    private TextWatcher mTextWatcher = new AutofitTextWatcher();
    private View.OnLayoutChangeListener mOnLayoutChangeListener = new AutoFitOnLayoutChangeListener();

    public static AutoFitHelper create(TextView view) {
        return AutoFitHelper.create(view, null, 0);
    }

    public static AutoFitHelper create(TextView view, AttributeSet attrs) {
        return AutoFitHelper.create(view, attrs, 0);
    }

    public static AutoFitHelper create(TextView view, AttributeSet attrs, int defStyle) {
        AutoFitHelper helper = new AutoFitHelper(view);
        boolean enableFit = true;
        if (attrs != null) {
            Context context = view.getContext();
            int minTextSize = (int)helper.getMinTextSize();
            float precision = helper.getPrecision();
            TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.AutoFitTextView, defStyle, 0);
            enableFit = ta.getBoolean(R.styleable.AutoFitTextView_aftv_enable, enableFit);
            minTextSize = ta.getDimensionPixelSize(R.styleable.AutoFitTextView_aftv_minTextSize, minTextSize);
            precision = ta.getFloat(R.styleable.AutoFitTextView_aftv_precision, precision);
            ta.recycle();
            helper.setMinTextSize(0, minTextSize).setPrecision(precision);
        }
        helper.setEnabled(enableFit);
        return helper;
    }

    private static void autoFit(TextView view, TextPaint paint, float minTextSize, float maxTextSize, int maxLines, float precision) {
        float size;
        if (maxLines <= 0 || maxLines == Integer.MAX_VALUE) {
            return;
        }
        int targetWidth = view.getWidth() - view.getPaddingLeft() - view.getPaddingRight();
        if (targetWidth <= 0) {
            return;
        }
        CharSequence text = view.getText();
        TransformationMethod method = view.getTransformationMethod();
        if (method != null) {
            text = method.getTransformation(text, (View)view);
        }
        Context context = view.getContext();
        Resources r = Resources.getSystem();
        float high = size = maxTextSize;
        float low = 0.0f;
        if (context != null) {
            r = context.getResources();
        }
        DisplayMetrics displayMetrics = r.getDisplayMetrics();
        paint.set(view.getPaint());
        paint.setTextSize(size);
        if (maxLines == 1 && paint.measureText(text, 0, text.length()) > (float)targetWidth || AutoFitHelper.getLineCount(text, paint, size, targetWidth, displayMetrics) > maxLines) {
            size = AutoFitHelper.getAutoFitTextSize(text, paint, targetWidth, maxLines, low, high, precision, displayMetrics);
        }
        if (size < minTextSize) {
            size = minTextSize;
        }
        view.setTextSize(0, size);
    }

    private static float getAutoFitTextSize(CharSequence text, TextPaint paint, float targetWidth, int maxLines, float low, float high, float precision, DisplayMetrics displayMetrics) {
        float mid = (low + high) / 2.0f;
        int lineCount = 1;
        StaticLayout layout2 = null;
        paint.setTextSize(TypedValue.applyDimension((int)0, (float)mid, (DisplayMetrics)displayMetrics));
        if (maxLines != 1) {
            layout2 = new StaticLayout(text, paint, (int)targetWidth, Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, true);
            lineCount = layout2.getLineCount();
        }
        if (lineCount > maxLines) {
            if (high - low < precision) {
                return low;
            }
            return AutoFitHelper.getAutoFitTextSize(text, paint, targetWidth, maxLines, low, mid, precision, displayMetrics);
        }
        if (lineCount < maxLines) {
            return AutoFitHelper.getAutoFitTextSize(text, paint, targetWidth, maxLines, mid, high, precision, displayMetrics);
        }
        float maxLineWidth = 0.0f;
        if (maxLines == 1) {
            maxLineWidth = paint.measureText(text, 0, text.length());
        } else {
            for (int i = 0; i < lineCount; ++i) {
                if (!(layout2.getLineWidth(i) > maxLineWidth)) continue;
                maxLineWidth = layout2.getLineWidth(i);
            }
        }
        if (high - low < precision) {
            return low;
        }
        if (maxLineWidth > targetWidth) {
            return AutoFitHelper.getAutoFitTextSize(text, paint, targetWidth, maxLines, low, mid, precision, displayMetrics);
        }
        if (maxLineWidth < targetWidth) {
            return AutoFitHelper.getAutoFitTextSize(text, paint, targetWidth, maxLines, mid, high, precision, displayMetrics);
        }
        return mid;
    }

    private static int getLineCount(CharSequence text, TextPaint paint, float size, float width, DisplayMetrics displayMetrics) {
        paint.setTextSize(TypedValue.applyDimension((int)0, (float)size, (DisplayMetrics)displayMetrics));
        StaticLayout layout2 = new StaticLayout(text, paint, (int)width, Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, true);
        return layout2.getLineCount();
    }

    private static int getMaxLines(TextView view) {
        int maxLines = -1;
        TransformationMethod method = view.getTransformationMethod();
        if (method instanceof SingleLineTransformationMethod) {
            maxLines = 1;
        } else if (Build.VERSION.SDK_INT >= 16) {
            maxLines = view.getMaxLines();
        }
        return maxLines;
    }

    private AutoFitHelper(TextView view) {
        Context context = view.getContext();
        float scaledDensity = context.getResources().getDisplayMetrics().scaledDensity;
        this.mTextView = view;
        this.mPaint = new TextPaint();
        this.setRawTextSize(view.getTextSize());
        this.mMaxLines = AutoFitHelper.getMaxLines(view);
        this.mMinTextSize = scaledDensity * 8.0f;
        this.mMaxTextSize = this.mTextSize;
        this.mPrecision = 0.5f;
    }

    public AutoFitHelper addOnTextSizeChangeListener(OnTextSizeChangeListener listener) {
        if (this.mListeners == null) {
            this.mListeners = new ArrayList();
        }
        this.mListeners.add(listener);
        return this;
    }

    public AutoFitHelper removeOnTextSizeChangeListener(OnTextSizeChangeListener listener) {
        if (this.mListeners != null) {
            this.mListeners.remove(listener);
        }
        return this;
    }

    public float getPrecision() {
        return this.mPrecision;
    }

    public AutoFitHelper setPrecision(float precision) {
        if (this.mPrecision != precision) {
            this.mPrecision = precision;
            this.autoFit();
        }
        return this;
    }

    public float getMinTextSize() {
        return this.mMinTextSize;
    }

    public AutoFitHelper setMinTextSize(float size) {
        return this.setMinTextSize(2, size);
    }

    public AutoFitHelper setMinTextSize(int unit, float size) {
        Context context = this.mTextView.getContext();
        Resources r = Resources.getSystem();
        if (context != null) {
            r = context.getResources();
        }
        this.setRawMinTextSize(TypedValue.applyDimension((int)unit, (float)size, (DisplayMetrics)r.getDisplayMetrics()));
        return this;
    }

    private void setRawMinTextSize(float size) {
        if (size != this.mMinTextSize) {
            this.mMinTextSize = size;
            this.autoFit();
        }
    }

    public float getMaxTextSize() {
        return this.mMaxTextSize;
    }

    public AutoFitHelper setMaxTextSize(float size) {
        return this.setMaxTextSize(2, size);
    }

    public AutoFitHelper setMaxTextSize(int unit, float size) {
        Context context = this.mTextView.getContext();
        Resources r = Resources.getSystem();
        if (context != null) {
            r = context.getResources();
        }
        this.setRawMaxTextSize(TypedValue.applyDimension((int)unit, (float)size, (DisplayMetrics)r.getDisplayMetrics()));
        return this;
    }

    private void setRawMaxTextSize(float size) {
        if (size != this.mMaxTextSize) {
            this.mMaxTextSize = size;
            this.autoFit();
        }
    }

    public int getMaxLines() {
        return this.mMaxLines;
    }

    public AutoFitHelper setMaxLines(int lines) {
        if (this.mMaxLines != lines) {
            this.mMaxLines = lines;
            this.autoFit();
        }
        return this;
    }

    public boolean isEnabled() {
        return this.mEnabled;
    }

    public AutoFitHelper setEnabled(boolean enabled) {
        if (this.mEnabled != enabled) {
            this.mEnabled = enabled;
            if (enabled) {
                this.mTextView.addTextChangedListener(this.mTextWatcher);
                this.mTextView.addOnLayoutChangeListener(this.mOnLayoutChangeListener);
                this.autoFit();
            } else {
                this.mTextView.removeTextChangedListener(this.mTextWatcher);
                this.mTextView.removeOnLayoutChangeListener(this.mOnLayoutChangeListener);
                this.mTextView.setTextSize(0, this.mTextSize);
            }
        }
        return this;
    }

    public float getTextSize() {
        return this.mTextSize;
    }

    public void setTextSize(float size) {
        this.setTextSize(2, size);
    }

    public void setTextSize(int unit, float size) {
        if (this.mIsAutoFitting) {
            return;
        }
        Context context = this.mTextView.getContext();
        Resources r = Resources.getSystem();
        if (context != null) {
            r = context.getResources();
        }
        this.setRawTextSize(TypedValue.applyDimension((int)unit, (float)size, (DisplayMetrics)r.getDisplayMetrics()));
    }

    private void setRawTextSize(float size) {
        if (this.mTextSize != size) {
            this.mTextSize = size;
        }
    }

    private void autoFit() {
        float oldTextSize = this.mTextView.getTextSize();
        this.mIsAutoFitting = true;
        AutoFitHelper.autoFit(this.mTextView, this.mPaint, this.mMinTextSize, this.mMaxTextSize, this.mMaxLines, this.mPrecision);
        this.mIsAutoFitting = false;
        float textSize = this.mTextView.getTextSize();
        if (textSize != oldTextSize) {
            this.sendTextSizeChange(textSize, oldTextSize);
        }
    }

    private void sendTextSizeChange(float textSize, float oldTextSize) {
        if (this.mListeners == null) {
            return;
        }
        for (OnTextSizeChangeListener listener : this.mListeners) {
            listener.onTextSizeChange(textSize, oldTextSize);
        }
    }

    public static interface OnTextSizeChangeListener {
        public void onTextSizeChange(float var1, float var2);
    }

    private class AutoFitOnLayoutChangeListener
    implements View.OnLayoutChangeListener {
        private AutoFitOnLayoutChangeListener() {
        }

        public void onLayoutChange(View view, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
            AutoFitHelper.this.autoFit();
        }
    }

    private class AutofitTextWatcher
    implements TextWatcher {
        private AutofitTextWatcher() {
        }

        public void beforeTextChanged(CharSequence charSequence, int start, int count, int after) {
        }

        public void onTextChanged(CharSequence charSequence, int start, int before, int count) {
            AutoFitHelper.this.autoFit();
        }

        public void afterTextChanged(Editable editable) {
        }
    }
}

