/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.tabbar.vertical;

import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import com.xuexiang.xui.widget.tabbar.VerticalTabLayout;
import com.xuexiang.xui.widget.tabbar.vertical.TabView;
import java.util.List;

public class TabFragmentManager {
    private FragmentManager mManager;
    private int mContainerResId;
    private List<Fragment> mFragments;
    private VerticalTabLayout mTabLayout;
    private VerticalTabLayout.OnTabSelectedListener mListener;

    public TabFragmentManager(FragmentManager manager, List<Fragment> fragments, VerticalTabLayout tabLayout) {
        this.mManager = manager;
        this.mFragments = fragments;
        this.mTabLayout = tabLayout;
        this.mListener = new OnFragmentTabSelectedListener();
        this.mTabLayout.addOnTabSelectedListener(this.mListener);
    }

    public TabFragmentManager(FragmentManager manager, int containerResid, List<Fragment> fragments, VerticalTabLayout tabLayout) {
        this(manager, fragments, tabLayout);
        this.mContainerResId = containerResid;
        this.changeFragment();
    }

    public void changeFragment() {
        FragmentTransaction ft = this.mManager.beginTransaction();
        int position = this.mTabLayout.getSelectedTabPosition();
        List addedFragments = this.mManager.getFragments();
        for (int i = 0; i < this.mFragments.size(); ++i) {
            Fragment fragment = this.mFragments.get(i);
            if (!(addedFragments != null && addedFragments.contains(fragment) || this.mContainerResId == 0)) {
                ft.add(this.mContainerResId, fragment);
            }
            if (this.mFragments.size() > position && i == position || this.mFragments.size() <= position && i == this.mFragments.size() - 1) {
                ft.show(fragment);
                continue;
            }
            ft.hide(fragment);
        }
        ft.commit();
        this.mManager.executePendingTransactions();
    }

    public void detach() {
        FragmentTransaction ft = this.mManager.beginTransaction();
        for (Fragment fragment : this.mFragments) {
            ft.remove(fragment);
        }
        ft.commit();
        this.mManager.executePendingTransactions();
        this.mManager = null;
        this.mFragments = null;
        this.mTabLayout.removeOnTabSelectedListener(this.mListener);
        this.mListener = null;
        this.mTabLayout = null;
    }

    private class OnFragmentTabSelectedListener
    implements VerticalTabLayout.OnTabSelectedListener {
        private OnFragmentTabSelectedListener() {
        }

        @Override
        public void onTabSelected(TabView tab, int position) {
            TabFragmentManager.this.changeFragment();
        }

        @Override
        public void onTabUnselected(TabView tab, int position) {
        }

        @Override
        public void onTabReselected(TabView tab, int position) {
        }
    }
}

