/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.statelayout;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.AnimRes;
import android.support.annotation.StringRes;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.xuexiang.xui.R;
import com.xuexiang.xui.UIConfig;
import com.xuexiang.xui.widget.progress.materialprogressbar.MaterialProgressBar;
import com.xuexiang.xui.widget.statelayout.CustomStateOptions;
import com.xuexiang.xui.widget.statelayout.SimpleAnimationListener;

public class StatefulLayout
extends LinearLayout {
    private static final String MSG_ONE_CHILD = "StatefulLayout must have one child!";
    private boolean animationEnabled;
    private Animation inAnimation;
    private Animation outAnimation;
    private int animCounter;
    private View content;
    private LinearLayout stContainer;
    private MaterialProgressBar stProgress;
    private ImageView stImage;
    private TextView stMessage;
    private Button stButton;

    public StatefulLayout(Context context) {
        this(context, null);
    }

    public StatefulLayout(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.StatefulLayoutStyle);
    }

    public StatefulLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initAttrs(context, attrs, defStyleAttr);
    }

    private void initAttrs(Context context, AttributeSet attrs, int defStyleAttr) {
        if (this.isInEditMode()) {
            return;
        }
        TypedArray array = context.obtainStyledAttributes(attrs, R.styleable.StatefulLayout, defStyleAttr, 0);
        this.animationEnabled = array.getBoolean(R.styleable.StatefulLayout_stf_animationEnabled, UIConfig.getInstance().getStateLayoutConfig().animationEnabled);
        int inAnimationResId = array.getResourceId(R.styleable.StatefulLayout_stf_inAnimation, -1);
        this.inAnimation = inAnimationResId != -1 ? this.anim(inAnimationResId) : UIConfig.getInstance().getStateLayoutConfig().inAnimation;
        int outAnimationResId = array.getResourceId(R.styleable.StatefulLayout_stf_outAnimation, -1);
        this.outAnimation = inAnimationResId != -1 ? this.anim(outAnimationResId) : UIConfig.getInstance().getStateLayoutConfig().outAnimation;
        array.recycle();
    }

    public boolean isAnimationEnabled() {
        return this.animationEnabled;
    }

    public StatefulLayout setAnimationEnabled(boolean animationEnabled) {
        this.animationEnabled = animationEnabled;
        return this;
    }

    public Animation getInAnimation() {
        return this.inAnimation;
    }

    public StatefulLayout setInAnimation(Animation animation) {
        this.inAnimation = animation;
        return this;
    }

    public StatefulLayout setInAnimation(@AnimRes int anim2) {
        this.inAnimation = this.anim(anim2);
        return this;
    }

    public Animation getOutAnimation() {
        return this.outAnimation;
    }

    public StatefulLayout setOutAnimation(Animation animation) {
        this.outAnimation = animation;
        return this;
    }

    public StatefulLayout setOutAnimation(@AnimRes int anim2) {
        this.outAnimation = this.anim(anim2);
        return this;
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        if (this.getChildCount() > 1) {
            throw new IllegalStateException(MSG_ONE_CHILD);
        }
        if (this.isInEditMode()) {
            return;
        }
        this.setOrientation(1);
        this.content = this.getChildAt(0);
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.xui_layout_stateful_template, (ViewGroup)this, true);
        this.stContainer = (LinearLayout)this.findViewById(R.id.stContainer);
        this.stProgress = (MaterialProgressBar)this.findViewById(R.id.stProgress);
        this.stImage = (ImageView)this.findViewById(R.id.stImage);
        this.stMessage = (TextView)this.findViewById(R.id.stMessage);
        this.stButton = (Button)this.findViewById(R.id.stButton);
    }

    public void showContent() {
        if (this.isAnimationEnabled()) {
            this.stContainer.clearAnimation();
            this.content.clearAnimation();
            final int animCounterCopy = ++this.animCounter;
            if (this.stContainer.getVisibility() == 0) {
                this.outAnimation.setAnimationListener((Animation.AnimationListener)new SimpleAnimationListener(){

                    @Override
                    public void onAnimationEnd(Animation animation) {
                        if (StatefulLayout.this.animCounter != animCounterCopy) {
                            return;
                        }
                        StatefulLayout.this.stContainer.setVisibility(8);
                        StatefulLayout.this.content.setVisibility(0);
                        StatefulLayout.this.content.startAnimation(StatefulLayout.this.inAnimation);
                    }
                });
                this.stContainer.startAnimation(this.outAnimation);
            }
        } else {
            this.stContainer.setVisibility(8);
            this.content.setVisibility(0);
        }
    }

    public void showLoading() {
        this.showLoading(UIConfig.getInstance().getStateLayoutConfig().loadingMessageRes);
    }

    public void showLoading(@StringRes int resId) {
        this.showLoading(this.str(resId));
    }

    public void showLoading(String message) {
        this.showCustom(new CustomStateOptions().message(message).loading());
    }

    public void showEmpty() {
        this.showEmpty(UIConfig.getInstance().getStateLayoutConfig().emptyMessageRes);
    }

    public void showEmpty(@StringRes int resId) {
        this.showEmpty(this.str(resId));
    }

    public void showEmpty(String message) {
        this.showCustom(new CustomStateOptions().message(message).image(UIConfig.getInstance().getStateLayoutConfig().emptyImageRes));
    }

    public void showError(View.OnClickListener clickListener) {
        this.showError(UIConfig.getInstance().getStateLayoutConfig().errorMessageRes, clickListener);
    }

    public void showError(@StringRes int resId, View.OnClickListener clickListener) {
        this.showError(this.str(resId), clickListener);
    }

    public void showError(String message, View.OnClickListener clickListener) {
        this.showError(message, this.str(UIConfig.getInstance().getStateLayoutConfig().retryMessageRes), clickListener);
    }

    public void showError(String message, String buttonText, View.OnClickListener clickListener) {
        this.showCustom(new CustomStateOptions().message(message).image(UIConfig.getInstance().getStateLayoutConfig().errorImageRes).buttonText(buttonText).buttonClickListener(clickListener));
    }

    public void showOffline(View.OnClickListener clickListener) {
        this.showOffline(UIConfig.getInstance().getStateLayoutConfig().offlineMessageRes, clickListener);
    }

    public void showOffline(@StringRes int resId, View.OnClickListener clickListener) {
        this.showOffline(this.str(resId), clickListener);
    }

    public void showOffline(String message, View.OnClickListener clickListener) {
        this.showOffline(message, this.str(UIConfig.getInstance().getStateLayoutConfig().retryMessageRes), clickListener);
    }

    public void showOffline(String message, String buttonText, View.OnClickListener clickListener) {
        this.showCustom(new CustomStateOptions().message(message).image(UIConfig.getInstance().getStateLayoutConfig().offlineImageRes).buttonText(buttonText).buttonClickListener(clickListener));
    }

    public void showLocationOff(View.OnClickListener clickListener) {
        this.showLocationOff(UIConfig.getInstance().getStateLayoutConfig().locationOffMessageRes, clickListener);
    }

    public void showLocationOff(@StringRes int resId, View.OnClickListener clickListener) {
        this.showLocationOff(this.str(resId), clickListener);
    }

    public void showLocationOff(String message, View.OnClickListener clickListener) {
        this.showLocationOff(message, this.str(UIConfig.getInstance().getStateLayoutConfig().retryMessageRes), clickListener);
    }

    public void showLocationOff(String message, String buttonText, View.OnClickListener clickListener) {
        this.showCustom(new CustomStateOptions().message(message).image(UIConfig.getInstance().getStateLayoutConfig().locationOffImageRes).buttonText(buttonText).buttonClickListener(clickListener));
    }

    public void showCustom(final CustomStateOptions options) {
        if (this.isAnimationEnabled()) {
            this.stContainer.clearAnimation();
            this.content.clearAnimation();
            final int animCounterCopy = ++this.animCounter;
            if (this.stContainer.getVisibility() == 8) {
                this.outAnimation.setAnimationListener((Animation.AnimationListener)new SimpleAnimationListener(){

                    @Override
                    public void onAnimationEnd(Animation animation) {
                        if (animCounterCopy != StatefulLayout.this.animCounter) {
                            return;
                        }
                        StatefulLayout.this.content.setVisibility(8);
                        StatefulLayout.this.stContainer.setVisibility(0);
                        StatefulLayout.this.stContainer.startAnimation(StatefulLayout.this.inAnimation);
                    }
                });
                this.content.startAnimation(this.outAnimation);
                this.state(options);
            } else {
                this.outAnimation.setAnimationListener((Animation.AnimationListener)new SimpleAnimationListener(){

                    @Override
                    public void onAnimationEnd(Animation animation) {
                        if (animCounterCopy != StatefulLayout.this.animCounter) {
                            return;
                        }
                        StatefulLayout.this.state(options);
                        StatefulLayout.this.stContainer.startAnimation(StatefulLayout.this.inAnimation);
                    }
                });
                this.stContainer.startAnimation(this.outAnimation);
            }
        } else {
            this.content.setVisibility(8);
            this.stContainer.setVisibility(0);
            this.state(options);
        }
    }

    private void state(CustomStateOptions options) {
        if (!TextUtils.isEmpty((CharSequence)options.getMessage())) {
            this.stMessage.setVisibility(0);
            this.stMessage.setText((CharSequence)options.getMessage());
        } else {
            this.stMessage.setVisibility(8);
        }
        if (options.isLoading()) {
            this.stProgress.setVisibility(0);
            this.stImage.setVisibility(8);
            this.stButton.setVisibility(8);
        } else {
            this.stProgress.setVisibility(8);
            if (options.getImageRes() != 0) {
                this.stImage.setVisibility(0);
                this.stImage.setImageResource(options.getImageRes());
            } else {
                this.stImage.setVisibility(8);
            }
            if (options.getClickListener() != null) {
                this.stButton.setVisibility(0);
                this.stButton.setOnClickListener(options.getClickListener());
                if (!TextUtils.isEmpty((CharSequence)options.getButtonText())) {
                    this.stButton.setText((CharSequence)options.getButtonText());
                }
            } else {
                this.stButton.setVisibility(8);
            }
        }
    }

    private String str(@StringRes int resId) {
        return this.getContext().getString(resId);
    }

    private Animation anim(@AnimRes int resId) {
        return AnimationUtils.loadAnimation((Context)this.getContext(), (int)resId);
    }
}

