/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.searchview;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.Filter;
import android.widget.Filterable;
import android.widget.ImageView;
import android.widget.TextView;
import com.xuexiang.xui.R;
import java.util.ArrayList;
import java.util.List;

public class SearchAdapter
extends BaseAdapter
implements Filterable {
    private List<String> data;
    private String[] suggestions;
    private Drawable suggestionIcon;
    private LayoutInflater inflater;
    private boolean ellipsize;

    public SearchAdapter(Context context, String[] suggestions) {
        this.inflater = LayoutInflater.from((Context)context);
        this.data = new ArrayList<String>();
        this.suggestions = suggestions;
    }

    public SearchAdapter(Context context, String[] suggestions, Drawable suggestionIcon, boolean ellipsize) {
        this.inflater = LayoutInflater.from((Context)context);
        this.data = new ArrayList<String>();
        this.suggestions = suggestions;
        this.suggestionIcon = suggestionIcon;
        this.ellipsize = ellipsize;
    }

    public Filter getFilter() {
        return new Filter(){

            protected Filter.FilterResults performFiltering(CharSequence constraint) {
                Filter.FilterResults filterResults = new Filter.FilterResults();
                if (!TextUtils.isEmpty((CharSequence)constraint)) {
                    ArrayList<String> searchData = new ArrayList<String>();
                    for (String string2 : SearchAdapter.this.suggestions) {
                        if (!string2.toLowerCase().startsWith(constraint.toString().toLowerCase())) continue;
                        searchData.add(string2);
                    }
                    filterResults.values = searchData;
                    filterResults.count = searchData.size();
                }
                return filterResults;
            }

            protected void publishResults(CharSequence constraint, Filter.FilterResults results) {
                if (results.values != null) {
                    SearchAdapter.this.data = (List)results.values;
                    SearchAdapter.this.notifyDataSetChanged();
                }
            }
        };
    }

    public int getCount() {
        return this.data.size();
    }

    public Object getItem(int position) {
        return this.data.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        SuggestionsViewHolder viewHolder;
        if (convertView == null) {
            convertView = this.inflater.inflate(R.layout.xui_layout_search_view_suggest_item, parent, false);
            viewHolder = new SuggestionsViewHolder(convertView);
            convertView.setTag((Object)viewHolder);
        } else {
            viewHolder = (SuggestionsViewHolder)convertView.getTag();
        }
        String currentListData = (String)this.getItem(position);
        viewHolder.textView.setText((CharSequence)currentListData);
        if (this.ellipsize) {
            viewHolder.textView.setSingleLine();
            viewHolder.textView.setEllipsize(TextUtils.TruncateAt.END);
        }
        return convertView;
    }

    private class SuggestionsViewHolder {
        TextView textView;
        ImageView imageView;

        public SuggestionsViewHolder(View convertView) {
            this.textView = (TextView)convertView.findViewById(R.id.suggestion_text);
            if (SearchAdapter.this.suggestionIcon != null) {
                this.imageView = (ImageView)convertView.findViewById(R.id.suggestion_icon);
                this.imageView.setImageDrawable(SearchAdapter.this.suggestionIcon);
            }
        }
    }
}

