/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.progress.ratingbar;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import com.xuexiang.xui.R;
import com.xuexiang.xui.widget.progress.ratingbar.AnimationRatingBar;
import com.xuexiang.xui.widget.progress.ratingbar.PartialView;

public class RotationRatingBar
extends AnimationRatingBar {
    private static final long ANIMATION_DELAY = 15L;

    public RotationRatingBar(Context context) {
        super(context);
    }

    public RotationRatingBar(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public RotationRatingBar(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    protected void emptyRatingBar() {
        if (this.mRunnable != null) {
            this.mHandler.removeCallbacksAndMessages((Object)this.mRunnableToken);
        }
        long delay = 0L;
        for (final PartialView partialView : this.mPartialViews) {
            this.mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    partialView.setEmpty();
                }
            }, delay += 5L);
        }
    }

    @Override
    protected void fillRatingBar(float rating) {
        if (this.mRunnable != null) {
            this.mHandler.removeCallbacksAndMessages((Object)this.mRunnableToken);
        }
        for (PartialView partialView : this.mPartialViews) {
            double maxIntOfRating;
            int ratingViewId = (Integer)partialView.getTag();
            if ((double)ratingViewId > (maxIntOfRating = Math.ceil(rating))) {
                partialView.setEmpty();
                continue;
            }
            this.mRunnable = this.getAnimationRunnable(rating, partialView, ratingViewId, maxIntOfRating);
            this.postRunnable(this.mRunnable, 15L);
        }
    }

    @NonNull
    private Runnable getAnimationRunnable(final float rating, final PartialView partialView, final int ratingViewId, final double maxIntOfRating) {
        return new Runnable(){

            @Override
            public void run() {
                if ((double)ratingViewId == maxIntOfRating) {
                    partialView.setPartialFilled(rating);
                } else {
                    partialView.setFilled();
                }
                if ((float)ratingViewId == rating) {
                    Animation rotation = AnimationUtils.loadAnimation((Context)RotationRatingBar.this.getContext(), (int)R.anim.srb_rotation);
                    partialView.startAnimation(rotation);
                }
            }
        };
    }
}

