/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.popupwindow.popup;

import android.content.Context;
import android.view.View;
import android.widget.AdapterView;
import com.xuexiang.xui.R;
import com.xuexiang.xui.XUI;
import com.xuexiang.xui.adapter.simple.AdapterItem;
import com.xuexiang.xui.adapter.simple.XUISimpleAdapter;
import com.xuexiang.xui.utils.ResUtils;
import com.xuexiang.xui.widget.popupwindow.popup.XUIListPopup;
import java.util.List;

public class XUISimplePopup<T extends XUISimplePopup>
extends XUIListPopup {
    public XUISimplePopup(Context context, String[] listItems) {
        this(context, XUISimpleAdapter.create(context, listItems));
    }

    public XUISimplePopup(Context context, List<AdapterItem> listItems) {
        this(context, new XUISimpleAdapter(context, listItems));
    }

    public XUISimplePopup(Context context, AdapterItem[] listItems) {
        this(context, new XUISimpleAdapter(context, listItems));
    }

    public XUISimplePopup(Context context, XUISimpleAdapter adapter) {
        super(context, adapter);
    }

    @Override
    public T create(int maxHeight) {
        this.create(this.getPopupWidth(), maxHeight);
        return (T)this;
    }

    public T create(int maxHeight, OnPopupItemClickListener onItemClickListener) {
        return this.create(this.getPopupWidth(), maxHeight, onItemClickListener);
    }

    public T create(OnPopupItemClickListener onItemClickListener) {
        this.create(this.getPopupWidth());
        this.setOnPopupItemClickListener(onItemClickListener);
        return (T)this;
    }

    public T create(int width, int maxHeight, OnPopupItemClickListener onItemClickListener) {
        this.create(width, maxHeight);
        this.setOnPopupItemClickListener(onItemClickListener);
        return (T)this;
    }

    public T setOnPopupItemClickListener(final OnPopupItemClickListener onItemClickListener) {
        if (this.mListView != null) {
            this.mListView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

                public void onItemClick(AdapterView<?> adapterView, View view, int position, long id2) {
                    if (onItemClickListener != null) {
                        onItemClickListener.onItemClick(XUISimplePopup.this.getAdapter(), (AdapterItem)XUISimplePopup.this.getAdapter().getItem(position), position);
                    }
                    XUISimplePopup.this.dismiss();
                }
            });
        }
        return (T)this;
    }

    public void showDown(View v) {
        this.setPreferredDirection(1);
        this.show(v);
    }

    public void showUp(View v) {
        this.setPreferredDirection(0);
        this.show(v);
    }

    @Override
    public XUISimpleAdapter getAdapter() {
        return (XUISimpleAdapter)this.mAdapter;
    }

    private int getPopupWidth() {
        int width;
        switch (XUI.getScreenType()) {
            case 3: {
                width = ResUtils.getDimensionPixelSize(R.dimen.xui_popup_width_tablet_big);
                break;
            }
            case 2: {
                width = ResUtils.getDimensionPixelSize(R.dimen.xui_popup_width_tablet_small);
                break;
            }
            case 1: {
                width = ResUtils.getDimensionPixelSize(R.dimen.xui_popup_width_phone);
                break;
            }
            default: {
                width = ResUtils.getDimensionPixelSize(R.dimen.xui_popup_width_tablet_small);
            }
        }
        return width;
    }

    @Override
    public T setHasDivider(boolean hasDivider) {
        super.setHasDivider(hasDivider);
        return (T)this;
    }

    public static interface OnPopupItemClickListener {
        public void onItemClick(XUISimpleAdapter var1, AdapterItem var2, int var3);
    }
}

