/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.picker.widget;

import android.content.Context;
import android.graphics.Typeface;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.xuexiang.xui.R;
import com.xuexiang.xui.XUI;
import com.xuexiang.xui.widget.picker.widget.BasePickerView;
import com.xuexiang.xui.widget.picker.widget.WheelOptions;
import com.xuexiang.xui.widget.picker.widget.configure.PickerOptions;
import java.util.Arrays;
import java.util.List;
import uk.co.chrisjenx.calligraphy.HasTypeface;

public class OptionsPickerView<T>
extends BasePickerView
implements View.OnClickListener,
HasTypeface {
    private WheelOptions<T> wheelOptions;
    private static final String TAG_SUBMIT = "submit";
    private static final String TAG_CANCEL = "cancel";

    public OptionsPickerView(PickerOptions pickerOptions) {
        super(pickerOptions.context);
        this.mPickerOptions = pickerOptions;
        this.initView(pickerOptions.context);
    }

    private void initView(Context context) {
        this.setDialogOutSideCancelable();
        this.initViews();
        this.initAnim();
        this.initEvents();
        if (this.mPickerOptions.customListener == null) {
            if (this.isDialog()) {
                LayoutInflater.from((Context)context).inflate(R.layout.xui_layout_picker_view_options_dialog, this.contentContainer);
            } else {
                LayoutInflater.from((Context)context).inflate(R.layout.xui_layout_picker_view_options, this.contentContainer);
            }
            TextView tvTitle = (TextView)this.findViewById(R.id.tvTitle);
            LinearLayout llContent = (LinearLayout)this.findViewById(R.id.ll_content);
            Button btnSubmit = (Button)this.findViewById(R.id.btnSubmit);
            Button btnCancel = (Button)this.findViewById(R.id.btnCancel);
            btnSubmit.setTag((Object)TAG_SUBMIT);
            btnCancel.setTag((Object)TAG_CANCEL);
            btnSubmit.setOnClickListener((View.OnClickListener)this);
            btnCancel.setOnClickListener((View.OnClickListener)this);
            btnSubmit.setText((CharSequence)(TextUtils.isEmpty((CharSequence)this.mPickerOptions.textContentConfirm) ? context.getResources().getString(R.string.xui_picker_view_submit) : this.mPickerOptions.textContentConfirm));
            btnCancel.setText((CharSequence)(TextUtils.isEmpty((CharSequence)this.mPickerOptions.textContentCancel) ? context.getResources().getString(R.string.xui_picker_view_cancel) : this.mPickerOptions.textContentCancel));
            tvTitle.setText((CharSequence)(TextUtils.isEmpty((CharSequence)this.mPickerOptions.textContentTitle) ? "" : this.mPickerOptions.textContentTitle));
            btnSubmit.setTextColor(this.mPickerOptions.textColorConfirm);
            btnCancel.setTextColor(this.mPickerOptions.textColorCancel);
            tvTitle.setTextColor(this.mPickerOptions.textColorTitle);
            if (this.isDialog() && TextUtils.isEmpty((CharSequence)tvTitle.getText().toString())) {
                tvTitle.setVisibility(8);
            }
            llContent.setBackgroundColor(this.mPickerOptions.bgColorTitle);
            btnSubmit.setTextSize((float)this.mPickerOptions.textSizeSubmitCancel);
            btnCancel.setTextSize((float)this.mPickerOptions.textSizeSubmitCancel);
            tvTitle.setTextSize((float)this.mPickerOptions.textSizeTitle);
        } else {
            this.mPickerOptions.customListener.customLayout(LayoutInflater.from((Context)context).inflate(this.mPickerOptions.layoutRes, this.contentContainer));
        }
        LinearLayout optionsPicker = (LinearLayout)this.findViewById(R.id.options_picker);
        optionsPicker.setBackgroundColor(this.mPickerOptions.bgColorWheel);
        this.wheelOptions = new WheelOptions((View)optionsPicker, this.mPickerOptions.isRestoreItem);
        if (this.mPickerOptions.optionsSelectChangeListener != null) {
            this.wheelOptions.setOptionsSelectChangeListener(this.mPickerOptions.optionsSelectChangeListener);
        }
        this.wheelOptions.setTextContentSize(this.mPickerOptions.textSizeContent);
        this.wheelOptions.setLabels(this.mPickerOptions.label1, this.mPickerOptions.label2, this.mPickerOptions.label3);
        this.wheelOptions.setTextXOffset(this.mPickerOptions.x_offset_one, this.mPickerOptions.x_offset_two, this.mPickerOptions.x_offset_three);
        this.wheelOptions.setCyclic(this.mPickerOptions.cyclic1, this.mPickerOptions.cyclic2, this.mPickerOptions.cyclic3);
        if (XUI.getDefaultTypeface() == null) {
            this.wheelOptions.setTypeface(this.mPickerOptions.font);
        }
        this.setOutSideCancelable(this.mPickerOptions.cancelable);
        this.wheelOptions.setDividerColor(this.mPickerOptions.dividerColor);
        this.wheelOptions.setDividerType(this.mPickerOptions.dividerType);
        this.wheelOptions.setLineSpacingMultiplier(this.mPickerOptions.lineSpacingMultiplier);
        this.wheelOptions.setTextColorOut(this.mPickerOptions.textColorOut);
        this.wheelOptions.setTextColorCenter(this.mPickerOptions.textColorCenter);
        this.wheelOptions.isCenterLabel(this.mPickerOptions.isCenterLabel);
    }

    public void setTitleText(String text) {
        TextView tvTitle = (TextView)this.findViewById(R.id.tvTitle);
        if (tvTitle != null) {
            tvTitle.setText((CharSequence)text);
        }
    }

    public void setSelectOptions(int option1) {
        this.mPickerOptions.option1 = option1;
        this.reSetCurrentItems();
    }

    public void setSelectOptions(int option1, int option2) {
        this.mPickerOptions.option1 = option1;
        this.mPickerOptions.option2 = option2;
        this.reSetCurrentItems();
    }

    public void setSelectOptions(int option1, int option2, int option3) {
        this.mPickerOptions.option1 = option1;
        this.mPickerOptions.option2 = option2;
        this.mPickerOptions.option3 = option3;
        this.reSetCurrentItems();
    }

    private void reSetCurrentItems() {
        if (this.wheelOptions != null) {
            this.wheelOptions.setCurrentItems(this.mPickerOptions.option1, this.mPickerOptions.option2, this.mPickerOptions.option3);
        }
    }

    public void setPicker(@NonNull T[] optionsItems) {
        this.setPicker(Arrays.asList(optionsItems), null, null);
    }

    public void setPicker(List<T> optionsItems) {
        this.setPicker(optionsItems, null, null);
    }

    public void setPicker(List<T> options1Items, List<List<T>> options2Items) {
        this.setPicker(options1Items, options2Items, null);
    }

    public void setPicker(List<T> options1Items, List<List<T>> options2Items, List<List<List<T>>> options3Items) {
        this.wheelOptions.setPicker(options1Items, options2Items, options3Items);
        this.reSetCurrentItems();
    }

    public void setNPicker(@NonNull T[] options1Items, @NonNull T[] options2Items) {
        this.setNPicker(Arrays.asList(options1Items), Arrays.asList(options2Items));
    }

    public void setNPicker(List<T> options1Items, List<T> options2Items) {
        this.wheelOptions.setLinkage(false);
        this.wheelOptions.setNPicker(options1Items, options2Items, null);
        this.reSetCurrentItems();
    }

    public void setNPicker(@NonNull T[] options1Items, @NonNull T[] options2Items, @NonNull T[] options3Items) {
        this.setNPicker(Arrays.asList(options1Items), Arrays.asList(options2Items), Arrays.asList(options3Items));
    }

    public void setNPicker(List<T> options1Items, List<T> options2Items, List<T> options3Items) {
        this.wheelOptions.setLinkage(false);
        this.wheelOptions.setNPicker(options1Items, options2Items, options3Items);
        this.reSetCurrentItems();
    }

    public void onClick(View v) {
        String tag = (String)v.getTag();
        if (tag.equals(TAG_SUBMIT)) {
            this.returnData();
        }
        this.dismiss();
    }

    public void returnData() {
        if (this.mPickerOptions.optionsSelectListener != null) {
            int[] optionsCurrentItems = this.wheelOptions.getCurrentItems();
            this.mPickerOptions.optionsSelectListener.onOptionsSelect(optionsCurrentItems[0], optionsCurrentItems[1], optionsCurrentItems[2], this.clickView);
        }
    }

    @Override
    public boolean isDialog() {
        return this.mPickerOptions.isDialog;
    }

    public void setTypeface(Typeface typeface) {
        if (this.wheelOptions != null) {
            this.wheelOptions.setTypeface(typeface);
        }
    }
}

