/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.imageview.strategy.impl;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.widget.ImageView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.request.RequestOptions;
import com.xuexiang.xui.widget.imageview.strategy.IImageLoadStrategy;

public class GlideImageLoadStrategy
implements IImageLoadStrategy {
    @Override
    public void loadImage(@NonNull ImageView imageView, Object path) {
        Glide.with((Context)imageView.getContext()).load(path).into(imageView);
    }

    @Override
    public void loadGifImage(@NonNull ImageView imageView, Object path) {
        Glide.with((Context)imageView.getContext()).asGif().load(path).into(imageView);
    }

    @Override
    public void loadImage(@NonNull ImageView imageView, Object path, DiskCacheStrategy strategy) {
        RequestOptions options = new RequestOptions().centerCrop().diskCacheStrategy(strategy);
        Glide.with((Context)imageView.getContext()).load(path).apply(options).into(imageView);
    }

    @Override
    public void loadGifImage(@NonNull ImageView imageView, Object path, DiskCacheStrategy strategy) {
        RequestOptions options = new RequestOptions().centerCrop().diskCacheStrategy(strategy);
        Glide.with((Context)imageView.getContext()).asGif().load(path).apply(options).into(imageView);
    }

    @Override
    public void loadImage(@NonNull ImageView imageView, Object path, Drawable placeholder, DiskCacheStrategy strategy) {
        RequestOptions options = new RequestOptions().centerCrop().placeholder(placeholder).diskCacheStrategy(strategy);
        Glide.with((Context)imageView.getContext()).load(path).apply(options).into(imageView);
    }

    @Override
    public void loadGifImage(@NonNull ImageView imageView, Object path, Drawable placeholder, DiskCacheStrategy strategy) {
        RequestOptions options = new RequestOptions().centerCrop().placeholder(placeholder).diskCacheStrategy(strategy);
        Glide.with((Context)imageView.getContext()).asGif().load(path).apply(options).into(imageView);
    }

    @Override
    public void loadImage(@NonNull ImageView imageView, Object path, int width, int height, Drawable placeholder, DiskCacheStrategy strategy) {
        RequestOptions options = new RequestOptions().centerCrop().override(width, height).placeholder(placeholder).diskCacheStrategy(strategy);
        Glide.with((Context)imageView.getContext()).load(path).apply(options).into(imageView);
    }

    @Override
    public void clearCache(Context context) {
        Glide.get((Context)context).clearMemory();
        Glide.get((Context)context).clearDiskCache();
    }

    @Override
    public void clearMemoryCache(Context context) {
        Glide.get((Context)context).clearMemory();
    }

    @Override
    public void clearDiskCache(Context context) {
        Glide.get((Context)context).clearDiskCache();
    }
}

