/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.imageview.preview.ui;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.CallSuper;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentPagerAdapter;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.TextView;
import com.xuexiang.xui.R;
import com.xuexiang.xui.widget.imageview.preview.MediaLoader;
import com.xuexiang.xui.widget.imageview.preview.PreviewBuilder;
import com.xuexiang.xui.widget.imageview.preview.enitity.IPreviewInfo;
import com.xuexiang.xui.widget.imageview.preview.ui.BasePhotoFragment;
import com.xuexiang.xui.widget.imageview.preview.view.BezierBannerView;
import com.xuexiang.xui.widget.imageview.preview.view.PhotoViewPager;
import com.xuexiang.xui.widget.imageview.preview.view.SmoothImageView;
import java.util.ArrayList;
import java.util.List;

public class PreviewActivity
extends FragmentActivity {
    public static final String KEY_IMAGE_PATHS = "com.xuexiang.xui.widget.preview.KEY_IMAGE_PATHS";
    public static final String KEY_POSITION = "com.xuexiang.xui.widget.preview.KEY_POSITION";
    public static final String KEY_TYPE = "com.xuexiang.xui.widget.preview.KEY_TYPE";
    public static final String KEY_IS_SHOW = "com.xuexiang.xui.widget.preview.KEY_IS_SHOW";
    public static final String KEY_DURATION = "com.xuexiang.xui.widget.preview.KEY_DURATION";
    public static final String KEY_IS_FULLSCREEN = "com.xuexiang.xui.widget.preview.KEY_IS_FULLSCREEN";
    public static final String KEY_CLASSNAME = "com.xuexiang.xui.widget.preview.KEY_CLASSNAME";
    private boolean mIsTransformOut = false;
    private List<IPreviewInfo> mImgUrls;
    private int mCurrentIndex;
    private List<BasePhotoFragment> fragments = new ArrayList<BasePhotoFragment>();
    private PhotoViewPager mViewPager;
    private TextView mTvIndex;
    private BezierBannerView mBezierBannerView;
    private PreviewBuilder.IndicatorType mType;
    private boolean mIsShow = true;

    @CallSuper
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.initArgs();
        if (this.getLayoutId() == 0) {
            this.setContentView(R.layout.preview_activity_image_photo);
        } else {
            this.setContentView(this.getLayoutId());
        }
        this.initView();
    }

    protected void onDestroy() {
        MediaLoader.get().clearMemory((Context)this);
        if (this.mViewPager != null) {
            this.mViewPager.setAdapter(null);
            this.mViewPager.clearOnPageChangeListeners();
            this.mViewPager.removeAllViews();
            this.mViewPager = null;
        }
        if (this.fragments != null) {
            this.fragments.clear();
            this.fragments = null;
        }
        if (this.mImgUrls != null) {
            this.mImgUrls.clear();
            this.mImgUrls = null;
        }
        super.onDestroy();
    }

    private void initArgs() {
        this.mImgUrls = this.getIntent().getParcelableArrayListExtra(KEY_IMAGE_PATHS);
        this.mCurrentIndex = this.getIntent().getIntExtra(KEY_POSITION, -1);
        this.mType = (PreviewBuilder.IndicatorType)((Object)this.getIntent().getSerializableExtra(KEY_TYPE));
        this.mIsShow = this.getIntent().getBooleanExtra(KEY_IS_SHOW, true);
        int duration = this.getIntent().getIntExtra(KEY_DURATION, 300);
        boolean isFullscreen = this.getIntent().getBooleanExtra(KEY_IS_FULLSCREEN, false);
        if (isFullscreen) {
            this.setTheme(0x1030011);
        }
        try {
            SmoothImageView.setDuration(duration);
            Class clazz = (Class)this.getIntent().getSerializableExtra(KEY_CLASSNAME);
            this.initFragment(this.mImgUrls, this.mCurrentIndex, clazz);
        }
        catch (Exception e) {
            this.initFragment(this.mImgUrls, this.mCurrentIndex, BasePhotoFragment.class);
        }
    }

    protected void initFragment(List<IPreviewInfo> imgUrls, int currentIndex, Class<? extends BasePhotoFragment> className) {
        if (imgUrls != null) {
            int size = imgUrls.size();
            for (int i = 0; i < size; ++i) {
                this.fragments.add(BasePhotoFragment.newInstance(className, imgUrls.get(i), currentIndex == i, this.getIntent().getBooleanExtra("com.xuexiang.xui.widget.preview.KEY_SING_FILING", false), this.getIntent().getBooleanExtra("com.xuexiang.xui.widget.preview.KEY_DRAG", false), this.getIntent().getFloatExtra("com.xuexiang.xui.widget.preview.KEY_SENSITIVITY", 0.5f), this.getIntent().getIntExtra("com.xuexiang.xui.widget.preview.KEY_PROGRESS_COLOR", R.color.xui_config_color_main_theme)));
            }
        } else {
            this.finish();
        }
    }

    private void initView() {
        this.mViewPager = (PhotoViewPager)this.findViewById(R.id.viewPager);
        PhotoPagerAdapter adapter = new PhotoPagerAdapter(this.getSupportFragmentManager());
        this.mViewPager.setAdapter((PagerAdapter)adapter);
        this.mViewPager.setCurrentItem(this.mCurrentIndex);
        this.mViewPager.setOffscreenPageLimit(3);
        this.mBezierBannerView = (BezierBannerView)this.findViewById(R.id.bezierBannerView);
        this.mTvIndex = (TextView)this.findViewById(R.id.tv_index);
        if (this.mType == PreviewBuilder.IndicatorType.Dot) {
            this.mBezierBannerView.setVisibility(0);
            this.mBezierBannerView.attachToViewpager(this.mViewPager);
        } else {
            this.mTvIndex.setVisibility(0);
            this.mTvIndex.setText((CharSequence)this.getString(R.string.xui_preview_count_string, new Object[]{this.mCurrentIndex + 1, this.getImgSize()}));
            this.mViewPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener(){

                public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
                }

                public void onPageSelected(int position) {
                    if (PreviewActivity.this.mTvIndex != null) {
                        PreviewActivity.this.mTvIndex.setText((CharSequence)PreviewActivity.this.getString(R.string.xui_preview_count_string, new Object[]{position + 1, PreviewActivity.this.getImgSize()}));
                    }
                    PreviewActivity.this.mCurrentIndex = position;
                    PreviewActivity.this.mViewPager.setCurrentItem(PreviewActivity.this.mCurrentIndex, true);
                }

                public void onPageScrollStateChanged(int state) {
                }
            });
        }
        if (this.fragments.size() == 1 && !this.mIsShow) {
            this.mBezierBannerView.setVisibility(8);
            this.mTvIndex.setVisibility(8);
        }
        this.mViewPager.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                PreviewActivity.this.mViewPager.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                BasePhotoFragment fragment = (BasePhotoFragment)((Object)PreviewActivity.this.fragments.get(PreviewActivity.this.mCurrentIndex));
                fragment.transformIn();
            }
        });
    }

    private int getImgSize() {
        return this.mImgUrls != null ? this.mImgUrls.size() : 0;
    }

    public void transformOut() {
        if (this.mIsTransformOut) {
            return;
        }
        this.mIsTransformOut = true;
        int currentItem = this.mViewPager.getCurrentItem();
        if (currentItem < this.getImgSize()) {
            BasePhotoFragment fragment = this.fragments.get(currentItem);
            if (this.mTvIndex != null) {
                this.mTvIndex.setVisibility(8);
            } else {
                this.mBezierBannerView.setVisibility(8);
            }
            fragment.changeBg(0);
            fragment.transformOut(new SmoothImageView.onTransformListener(){

                @Override
                public void onTransformCompleted(SmoothImageView.Status status) {
                    PreviewActivity.this.exit();
                }
            });
        } else {
            this.exit();
        }
    }

    public void finish() {
        BasePhotoFragment.listener = null;
        super.finish();
    }

    public List<BasePhotoFragment> getFragments() {
        return this.fragments;
    }

    private void exit() {
        this.finish();
        this.overridePendingTransition(0, 0);
    }

    public PhotoViewPager getViewPager() {
        return this.mViewPager;
    }

    public int getLayoutId() {
        return 0;
    }

    public void onBackPressed() {
        this.transformOut();
    }

    private class PhotoPagerAdapter
    extends FragmentPagerAdapter {
        PhotoPagerAdapter(FragmentManager fm) {
            super(fm);
        }

        public Fragment getItem(int position) {
            return (Fragment)PreviewActivity.this.fragments.get(position);
        }

        public int getCount() {
            return PreviewActivity.this.fragments == null ? 0 : PreviewActivity.this.fragments.size();
        }

        public void destroyItem(ViewGroup container, int position, Object object) {
            super.destroyItem(container, position, object);
        }
    }
}

