/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.imageview.preview;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.ColorRes;
import android.support.annotation.NonNull;
import android.support.v4.app.Fragment;
import com.xuexiang.xui.widget.imageview.preview.enitity.IPreviewInfo;
import com.xuexiang.xui.widget.imageview.preview.loader.OnVideoClickListener;
import com.xuexiang.xui.widget.imageview.preview.ui.BasePhotoFragment;
import com.xuexiang.xui.widget.imageview.preview.ui.PreviewActivity;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public final class PreviewBuilder {
    private Activity mContext;
    private Intent intent;
    private Class className;
    private OnVideoClickListener videoClickListener;

    private PreviewBuilder(@NonNull Activity activity) {
        this.mContext = activity;
        this.intent = new Intent();
    }

    public static PreviewBuilder from(@NonNull Activity activity) {
        return new PreviewBuilder(activity);
    }

    public static PreviewBuilder from(@NonNull Fragment fragment) {
        return new PreviewBuilder((Activity)fragment.getActivity());
    }

    public PreviewBuilder to(@NonNull Class className) {
        this.className = className;
        this.intent.setClass((Context)this.mContext, className);
        return this;
    }

    public <T extends IPreviewInfo> PreviewBuilder setImgs(@NonNull List<T> imgUrls) {
        this.intent.putParcelableArrayListExtra("com.xuexiang.xui.widget.preview.KEY_IMAGE_PATHS", new ArrayList<T>(imgUrls));
        return this;
    }

    public <E extends IPreviewInfo> PreviewBuilder setImg(@NonNull E imgUrl) {
        ArrayList<E> arrayList = new ArrayList<E>();
        arrayList.add(imgUrl);
        this.intent.putParcelableArrayListExtra("com.xuexiang.xui.widget.preview.KEY_IMAGE_PATHS", arrayList);
        return this;
    }

    public PreviewBuilder setPhotoFragment(@NonNull Class<? extends BasePhotoFragment> className) {
        this.intent.putExtra("com.xuexiang.xui.widget.preview.KEY_CLASSNAME", className);
        return this;
    }

    public PreviewBuilder setCurrentIndex(int currentIndex) {
        this.intent.putExtra("com.xuexiang.xui.widget.preview.KEY_POSITION", currentIndex);
        return this;
    }

    public PreviewBuilder setType(@NonNull IndicatorType indicatorType) {
        this.intent.putExtra("com.xuexiang.xui.widget.preview.KEY_TYPE", (Serializable)((Object)indicatorType));
        return this;
    }

    public PreviewBuilder setProgressColor(@ColorRes int progressColorId) {
        this.intent.putExtra("com.xuexiang.xui.widget.preview.KEY_PROGRESS_COLOR", progressColorId);
        return this;
    }

    public PreviewBuilder setDrag(boolean isDrag) {
        this.intent.putExtra("com.xuexiang.xui.widget.preview.KEY_DRAG", isDrag);
        return this;
    }

    public PreviewBuilder setDrag(boolean isDrag, float sensitivity) {
        this.intent.putExtra("com.xuexiang.xui.widget.preview.KEY_DRAG", isDrag);
        this.intent.putExtra("com.xuexiang.xui.widget.preview.KEY_SENSITIVITY", sensitivity);
        return this;
    }

    public PreviewBuilder setSingleShowType(boolean isShow) {
        this.intent.putExtra("com.xuexiang.xui.widget.preview.KEY_IS_SHOW", isShow);
        return this;
    }

    public PreviewBuilder setSingleFling(boolean isSingleFling) {
        this.intent.putExtra("com.xuexiang.xui.widget.preview.KEY_SING_FILING", isSingleFling);
        return this;
    }

    public PreviewBuilder setDuration(int setDuration) {
        this.intent.putExtra("com.xuexiang.xui.widget.preview.KEY_DURATION", setDuration);
        return this;
    }

    public PreviewBuilder setFullscreen(boolean isFullscreen) {
        this.intent.putExtra("com.xuexiang.xui.widget.preview.KEY_IS_FULLSCREEN", isFullscreen);
        return this;
    }

    public PreviewBuilder setOnVideoPlayerListener(OnVideoClickListener listener) {
        this.videoClickListener = listener;
        return this;
    }

    public void start() {
        if (this.className == null) {
            this.intent.setClass((Context)this.mContext, PreviewActivity.class);
        } else {
            this.intent.setClass((Context)this.mContext, this.className);
        }
        BasePhotoFragment.listener = this.videoClickListener;
        this.mContext.startActivity(this.intent);
        this.mContext.overridePendingTransition(0, 0);
        this.intent = null;
        this.mContext = null;
    }

    public static enum IndicatorType {
        Dot,
        Number;

    }
}

