/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.guidview;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Xfermode;
import android.os.Build;
import android.view.View;

class Utils {
    Utils() {
    }

    static boolean shouldShowCircularAnimation() {
        return Build.VERSION.SDK_INT >= 21;
    }

    static int[] calculateFocusPointValues(View view, double circleRadiusFactor, int adjustHeight) {
        int[] point = new int[3];
        if (view != null) {
            int radius;
            int[] viewPoint = new int[2];
            view.getLocationInWindow(viewPoint);
            point[0] = viewPoint[0] + view.getWidth() / 2;
            point[1] = viewPoint[1] + view.getHeight() / 2 - adjustHeight;
            point[2] = radius = (int)((double)((int)(Math.hypot(view.getWidth(), view.getHeight()) / 2.0)) * circleRadiusFactor);
            return point;
        }
        return null;
    }

    static void drawFocusCircle(Bitmap bitmap, int[] point, int radius) {
        Paint p = new Paint();
        p.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
        Canvas c = new Canvas(bitmap);
        c.drawCircle((float)point[0], (float)point[1], (float)radius, p);
    }

    static int getStatusBarHeight(Context context) {
        int result = 0;
        int resourceId = context.getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            result = context.getResources().getDimensionPixelSize(resourceId);
        }
        return result;
    }
}

