/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.guidview;

import com.xuexiang.xui.widget.guidview.DismissListener;
import com.xuexiang.xui.widget.guidview.GuideCaseView;
import com.xuexiang.xui.widget.guidview.OnCompleteListener;
import java.util.LinkedList;
import java.util.Queue;

public class GuideCaseQueue
implements DismissListener {
    private Queue<GuideCaseView> mQueue = new LinkedList<GuideCaseView>();
    private DismissListener mCurrentOriginalDismissListener = null;
    private GuideCaseView mCurrent;
    private OnCompleteListener mCompleteListener;

    public GuideCaseQueue add(GuideCaseView showCaseView) {
        this.mQueue.add(showCaseView);
        return this;
    }

    public void show() {
        if (!this.mQueue.isEmpty()) {
            this.mCurrent = this.mQueue.poll();
            this.mCurrentOriginalDismissListener = this.mCurrent.getDismissListener();
            this.mCurrent.setDismissListener(this);
            this.mCurrent.show();
        } else if (this.mCompleteListener != null) {
            this.mCompleteListener.onComplete();
        }
    }

    public void cancel(boolean hideCurrent) {
        if (hideCurrent && this.mCurrent != null) {
            this.mCurrent.hide();
        }
        if (!this.mQueue.isEmpty()) {
            this.mQueue.clear();
        }
    }

    @Override
    public void onDismiss(String id2) {
        if (this.mCurrentOriginalDismissListener != null) {
            this.mCurrentOriginalDismissListener.onDismiss(id2);
        }
        this.show();
    }

    @Override
    public void onSkipped(String id2) {
        if (this.mCurrentOriginalDismissListener != null) {
            this.mCurrentOriginalDismissListener.onSkipped(id2);
        }
        this.show();
    }

    public GuideCaseQueue setCompleteListener(OnCompleteListener completeListener) {
        this.mCompleteListener = completeListener;
        return this;
    }
}

