/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.flowlayout;

import android.content.Context;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.util.SparseBooleanArray;
import android.view.View;
import android.view.ViewGroup;
import com.xuexiang.xui.R;
import com.xuexiang.xui.utils.ResUtils;
import com.xuexiang.xui.widget.flowlayout.BaseTagAdapter;
import com.xuexiang.xui.widget.flowlayout.DefaultFlowTagAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class FlowTagLayout
extends ViewGroup {
    public static final int FLOW_TAG_CHECKED_NONE = 0;
    public static final int FLOW_TAG_CHECKED_SINGLE = 1;
    public static final int FLOW_TAG_CHECKED_MULTI = 2;
    public static final int FLOW_TAG_DISPLAY = 3;
    AdapterDataSetObserver mDataSetObserver;
    BaseTagAdapter mAdapter;
    OnTagClickListener mOnTagClickListener;
    OnTagSelectListener mOnTagSelectListener;
    private int mTagCheckMode = 0;
    private SparseBooleanArray mCheckedTagArray = new SparseBooleanArray();
    private int mWidth;
    private List<Integer> mSelectedIndexs;

    public FlowTagLayout(Context context) {
        super(context);
    }

    public FlowTagLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initAttrs(context, attrs);
    }

    public FlowTagLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initAttrs(context, attrs);
    }

    private void initAttrs(Context context, AttributeSet attrs) {
        if (this.isInEditMode()) {
            return;
        }
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.FlowTagLayout);
        this.mTagCheckMode = typedArray.getInt(R.styleable.FlowTagLayout_ftl_check_mode, 0);
        int entriesID = typedArray.getResourceId(R.styleable.FlowTagLayout_ftl_entries, 0);
        if (entriesID != 0) {
            BaseTagAdapter tagAdapter = this.setItems(ResUtils.getStringArray(entriesID));
            int selectedIDs = typedArray.getResourceId(R.styleable.FlowTagLayout_ftl_selecteds, 0);
            if (selectedIDs != 0) {
                tagAdapter.setSelectedPositions(ResUtils.getIntArray(selectedIDs));
            }
        }
        typedArray.recycle();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int sizeWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int sizeHeight = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int modeWidth = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int modeHeight = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int resultWidth = 0;
        int resultHeight = 0;
        int lineWidth = 0;
        int lineHeight = 0;
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View childView = this.getChildAt(i);
            this.measureChild(childView, widthMeasureSpec, heightMeasureSpec);
            int childWidth = childView.getMeasuredWidth();
            int childHeight = childView.getMeasuredHeight();
            ViewGroup.MarginLayoutParams mlp = (ViewGroup.MarginLayoutParams)childView.getLayoutParams();
            int realChildWidth = childWidth + mlp.leftMargin + mlp.rightMargin;
            int realChildHeight = childHeight + mlp.topMargin + mlp.bottomMargin;
            if (lineWidth + realChildWidth > sizeWidth) {
                resultWidth = Math.max(lineWidth, realChildWidth);
                resultHeight += realChildHeight;
                lineWidth = realChildWidth;
                lineHeight = realChildHeight;
            } else {
                lineWidth += realChildWidth;
                lineHeight = Math.max(lineHeight, realChildHeight);
            }
            if (i == childCount - 1) {
                resultWidth = Math.max(lineWidth, resultWidth);
                resultHeight += lineHeight;
            }
            this.setMeasuredDimension(modeWidth == 0x40000000 ? sizeWidth : resultWidth, modeHeight == 0x40000000 ? sizeHeight : resultHeight);
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int flowWidth = this.getWidth();
        int childLeft = 0;
        int childTop = 0;
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View childView = this.getChildAt(i);
            if (childView.getVisibility() == 8) continue;
            int childWidth = childView.getMeasuredWidth();
            int childHeight = childView.getMeasuredHeight();
            ViewGroup.MarginLayoutParams mlp = (ViewGroup.MarginLayoutParams)childView.getLayoutParams();
            if (childLeft + mlp.leftMargin + childWidth + mlp.rightMargin > flowWidth) {
                childTop += mlp.topMargin + childHeight + mlp.bottomMargin;
                childLeft = 0;
            }
            int left = childLeft + mlp.leftMargin;
            int top = childTop + mlp.topMargin;
            int right = childLeft + mlp.leftMargin + childWidth;
            int bottom = childTop + mlp.topMargin + childHeight;
            childView.layout(left, top, right, bottom);
            childLeft += mlp.leftMargin + childWidth + mlp.rightMargin;
        }
    }

    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new ViewGroup.MarginLayoutParams(this.getContext(), attrs);
    }

    public BaseTagAdapter getAdapter() {
        return this.mAdapter;
    }

    public FlowTagLayout setAdapter(BaseTagAdapter adapter) {
        if (this.mAdapter != null && this.mDataSetObserver != null) {
            this.mAdapter.unregisterDataSetObserver(this.mDataSetObserver);
        }
        this.removeAllViews();
        this.mAdapter = adapter;
        if (this.mAdapter != null) {
            this.mDataSetObserver = new AdapterDataSetObserver();
            this.mAdapter.registerDataSetObserver(this.mDataSetObserver);
        }
        return this;
    }

    public FlowTagLayout setChildWidth(int width) {
        this.mWidth = width;
        return this;
    }

    private void reloadData() {
        this.removeAllViews();
        ViewGroup.MarginLayoutParams mMarginLayoutParams = new ViewGroup.MarginLayoutParams(-2, -2);
        if (this.mWidth != 0) {
            mMarginLayoutParams.width = this.mWidth;
        }
        boolean isSetted = false;
        for (int i = 0; i < this.mAdapter.getCount(); ++i) {
            int index = i;
            this.mCheckedTagArray.put(i, false);
            View childView = this.mAdapter.getView(i, null, this);
            this.addView(childView, (ViewGroup.LayoutParams)mMarginLayoutParams);
            if (this.mAdapter instanceof OnInitSelectedPosition) {
                boolean isSelected = this.mAdapter.isSelectedPosition(i);
                if (this.mTagCheckMode == 1) {
                    if (isSelected && !isSetted) {
                        this.mCheckedTagArray.put(i, true);
                        childView.setSelected(true);
                        isSetted = true;
                    }
                } else if (this.mTagCheckMode == 2) {
                    if (isSelected) {
                        this.mCheckedTagArray.put(i, true);
                        childView.setSelected(true);
                    }
                } else if (this.mTagCheckMode == 3) {
                    this.mCheckedTagArray.put(i, true);
                    childView.setSelected(true);
                    childView.setEnabled(false);
                }
            }
            this.mSelectedIndexs = null;
            this.setChildViewClickListener(index, childView);
        }
    }

    private void setChildViewClickListener(final int index, final View childView) {
        childView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (FlowTagLayout.this.mTagCheckMode == 0) {
                    if (FlowTagLayout.this.mOnTagClickListener != null) {
                        FlowTagLayout.this.mOnTagClickListener.onItemClick(FlowTagLayout.this, childView, index);
                    }
                } else if (FlowTagLayout.this.mTagCheckMode == 1) {
                    if (FlowTagLayout.this.mCheckedTagArray.get(index)) {
                        return;
                    }
                    for (int k = 0; k < FlowTagLayout.this.mAdapter.getCount(); ++k) {
                        FlowTagLayout.this.mCheckedTagArray.put(k, false);
                        FlowTagLayout.this.getChildAt(k).setSelected(false);
                    }
                    FlowTagLayout.this.mCheckedTagArray.put(index, true);
                    childView.setSelected(true);
                    FlowTagLayout.this.setSelectedIndexs(Arrays.asList(index));
                    if (FlowTagLayout.this.mOnTagSelectListener != null) {
                        FlowTagLayout.this.mOnTagSelectListener.onItemSelect(FlowTagLayout.this, index, Arrays.asList(index));
                    }
                } else if (FlowTagLayout.this.mTagCheckMode == 2) {
                    if (FlowTagLayout.this.mCheckedTagArray.get(index)) {
                        FlowTagLayout.this.mCheckedTagArray.put(index, false);
                        childView.setSelected(false);
                    } else {
                        FlowTagLayout.this.mCheckedTagArray.put(index, true);
                        childView.setSelected(true);
                    }
                    ArrayList<Integer> list = new ArrayList<Integer>();
                    for (int k = 0; k < FlowTagLayout.this.mAdapter.getCount(); ++k) {
                        if (!FlowTagLayout.this.mCheckedTagArray.get(k)) continue;
                        list.add(k);
                    }
                    FlowTagLayout.this.setSelectedIndexs(list);
                    if (FlowTagLayout.this.mOnTagSelectListener != null) {
                        FlowTagLayout.this.mOnTagSelectListener.onItemSelect(FlowTagLayout.this, index, list);
                    }
                }
            }
        });
    }

    public FlowTagLayout setOnTagClickListener(OnTagClickListener onTagClickListener) {
        this.mOnTagClickListener = onTagClickListener;
        return this;
    }

    public FlowTagLayout setOnTagSelectListener(OnTagSelectListener onTagSelectListener) {
        this.mOnTagSelectListener = onTagSelectListener;
        return this;
    }

    public int getTagCheckMode() {
        return this.mTagCheckMode;
    }

    public FlowTagLayout setTagCheckedMode(int tagMode) {
        this.mTagCheckMode = tagMode;
        return this;
    }

    private FlowTagLayout setSelectedIndexs(List<Integer> selectedIndexs) {
        this.mSelectedIndexs = selectedIndexs;
        return this;
    }

    public List<Integer> getSelectedIndexs() {
        if (this.mSelectedIndexs != null) {
            return this.mSelectedIndexs;
        }
        return this.getAdapter().getInitSelectedPositions();
    }

    public <T> BaseTagAdapter setItems(T ... items) {
        return this.setItems(Arrays.asList(items));
    }

    public <T> BaseTagAdapter setItems(@NonNull List<T> items) {
        if (this.mAdapter != null) {
            this.mAdapter.clearAndAddTags(items);
        } else {
            DefaultFlowTagAdapter tagAdapter = new DefaultFlowTagAdapter(this.getContext());
            this.setAdapter(tagAdapter);
            tagAdapter.addTags(items);
        }
        return this.mAdapter;
    }

    public FlowTagLayout setSelectedPositions(Integer ... ps) {
        if (this.mAdapter != null) {
            this.mAdapter.setSelectedPositions(ps);
        }
        return this;
    }

    public FlowTagLayout setSelectedPositions(List<Integer> ps) {
        if (this.mAdapter != null) {
            this.mAdapter.setSelectedPositions(ps);
        }
        return this;
    }

    public FlowTagLayout setSelectedPositions(int[] ps) {
        if (this.mAdapter != null) {
            this.mAdapter.setSelectedPositions(ps);
        }
        return this;
    }

    public <T> FlowTagLayout setSelectedItems(T ... selectedItems) {
        this.setSelectedItems(Arrays.asList(selectedItems));
        return this;
    }

    public <T> FlowTagLayout setSelectedItems(List<T> selectedItems) {
        if (this.mTagCheckMode != 0 && this.mAdapter != null) {
            this.mAdapter.setSelectedPositions(this.getSelectedPositions(selectedItems, this.mAdapter.getItems()));
        }
        return this;
    }

    private <T> List<Integer> getSelectedPositions(List<T> selectedItems, List<T> items) {
        ArrayList<Integer> positions = new ArrayList<Integer>();
        if (!this.isListEmpty(selectedItems) && !this.isListEmpty(items)) {
            block0: for (int i = 0; i < selectedItems.size(); ++i) {
                for (int j = 0; j < items.size(); ++j) {
                    if (!items.get(j).equals(selectedItems.get(i))) continue;
                    positions.add(j);
                    continue block0;
                }
            }
        }
        return positions;
    }

    private <T> boolean isListEmpty(List<T> list) {
        return list == null || list.isEmpty();
    }

    class AdapterDataSetObserver
    extends DataSetObserver {
        AdapterDataSetObserver() {
        }

        public void onChanged() {
            super.onChanged();
            FlowTagLayout.this.reloadData();
        }

        public void onInvalidated() {
            super.onInvalidated();
        }
    }

    public static interface OnTagSelectListener {
        public void onItemSelect(FlowTagLayout var1, int var2, List<Integer> var3);
    }

    public static interface OnTagClickListener {
        public void onItemClick(FlowTagLayout var1, View var2, int var3);
    }

    public static interface OnInitSelectedPosition {
        public boolean isSelectedPosition(int var1);
    }
}

