/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.edittext.verify;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.support.v7.widget.AppCompatTextView;
import android.util.AttributeSet;

public class PwdTextView
extends AppCompatTextView {
    private float mRadius;
    private boolean mHasPassword;
    private Paint mPaint;

    public PwdTextView(Context context) {
        this(context, null);
    }

    public PwdTextView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public PwdTextView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initPaint();
    }

    private void initPaint() {
        this.mPaint = new Paint(1);
        this.mPaint.setColor(-16777216);
        this.mPaint.setStyle(Paint.Style.FILL);
    }

    protected void onDraw(Canvas canvas) {
        if (this.mHasPassword) {
            canvas.drawCircle((float)(this.getWidth() >> 1), (float)(this.getHeight() >> 1), this.mRadius, this.mPaint);
        } else {
            super.onDraw(canvas);
        }
    }

    public void clearPassword() {
        this.mHasPassword = false;
        this.invalidate();
    }

    public void drawPassword(float radius) {
        this.mHasPassword = true;
        this.mRadius = radius == 0.0f ? (float)(this.getWidth() >> 2) : radius;
        this.invalidate();
    }
}

