/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.edittext;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.xuexiang.xui.R;
import com.xuexiang.xui.utils.DensityUtils;
import com.xuexiang.xui.utils.ResUtils;
import com.xuexiang.xui.utils.ThemeUtils;

public class MultiLineEditText
extends LinearLayout {
    private EditText mEtInput;
    private TextView mTvInputNumber;
    private int mMaxCount;
    private String mHintText;
    private int mHintTextColor;
    private boolean mIgnoreCnOrEn;
    private String mContentText;
    private int mContentTextSize;
    private int mContentTextColor;
    private float mContentViewHeight;
    private int mContentPadding;
    private Drawable mContentBackground;
    private boolean mIsShowSurplusNumber;
    private TextWatcher mTextWatcher = new TextWatcher(){
        private int mEditStart;
        private int mEditEnd;

        public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
        }

        public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
        }

        public void afterTextChanged(Editable editable) {
            this.mEditStart = MultiLineEditText.this.mEtInput.getSelectionStart();
            this.mEditEnd = MultiLineEditText.this.mEtInput.getSelectionEnd();
            MultiLineEditText.this.mEtInput.removeTextChangedListener(MultiLineEditText.this.mTextWatcher);
            if (MultiLineEditText.this.mIgnoreCnOrEn) {
                while (MultiLineEditText.this.calculateLengthIgnoreCnOrEn(editable.toString()) > MultiLineEditText.this.mMaxCount) {
                    editable.delete(this.mEditStart - 1, this.mEditEnd);
                    --this.mEditStart;
                    --this.mEditEnd;
                }
            } else {
                while (MultiLineEditText.this.calculateLength(editable.toString()) > (long)MultiLineEditText.this.mMaxCount) {
                    editable.delete(this.mEditStart - 1, this.mEditEnd);
                    --this.mEditStart;
                    --this.mEditEnd;
                }
            }
            MultiLineEditText.this.mEtInput.setSelection(this.mEditStart);
            MultiLineEditText.this.mEtInput.addTextChangedListener(MultiLineEditText.this.mTextWatcher);
            MultiLineEditText.this.configCount();
        }
    };

    public MultiLineEditText(Context context) {
        this(context, null);
    }

    public MultiLineEditText(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.MultiLineEditTextStyle);
    }

    public MultiLineEditText(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initAttrs(context, attrs, defStyleAttr);
        this.init();
    }

    private void initAttrs(Context context, AttributeSet attrs, int defStyleAttr) {
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.MultiLineEditText, defStyleAttr, 0);
        this.mMaxCount = typedArray.getInteger(R.styleable.MultiLineEditText_mlet_maxCount, 240);
        this.mIgnoreCnOrEn = typedArray.getBoolean(R.styleable.MultiLineEditText_mlet_ignoreCnOrEn, true);
        this.mHintText = typedArray.getString(R.styleable.MultiLineEditText_mlet_hintText);
        this.mHintTextColor = typedArray.getColor(R.styleable.MultiLineEditText_mlet_hintTextColor, ThemeUtils.resolveColor(this.getContext(), R.attr.xui_config_color_hint_text));
        this.mContentPadding = typedArray.getDimensionPixelSize(R.styleable.MultiLineEditText_mlet_contentPadding, DensityUtils.dp2px(context, 10.0f));
        this.mContentBackground = ResUtils.getDrawableAttrRes(this.getContext(), typedArray, R.styleable.MultiLineEditText_mlet_contentBackground);
        this.mContentText = typedArray.getString(R.styleable.MultiLineEditText_mlet_contentText);
        this.mContentTextColor = typedArray.getColor(R.styleable.MultiLineEditText_mlet_contentTextColor, ThemeUtils.resolveColor(this.getContext(), R.attr.xui_config_color_input_text));
        this.mContentTextSize = typedArray.getDimensionPixelSize(R.styleable.MultiLineEditText_mlet_contentTextSize, DensityUtils.sp2px(context, 14.0f));
        this.mContentViewHeight = typedArray.getDimensionPixelSize(R.styleable.MultiLineEditText_mlet_contentViewHeight, DensityUtils.dp2px(context, 140.0f));
        this.mIsShowSurplusNumber = typedArray.getBoolean(R.styleable.MultiLineEditText_mlet_showSurplusNumber, false);
        typedArray.recycle();
    }

    private void init() {
        View view = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.xui_layout_multiline_edittext, (ViewGroup)this);
        this.mEtInput = (EditText)view.findViewById(R.id.mlet_input);
        this.mTvInputNumber = (TextView)view.findViewById(R.id.mlet_number);
        if (this.getBackground() == null) {
            this.setBackgroundResource(R.drawable.mlet_selector_bg);
        }
        this.mEtInput.addTextChangedListener(this.mTextWatcher);
        this.mEtInput.setHint((CharSequence)this.mHintText);
        this.mEtInput.setHintTextColor(this.mHintTextColor);
        this.mEtInput.setText((CharSequence)this.mContentText);
        this.mEtInput.setPadding(this.mContentPadding, this.mContentPadding, this.mContentPadding, this.mContentPadding);
        if (this.mContentBackground != null) {
            this.mEtInput.setBackground(this.mContentBackground);
        }
        this.mEtInput.setTextColor(this.mContentTextColor);
        this.mEtInput.setTextSize(0, (float)this.mContentTextSize);
        this.mEtInput.setHeight((int)this.mContentViewHeight);
        this.mTvInputNumber.requestFocus();
        this.configCount();
        this.mEtInput.setSelection(this.mEtInput.length());
        this.mEtInput.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View view, boolean b) {
                MultiLineEditText.this.setSelected(b);
            }
        });
    }

    private long calculateLength(CharSequence c) {
        double len = 0.0;
        for (int i = 0; i < c.length(); ++i) {
            char tmp = c.charAt(i);
            if (tmp > '\u0000' && tmp < '\u007f') {
                len += 0.5;
                continue;
            }
            len += 1.0;
        }
        return Math.round(len);
    }

    private int calculateLengthIgnoreCnOrEn(CharSequence c) {
        int len = 0;
        for (int i = 0; i < c.length(); ++i) {
            ++len;
        }
        return len;
    }

    private void configCount() {
        if (this.mIgnoreCnOrEn) {
            int nowCount = this.calculateLengthIgnoreCnOrEn(this.mEtInput.getText().toString());
            this.updateCount(nowCount);
        } else {
            int nowCount = (int)this.calculateLength(this.mEtInput.getText().toString());
            this.updateCount(nowCount);
        }
    }

    private void updateCount(int nowCount) {
        if (this.mIsShowSurplusNumber) {
            this.mTvInputNumber.setText((CharSequence)(String.valueOf(this.mMaxCount - nowCount) + "/" + this.mMaxCount));
        } else {
            this.mTvInputNumber.setText((CharSequence)(String.valueOf(nowCount) + "/" + this.mMaxCount));
        }
    }

    public EditText getEditText() {
        return this.mEtInput;
    }

    public TextView getCountTextView() {
        return this.mTvInputNumber;
    }

    public void setContentText(String content) {
        this.mContentText = content;
        if (this.mEtInput == null) {
            return;
        }
        this.mEtInput.setText((CharSequence)this.mContentText);
    }

    public String getContentText() {
        if (this.mEtInput != null) {
            this.mContentText = this.mEtInput.getText() == null ? "" : this.mEtInput.getText().toString();
        }
        return this.mContentText;
    }

    public void setHintText(String hintText) {
        this.mHintText = hintText;
        if (this.mEtInput == null) {
            return;
        }
        this.mEtInput.setHint((CharSequence)hintText);
    }

    public void setContentTextSize(int size) {
        if (this.mEtInput == null) {
            return;
        }
        this.mEtInput.setTextSize(0, (float)size);
    }

    public void setContentTextColor(int color2) {
        if (this.mEtInput == null) {
            return;
        }
        this.mEtInput.setTextColor(color2);
    }

    public void setHintColor(int color2) {
        if (this.mEtInput == null) {
            return;
        }
        this.mEtInput.setHintTextColor(color2);
    }

    public String getHintText() {
        if (this.mEtInput != null) {
            this.mHintText = this.mEtInput.getHint() == null ? "" : this.mEtInput.getHint().toString();
        }
        return this.mHintText;
    }

    public MultiLineEditText setMaxCount(int max_count) {
        this.mMaxCount = max_count;
        this.configCount();
        return this;
    }

    public MultiLineEditText setIgnoreCnOrEn(boolean ignoreCnOrEn) {
        this.mIgnoreCnOrEn = ignoreCnOrEn;
        this.configCount();
        return this;
    }

    public MultiLineEditText setIsShowSurplusNumber(boolean isShowSurplusNumber) {
        this.mIsShowSurplusNumber = isShowSurplusNumber;
        this.configCount();
        return this;
    }

    public boolean isEmpty() {
        return TextUtils.isEmpty((CharSequence)this.getContentText());
    }

    public boolean isNotEmpty() {
        return !TextUtils.isEmpty((CharSequence)this.getContentText());
    }
}

