/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.edittext;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.support.v7.widget.AppCompatEditText;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.CycleInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.TranslateAnimation;
import android.widget.TextView;
import com.xuexiang.xui.R;
import com.xuexiang.xui.utils.ResUtils;

public class ClearEditText
extends AppCompatEditText
implements View.OnFocusChangeListener,
TextWatcher {
    private Drawable mClearDrawable;
    private int mIconSize;

    public ClearEditText(Context context) {
        this(context, null);
    }

    public ClearEditText(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.ClearEditTextStyle);
    }

    public ClearEditText(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initAttrs(context, attrs, defStyle);
    }

    public static Animation shakeAnimation(int counts) {
        TranslateAnimation translateAnimation = new TranslateAnimation(0.0f, 10.0f, 0.0f, 0.0f);
        translateAnimation.setInterpolator((Interpolator)new CycleInterpolator((float)counts));
        translateAnimation.setDuration(1000L);
        return translateAnimation;
    }

    private void initAttrs(Context context, AttributeSet attrs, int defStyleAttr) {
        if (this.isInEditMode()) {
            return;
        }
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.ClearEditText, defStyleAttr, 0);
        this.mClearDrawable = ResUtils.getDrawableAttrRes(this.getContext(), typedArray, R.styleable.ClearEditText_cet_clearIcon);
        this.mIconSize = typedArray.getDimensionPixelSize(R.styleable.ClearEditText_cet_clearIconSize, 0);
        typedArray.recycle();
        if (this.mClearDrawable == null) {
            this.mClearDrawable = this.getCompoundDrawables()[2];
            if (this.mClearDrawable == null) {
                this.mClearDrawable = ResUtils.getVectorDrawable(context, R.drawable.xui_ic_default_clear_btn);
            }
        }
        if (this.mIconSize != 0) {
            this.mClearDrawable.setBounds(0, 0, this.mIconSize, this.mIconSize);
        } else {
            this.mClearDrawable.setBounds(0, 0, this.mClearDrawable.getIntrinsicWidth(), this.mClearDrawable.getIntrinsicHeight());
        }
        this.setClearIconVisible(false);
        this.setOnFocusChangeListener(this);
        this.addTextChangedListener(this);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.getCompoundDrawables()[2] != null && event.getAction() == 1) {
            boolean touchable;
            boolean bl = touchable = event.getX() > (float)(this.getWidth() - this.getPaddingRight() - this.mClearDrawable.getIntrinsicWidth()) && event.getX() < (float)(this.getWidth() - this.getPaddingRight());
            if (touchable) {
                this.setText("");
            }
        }
        return super.onTouchEvent(event);
    }

    public void onFocusChange(View v, boolean hasFocus) {
        if (hasFocus) {
            this.setClearIconVisible(this.getText().length() > 0);
        } else {
            this.setClearIconVisible(false);
        }
    }

    protected void setClearIconVisible(boolean visible) {
        Drawable right = visible ? this.mClearDrawable : null;
        this.setCompoundDrawables(this.getCompoundDrawables()[0], this.getCompoundDrawables()[1], right, this.getCompoundDrawables()[3]);
    }

    public void onTextChanged(CharSequence s, int start, int count, int after) {
        this.setClearIconVisible(s.length() > 0);
    }

    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
    }

    public void afterTextChanged(Editable s) {
    }

    public void setText(CharSequence text, TextView.BufferType type) {
        super.setText(text, type);
        this.setClearIconVisible(false);
    }

    public void setShakeAnimation() {
        this.setAnimation(ClearEditText.shakeAnimation(5));
    }
}

