/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.dialog.strategy.impl;

import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.support.annotation.ArrayRes;
import android.support.annotation.NonNull;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.FrameLayout;
import com.xuexiang.xui.utils.DensityUtils;
import com.xuexiang.xui.widget.dialog.strategy.IDialogStrategy;
import com.xuexiang.xui.widget.dialog.strategy.InputCallback;
import com.xuexiang.xui.widget.dialog.strategy.InputInfo;

public class AlertDialogStrategy
implements IDialogStrategy {
    @Override
    public Dialog showTipDialog(Context context, int icon, String title, String content, String submitText, DialogInterface.OnClickListener listener) {
        return new AlertDialog.Builder(context).setIcon(icon).setTitle((CharSequence)title).setMessage((CharSequence)content).setPositiveButton((CharSequence)submitText, listener).setCancelable(false).show();
    }

    @Override
    public Dialog showTipDialog(Context context, String title, String content, String submitText) {
        return new AlertDialog.Builder(context).setTitle((CharSequence)title).setMessage((CharSequence)content).setPositiveButton((CharSequence)submitText, null).show();
    }

    @Override
    public Dialog showConfirmDialog(Context context, String title, String content, String submitText, DialogInterface.OnClickListener submitListener, String cancelText, DialogInterface.OnClickListener cancelListener) {
        return new AlertDialog.Builder(context).setTitle((CharSequence)title).setMessage((CharSequence)content).setPositiveButton((CharSequence)submitText, submitListener).setNegativeButton((CharSequence)cancelText, cancelListener).setCancelable(false).show();
    }

    @Override
    public Dialog showConfirmDialog(Context context, String content, String submitText, DialogInterface.OnClickListener submitListener, String cancelText, DialogInterface.OnClickListener cancelListener) {
        return new AlertDialog.Builder(context).setMessage((CharSequence)content).setPositiveButton((CharSequence)submitText, submitListener).setNegativeButton((CharSequence)cancelText, cancelListener).setCancelable(false).show();
    }

    @Override
    public Dialog showConfirmDialog(Context context, String content, String submitText, DialogInterface.OnClickListener submitListener, String cancelText) {
        return new AlertDialog.Builder(context).setMessage((CharSequence)content).setPositiveButton((CharSequence)submitText, submitListener).setNegativeButton((CharSequence)cancelText, null).setCancelable(false).show();
    }

    @Override
    public Dialog showInputDialog(Context context, int icon, String title, String content, @NonNull InputInfo inputInfo, final InputCallback inputCallback, String submitText, final DialogInterface.OnClickListener submitListener, String cancelText, DialogInterface.OnClickListener cancelListener) {
        FrameLayout linearLayout = new FrameLayout(context);
        final EditText etInput = new EditText(context);
        etInput.setInputType(inputInfo.getInputType());
        etInput.setHint((CharSequence)inputInfo.getHint());
        etInput.setText((CharSequence)inputInfo.getPreFill());
        linearLayout.addView((View)etInput);
        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)etInput.getLayoutParams();
        layoutParams.setMargins(DensityUtils.dp2px(context, 15.0f), 0, DensityUtils.dp2px(context, 15.0f), 0);
        etInput.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        return new AlertDialog.Builder(context).setIcon(icon).setTitle((CharSequence)title).setMessage((CharSequence)content).setView((View)linearLayout).setPositiveButton((CharSequence)submitText, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                if (submitListener != null) {
                    submitListener.onClick(dialog, which);
                }
                if (inputCallback != null) {
                    inputCallback.onInput(dialog, etInput.getText().toString());
                }
            }
        }).setNegativeButton((CharSequence)cancelText, cancelListener).show();
    }

    @Override
    public Dialog showContextMenuDialog(Context context, String title, String[] items, DialogInterface.OnClickListener listener) {
        return new AlertDialog.Builder(context).setTitle((CharSequence)title).setItems((CharSequence[])items, listener).show();
    }

    @Override
    public Dialog showContextMenuDialog(Context context, String title, @ArrayRes int itemsId, DialogInterface.OnClickListener listener) {
        return new AlertDialog.Builder(context).setTitle((CharSequence)title).setItems(itemsId, listener).show();
    }

    @Override
    public Dialog showSingleChoiceDialog(Context context, String title, String[] items, int selectedIndex, final DialogInterface.OnClickListener listener, String submitText, String cancelText) {
        return new AlertDialog.Builder(context).setTitle((CharSequence)title).setSingleChoiceItems((CharSequence[])items, selectedIndex, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                if (listener != null) {
                    listener.onClick(dialog, which);
                }
                dialog.dismiss();
            }
        }).setCancelable(false).show();
    }

    @Override
    public Dialog showSingleChoiceDialog(Context context, String title, int itemsId, int selectedIndex, final DialogInterface.OnClickListener listener, String submitText, String cancelText) {
        return new AlertDialog.Builder(context).setTitle((CharSequence)title).setSingleChoiceItems(itemsId, selectedIndex, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                if (listener != null) {
                    listener.onClick(dialog, which);
                }
                dialog.dismiss();
            }
        }).setCancelable(false).show();
    }
}

