/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.dialog;

import android.app.Dialog;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.v7.app.AppCompatDialog;
import android.view.MotionEvent;
import android.view.View;
import android.view.WindowManager;
import com.xuexiang.xui.R;
import com.xuexiang.xui.utils.KeyboardUtils;
import com.xuexiang.xui.utils.ResUtils;

public class BaseDialog
extends AppCompatDialog {
    private View mContentView;

    public BaseDialog(Context context, int layoutId) {
        this(context, R.style.XUIDialog_Custom, layoutId);
    }

    public BaseDialog(Context context, View contentView) {
        this(context, R.style.XUIDialog_Custom, contentView);
    }

    public BaseDialog(Context context) {
        super(context, R.style.XUIDialog_Custom);
    }

    public BaseDialog(Context context, int theme, int layoutId) {
        super(context, theme);
        this.init(layoutId);
    }

    public BaseDialog(Context context, int theme, View contentView) {
        super(context, theme);
        this.init(contentView);
    }

    public void init(int layoutId) {
        View view = this.getLayoutInflater().inflate(layoutId, null);
        this.init(view);
    }

    private void init(View view) {
        this.setContentView(view);
        this.mContentView = view;
        this.setCanceledOnTouchOutside(true);
    }

    public BaseDialog setDialogSize(int width, int height) {
        WindowManager.LayoutParams p = this.getWindow().getAttributes();
        p.width = width;
        p.height = height;
        this.getWindow().setAttributes(p);
        return this;
    }

    public <T extends View> T findViewById(int resId) {
        return (T)this.mContentView.findViewById(resId);
    }

    public String getString(int resId) {
        return this.getContext().getResources().getString(resId);
    }

    public Drawable getDrawable(int resId) {
        return ResUtils.getDrawable(this.getContext(), resId);
    }

    public boolean onTouchEvent(MotionEvent ev) {
        KeyboardUtils.dispatchTouchEvent(ev, (Dialog)this);
        return super.onTouchEvent(ev);
    }
}

