/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.button.shadowbutton;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.MotionEvent;
import com.xuexiang.xui.R;
import com.xuexiang.xui.widget.button.shadowbutton.BaseShadowButton;

public class ShadowButton
extends BaseShadowButton {
    private int COVER_ALPHA = 48;
    private Paint mPressedPaint;
    private int mPressedColor;

    public ShadowButton(Context context) {
        super(context);
    }

    public ShadowButton(Context context, AttributeSet attrs) {
        super(context, attrs, 0);
    }

    public ShadowButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    protected void init(Context context, AttributeSet attrs) {
        super.init(context, attrs);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.ShadowButton);
        this.COVER_ALPHA = typedArray.getInteger(R.styleable.ShadowButton_sb_alpha_pressed, this.COVER_ALPHA);
        this.mPressedColor = typedArray.getColor(R.styleable.ShadowButton_sb_color_pressed, this.getResources().getColor(R.color.default_shadow_button_color_pressed));
        typedArray.recycle();
        this.mPressedPaint = new Paint();
        this.mPressedPaint.setStyle(Paint.Style.FILL);
        this.mPressedPaint.setColor(this.mPressedColor);
        this.mPressedPaint.setAlpha(0);
        this.mPressedPaint.setAntiAlias(true);
    }

    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mShapeType == 0) {
            canvas.drawCircle((float)(this.mWidth / 2), (float)(this.mHeight / 2), (float)this.mWidth / 2.1038f, this.mPressedPaint);
        } else {
            RectF rectF = new RectF();
            rectF.set(0.0f, 0.0f, (float)this.mWidth, (float)this.mHeight);
            canvas.drawRoundRect(rectF, (float)this.mRadius, (float)this.mRadius, this.mPressedPaint);
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                this.mPressedPaint.setAlpha(this.COVER_ALPHA);
                this.invalidate();
                break;
            }
            case 1: 
            case 3: {
                this.mPressedPaint.setAlpha(0);
                this.invalidate();
            }
        }
        return super.onTouchEvent(event);
    }

    public int getPressedColor() {
        return this.mPressedColor;
    }

    public void setPressedColor(int pressedColor) {
        this.mPressedPaint.setColor(this.mPressedColor);
        this.invalidate();
    }
}

