/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.button.shadowbutton;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.support.v7.widget.AppCompatButton;
import android.util.AttributeSet;
import com.xuexiang.xui.R;

public class BaseShadowButton
extends AppCompatButton {
    public static final int SHAPE_TYPE_ROUND = 0;
    public static final int SHAPE_TYPE_RECTANGLE = 1;
    protected int mWidth;
    protected int mHeight;
    protected Paint mBackgroundPaint;
    protected int mShapeType;
    protected int mRadius;

    public BaseShadowButton(Context context) {
        super(context);
        this.init(context, null);
    }

    public BaseShadowButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public BaseShadowButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    protected void init(Context context, AttributeSet attrs) {
        if (this.isInEditMode()) {
            return;
        }
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.ShadowButton);
        this.mShapeType = typedArray.getInt(R.styleable.ShadowButton_sb_shape_type, 1);
        this.mRadius = typedArray.getDimensionPixelSize(R.styleable.ShadowButton_sb_radius, this.getResources().getDimensionPixelSize(R.dimen.default_shadow_button_radius));
        int unpressedColor = typedArray.getColor(R.styleable.ShadowButton_sb_color_unpressed, 0);
        typedArray.recycle();
        this.mBackgroundPaint = new Paint();
        this.mBackgroundPaint.setStyle(Paint.Style.FILL);
        this.mBackgroundPaint.setAlpha(Color.alpha((int)unpressedColor));
        this.mBackgroundPaint.setColor(unpressedColor);
        this.mBackgroundPaint.setAntiAlias(true);
        this.setWillNotDraw(false);
        this.setDrawingCacheEnabled(true);
        this.setClickable(true);
        this.eraseOriginalBackgroundColor(unpressedColor);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mWidth = w;
        this.mHeight = h;
    }

    protected void onDraw(Canvas canvas) {
        if (this.mBackgroundPaint == null) {
            super.onDraw(canvas);
            return;
        }
        if (this.mShapeType == 0) {
            canvas.drawCircle((float)(this.mWidth / 2), (float)(this.mHeight / 2), (float)(this.mWidth / 2), this.mBackgroundPaint);
        } else {
            RectF rectF = new RectF();
            rectF.set(0.0f, 0.0f, (float)this.mWidth, (float)this.mHeight);
            canvas.drawRoundRect(rectF, (float)this.mRadius, (float)this.mRadius, this.mBackgroundPaint);
        }
        super.onDraw(canvas);
    }

    protected void eraseOriginalBackgroundColor(int color2) {
        if (color2 != 0) {
            this.setBackgroundColor(0);
        }
    }

    public void setUnpressedColor(int color2) {
        this.mBackgroundPaint.setAlpha(Color.alpha((int)color2));
        this.mBackgroundPaint.setColor(color2);
        this.eraseOriginalBackgroundColor(color2);
        this.invalidate();
    }

    public int getShapeType() {
        return this.mShapeType;
    }

    public void setShapeType(int shapeType) {
        this.mShapeType = shapeType;
        this.invalidate();
    }

    public int getRadius() {
        return this.mRadius;
    }

    public void setRadius(int radius) {
        this.mRadius = radius;
        this.invalidate();
    }
}

