/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.button;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.Xfermode;
import android.os.Build;
import android.os.Handler;
import android.support.annotation.ColorRes;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.ScaleAnimation;
import android.widget.AdapterView;
import android.widget.FrameLayout;
import com.xuexiang.xui.R;
import com.xuexiang.xui.utils.ResUtils;

public class RippleView
extends FrameLayout {
    private int WIDTH;
    private int HEIGHT;
    private int frameRate = 10;
    private int rippleDuration = 400;
    private int rippleAlpha = 90;
    private Handler canvasHandler;
    private float radiusMax = 0.0f;
    private boolean animationRunning = false;
    private int timer = 0;
    private int timerEmpty = 0;
    private int durationEmpty = -1;
    private float x = -1.0f;
    private float y = -1.0f;
    private int zoomDuration;
    private float zoomScale;
    private ScaleAnimation scaleAnimation;
    private Boolean hasToZoom;
    private Boolean isCentered;
    private Integer rippleType;
    private Paint paint;
    private Bitmap originBitmap;
    private int rippleColor;
    private int ripplePadding;
    private GestureDetector gestureDetector;
    private final Runnable runnable = new Runnable(){

        @Override
        public void run() {
            RippleView.this.invalidate();
        }
    };
    private OnRippleCompleteListener onCompletionListener;

    public RippleView(Context context) {
        this(context, null);
    }

    public RippleView(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.RippleViewStyle);
    }

    public RippleView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr);
    }

    private void init(Context context, AttributeSet attrs, int defStyleAttr) {
        this.initAttrs(context, attrs, defStyleAttr);
        this.initPaint();
        this.gestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

            public void onLongPress(MotionEvent event) {
                super.onLongPress(event);
                RippleView.this.animateRipple(event);
                RippleView.this.sendClickEvent(true);
            }

            public boolean onSingleTapConfirmed(MotionEvent e) {
                return true;
            }

            public boolean onSingleTapUp(MotionEvent e) {
                return true;
            }
        });
        this.setDrawingCacheEnabled(true);
        this.setClickable(true);
    }

    private void initAttrs(Context context, AttributeSet attrs, int defStyleAttr) {
        if (this.isInEditMode()) {
            return;
        }
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.RippleView, defStyleAttr, 0);
        this.rippleColor = typedArray.getColor(R.styleable.RippleView_rv_color, ResUtils.getColor(R.color.xui_config_color_white));
        this.rippleType = typedArray.getInt(R.styleable.RippleView_rv_type, 0);
        this.hasToZoom = typedArray.getBoolean(R.styleable.RippleView_rv_zoom, false);
        this.isCentered = typedArray.getBoolean(R.styleable.RippleView_rv_centered, false);
        this.rippleDuration = typedArray.getInteger(R.styleable.RippleView_rv_rippleDuration, this.rippleDuration);
        this.frameRate = typedArray.getInteger(R.styleable.RippleView_rv_frameRate, this.frameRate);
        this.rippleAlpha = typedArray.getInteger(R.styleable.RippleView_rv_alpha, this.rippleAlpha);
        this.ripplePadding = typedArray.getDimensionPixelSize(R.styleable.RippleView_rv_ripplePadding, 0);
        this.canvasHandler = new Handler();
        this.zoomScale = typedArray.getFloat(R.styleable.RippleView_rv_zoomScale, 1.03f);
        this.zoomDuration = typedArray.getInt(R.styleable.RippleView_rv_zoomDuration, 200);
        typedArray.recycle();
    }

    private void initPaint() {
        this.paint = new Paint();
        this.paint.setAntiAlias(true);
        this.paint.setStyle(Paint.Style.FILL);
        this.paint.setColor(this.rippleColor);
        this.paint.setAlpha(this.rippleAlpha);
        this.setWillNotDraw(false);
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
        if (this.animationRunning) {
            canvas.save();
            if (this.rippleDuration <= this.timer * this.frameRate) {
                this.animationRunning = false;
                this.timer = 0;
                this.durationEmpty = -1;
                this.timerEmpty = 0;
                if (Build.VERSION.SDK_INT != 23) {
                    canvas.restore();
                }
                this.invalidate();
                if (this.onCompletionListener != null) {
                    this.onCompletionListener.onComplete(this);
                }
                return;
            }
            this.canvasHandler.postDelayed(this.runnable, (long)this.frameRate);
            if (this.timer == 0) {
                canvas.save();
            }
            canvas.drawCircle(this.x, this.y, this.radiusMax * ((float)this.timer * (float)this.frameRate / (float)this.rippleDuration), this.paint);
            this.paint.setColor(Color.parseColor((String)"#FFFF4444"));
            if (this.rippleType == 1 && this.originBitmap != null && (float)this.timer * (float)this.frameRate / (float)this.rippleDuration > 0.4f) {
                if (this.durationEmpty == -1) {
                    this.durationEmpty = this.rippleDuration - this.timer * this.frameRate;
                }
                ++this.timerEmpty;
                Bitmap tmpBitmap = this.getCircleBitmap((int)(this.radiusMax * ((float)this.timerEmpty * (float)this.frameRate / (float)this.durationEmpty)));
                canvas.drawBitmap(tmpBitmap, 0.0f, 0.0f, this.paint);
                tmpBitmap.recycle();
            }
            this.paint.setColor(this.rippleColor);
            if (this.rippleType == 1) {
                if ((float)this.timer * (float)this.frameRate / (float)this.rippleDuration > 0.6f) {
                    this.paint.setAlpha((int)((float)this.rippleAlpha - (float)this.rippleAlpha * ((float)this.timerEmpty * (float)this.frameRate / (float)this.durationEmpty)));
                } else {
                    this.paint.setAlpha(this.rippleAlpha);
                }
            } else {
                this.paint.setAlpha((int)((float)this.rippleAlpha - (float)this.rippleAlpha * ((float)this.timer * (float)this.frameRate / (float)this.rippleDuration)));
            }
            ++this.timer;
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.WIDTH = w;
        this.HEIGHT = h;
        this.scaleAnimation = new ScaleAnimation(1.0f, this.zoomScale, 1.0f, this.zoomScale, (float)(w >> 1), (float)(h >> 1));
        this.scaleAnimation.setDuration((long)this.zoomDuration);
        this.scaleAnimation.setRepeatMode(2);
        this.scaleAnimation.setRepeatCount(1);
    }

    public void animateRipple(MotionEvent event) {
        this.createAnimation(event.getX(), event.getY());
    }

    public void animateRipple(float x, float y) {
        this.createAnimation(x, y);
    }

    private void createAnimation(float x, float y) {
        if (this.isEnabled() && !this.animationRunning) {
            if (this.hasToZoom.booleanValue()) {
                this.startAnimation((Animation)this.scaleAnimation);
            }
            this.radiusMax = Math.max(this.WIDTH, this.HEIGHT);
            if (this.rippleType != 2) {
                this.radiusMax /= 2.0f;
            }
            this.radiusMax -= (float)this.ripplePadding;
            if (this.isCentered.booleanValue() || this.rippleType == 1) {
                this.x = this.getMeasuredWidth() >> 1;
                this.y = this.getMeasuredHeight() >> 1;
            } else {
                this.x = x;
                this.y = y;
            }
            this.animationRunning = true;
            if (this.rippleType == 1 && this.originBitmap == null) {
                this.originBitmap = this.getDrawingCache(true);
            }
            this.invalidate();
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.gestureDetector.onTouchEvent(event)) {
            this.animateRipple(event);
            this.sendClickEvent(false);
        }
        return super.onTouchEvent(event);
    }

    public boolean onInterceptTouchEvent(MotionEvent event) {
        this.onTouchEvent(event);
        return super.onInterceptTouchEvent(event);
    }

    private void sendClickEvent(Boolean isLongClick) {
        if (this.getParent() instanceof AdapterView) {
            AdapterView adapterView = (AdapterView)this.getParent();
            int position = adapterView.getPositionForView((View)this);
            long id2 = adapterView.getItemIdAtPosition(position);
            if (isLongClick.booleanValue()) {
                if (adapterView.getOnItemLongClickListener() != null) {
                    adapterView.getOnItemLongClickListener().onItemLongClick(adapterView, (View)this, position, id2);
                }
            } else if (adapterView.getOnItemClickListener() != null) {
                adapterView.getOnItemClickListener().onItemClick(adapterView, (View)this, position, id2);
            }
        }
    }

    private Bitmap getCircleBitmap(int radius) {
        Bitmap output = Bitmap.createBitmap((int)this.originBitmap.getWidth(), (int)this.originBitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(output);
        Paint paint = new Paint();
        Rect rect = new Rect((int)(this.x - (float)radius), (int)(this.y - (float)radius), (int)(this.x + (float)radius), (int)(this.y + (float)radius));
        paint.setAntiAlias(true);
        canvas.drawARGB(0, 0, 0, 0);
        canvas.drawCircle(this.x, this.y, (float)radius, paint);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.drawBitmap(this.originBitmap, rect, rect, paint);
        return output;
    }

    public void setRippleColor(@ColorRes int rippleColor) {
        this.rippleColor = this.getResources().getColor(rippleColor);
    }

    public int getRippleColor() {
        return this.rippleColor;
    }

    public RippleType getRippleType() {
        return RippleType.values()[this.rippleType];
    }

    public void setRippleType(RippleType rippleType) {
        this.rippleType = rippleType.ordinal();
    }

    public Boolean isCentered() {
        return this.isCentered;
    }

    public void setCentered(Boolean isCentered) {
        this.isCentered = isCentered;
    }

    public int getRipplePadding() {
        return this.ripplePadding;
    }

    public void setRipplePadding(int ripplePadding) {
        this.ripplePadding = ripplePadding;
    }

    public Boolean isZooming() {
        return this.hasToZoom;
    }

    public void setZooming(Boolean hasToZoom) {
        this.hasToZoom = hasToZoom;
    }

    public float getZoomScale() {
        return this.zoomScale;
    }

    public void setZoomScale(float zoomScale) {
        this.zoomScale = zoomScale;
    }

    public int getZoomDuration() {
        return this.zoomDuration;
    }

    public void setZoomDuration(int zoomDuration) {
        this.zoomDuration = zoomDuration;
    }

    public int getRippleDuration() {
        return this.rippleDuration;
    }

    public void setRippleDuration(int rippleDuration) {
        this.rippleDuration = rippleDuration;
    }

    public int getFrameRate() {
        return this.frameRate;
    }

    public void setFrameRate(int frameRate) {
        this.frameRate = frameRate;
    }

    public int getRippleAlpha() {
        return this.rippleAlpha;
    }

    public void setRippleAlpha(int rippleAlpha) {
        this.rippleAlpha = rippleAlpha;
    }

    public void setOnRippleCompleteListener(OnRippleCompleteListener listener) {
        this.onCompletionListener = listener;
    }

    public static enum RippleType {
        SIMPLE(0),
        DOUBLE(1),
        RECTANGLE(2);

        int type;

        private RippleType(int type) {
            this.type = type;
        }
    }

    public static interface OnRippleCompleteListener {
        public void onComplete(RippleView var1);
    }
}

