/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.button;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.support.annotation.NonNull;
import android.support.v7.widget.AppCompatTextView;
import android.util.AttributeSet;
import android.view.MotionEvent;
import com.xuexiang.xui.R;
import com.xuexiang.xui.utils.ResUtils;
import com.xuexiang.xui.utils.SpanUtils;

public class ButtonView
extends AppCompatTextView {
    private GradientDrawable gradientDrawable;
    private int mNormalSolidColor;
    private int mSelectedSolidColor;

    public ButtonView(Context context) {
        super(context);
    }

    public ButtonView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setAttributeSet(context, attrs);
    }

    public ButtonView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setAttributeSet(context, attrs);
    }

    private void setAttributeSet(Context context, AttributeSet attrs) {
        if (this.isInEditMode()) {
            return;
        }
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.ButtonView);
        this.mNormalSolidColor = typedArray.getColor(R.styleable.ButtonView_textSolidColor, 0);
        this.mSelectedSolidColor = typedArray.getColor(R.styleable.ButtonView_textSelectedSolidColor, 0);
        int strokeColor = typedArray.getColor(R.styleable.ButtonView_textStrokeColor, 0);
        int radius = typedArray.getDimensionPixelSize(R.styleable.ButtonView_textRadius, 0);
        int leftTopRadius = typedArray.getDimensionPixelSize(R.styleable.ButtonView_textLeftTopRadius, 0);
        int leftBottomRadius = typedArray.getDimensionPixelSize(R.styleable.ButtonView_textLeftBottomRadius, 0);
        int rightTopRadius = typedArray.getDimensionPixelSize(R.styleable.ButtonView_textRightTopRadius, 0);
        int rightBottomRadius = typedArray.getDimensionPixelSize(R.styleable.ButtonView_textRightBottomRadius, 0);
        int strokeWidth = typedArray.getDimensionPixelSize(R.styleable.ButtonView_textStrokeWidth, 0);
        Drawable textDrawable = ResUtils.getDrawableAttrRes(this.getContext(), typedArray, R.styleable.ButtonView_textDrawable);
        int normalTextColor = typedArray.getColor(R.styleable.ButtonView_textNormalTextColor, 0);
        int selectedTextColor = typedArray.getColor(R.styleable.ButtonView_textSelectedTextColor, 0);
        typedArray.recycle();
        this.gradientDrawable = new GradientDrawable();
        this.gradientDrawable.setStroke(strokeWidth, strokeColor);
        this.gradientDrawable.setColor(this.mNormalSolidColor);
        if (radius > 0) {
            this.gradientDrawable.setCornerRadius((float)radius);
        } else if (leftTopRadius > 0 || leftBottomRadius > 0 || rightTopRadius > 0 || rightBottomRadius > 0) {
            this.gradientDrawable.setCornerRadii(new float[]{leftTopRadius, leftTopRadius, rightTopRadius, rightTopRadius, rightBottomRadius, rightBottomRadius, leftBottomRadius, leftBottomRadius});
        }
        this.setBackgroundDrawable((Drawable)this.gradientDrawable);
        if (textDrawable != null) {
            this.setTextDrawable(textDrawable, 20);
        }
        if (normalTextColor != 0 && selectedTextColor != 0) {
            int[][] states = new int[3][1];
            states[0] = new int[]{0x10100A1};
            states[1] = new int[]{16842919};
            states[2] = new int[0];
            ColorStateList textColorSelect = new ColorStateList(states, new int[]{selectedTextColor, selectedTextColor, normalTextColor});
            this.setTextColor(textColorSelect);
        }
        if (selectedTextColor != 0 || this.mSelectedSolidColor != 0) {
            this.setClickable(true);
        } else {
            this.setClickable(false);
        }
    }

    public ButtonView setTextDrawable(int drawableId, int space) {
        if (drawableId != 0) {
            Drawable textDrawable = this.getResources().getDrawable(drawableId);
            this.setTextDrawable(textDrawable, space);
        }
        return this;
    }

    public ButtonView setTextDrawable(@NonNull Drawable textDrawable, int space) {
        this.setText((CharSequence)new SpanUtils().appendImage(textDrawable, 1).appendSpace(space, 0).append(this.getText()).setBackgroundColor(0).create());
        return this;
    }

    public ButtonView setSolidColor(int colorId) {
        this.gradientDrawable.setColor(colorId);
        this.setBackgroundDrawable((Drawable)this.gradientDrawable);
        return this;
    }

    public ButtonView setRadius(int leftTopRadius, int leftBottomRadius, int rightTopRadius, int rightBottomRadius) {
        this.gradientDrawable.setCornerRadii(new float[]{leftTopRadius, leftTopRadius, rightTopRadius, rightTopRadius, rightBottomRadius, rightBottomRadius, leftBottomRadius, leftBottomRadius});
        this.setBackgroundDrawable((Drawable)this.gradientDrawable);
        return this;
    }

    public ButtonView setStrokeColorAndWidth(int strokeWidth, int colorId) {
        this.gradientDrawable.setStroke(strokeWidth, colorId);
        return this;
    }

    public ButtonView setSelectedTextColor(int normalTextColor, int selectedTextColor) {
        if (normalTextColor != 0 && selectedTextColor != 0) {
            this.setClickable(true);
            int[][] states = new int[3][1];
            states[0] = new int[]{0x10100A1};
            states[1] = new int[]{16842919};
            states[2] = new int[0];
            ColorStateList textColorSelect = new ColorStateList(states, new int[]{selectedTextColor, selectedTextColor, normalTextColor});
            this.setTextColor(textColorSelect);
        } else {
            this.setClickable(false);
        }
        return this;
    }

    public ButtonView setSelectedSolidColor(int selectedSolidColor) {
        if (selectedSolidColor != 0) {
            this.setClickable(true);
            this.mSelectedSolidColor = selectedSolidColor;
        } else {
            this.setClickable(false);
        }
        return this;
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (event.getAction() == 0) {
            if (this.mSelectedSolidColor != 0 && this.isEnabled()) {
                this.gradientDrawable.setColor(this.mSelectedSolidColor);
                this.setBackgroundDrawable((Drawable)this.gradientDrawable);
                this.postInvalidate();
            }
        } else if ((event.getAction() == 1 || event.getAction() == 3) && this.mSelectedSolidColor != 0) {
            this.gradientDrawable.setColor(this.mNormalSolidColor);
            this.setBackgroundDrawable((Drawable)this.gradientDrawable);
        }
        return super.onTouchEvent(event);
    }
}

