/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.behavior;

import android.content.Context;
import android.support.design.widget.CoordinatorLayout;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import com.xuexiang.xui.widget.behavior.AnimateHelper;

public abstract class BaseBehavior
extends CoordinatorLayout.Behavior<View> {
    protected final int mTouchSlop;
    protected boolean isFirstMove = true;
    protected boolean canInit = true;
    protected AnimateHelper mAnimateHelper;

    public BaseBehavior(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mTouchSlop = ViewConfiguration.get((Context)context).getScaledTouchSlop();
    }

    public boolean onStartNestedScroll(CoordinatorLayout coordinatorLayout, View child, View directTargetChild, View target, int nestedScrollAxes) {
        return (nestedScrollAxes & 2) != 0;
    }

    public void onNestedPreScroll(CoordinatorLayout coordinatorLayout, View child, View target, int dx, int dy, int[] consumed) {
        this.onNestPreScrollInit(child);
        if (Math.abs(dy) > 2) {
            if (dy < 0) {
                if (this.mAnimateHelper.getState() == 0) {
                    this.mAnimateHelper.show();
                }
            } else if (dy > 0 && this.mAnimateHelper.getState() == 1) {
                this.mAnimateHelper.hide();
            }
        }
    }

    protected abstract void onNestPreScrollInit(View var1);

    public void show() {
        this.mAnimateHelper.show();
    }

    public void hide() {
        this.mAnimateHelper.hide();
    }

    public static BaseBehavior from(View view) {
        ViewGroup.LayoutParams params = view.getLayoutParams();
        if (!(params instanceof CoordinatorLayout.LayoutParams)) {
            throw new IllegalArgumentException("The view is not a child of CoordinatorLayout");
        }
        CoordinatorLayout.Behavior behavior = ((CoordinatorLayout.LayoutParams)params).getBehavior();
        if (!(behavior instanceof BaseBehavior)) {
            throw new IllegalArgumentException("The view is not associated with BaseBehavior");
        }
        return (BaseBehavior)behavior;
    }
}

