/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ListView;
import com.xuexiang.xui.R;

public class XUIWrapContentListView
extends ListView {
    private int mMaxHeight = 0x1FFFFFFF;

    public XUIWrapContentListView(Context context) {
        super(context);
    }

    public XUIWrapContentListView(Context context, int maxHeight) {
        super(context);
        this.mMaxHeight = maxHeight;
    }

    public XUIWrapContentListView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initAttrs(context, attrs);
    }

    public XUIWrapContentListView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initAttrs(context, attrs);
    }

    private void initAttrs(Context context, AttributeSet attrs) {
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.XUIWrapContentListView);
        if (ta != null) {
            this.mMaxHeight = ta.getDimensionPixelSize(R.styleable.XUIWrapContentListView_wclv_max_height, this.mMaxHeight);
            ta.recycle();
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int expandSpec = View.MeasureSpec.makeMeasureSpec((int)this.mMaxHeight, (int)Integer.MIN_VALUE);
        super.onMeasure(widthMeasureSpec, expandSpec);
    }

    public void setMaxHeight(int maxHeight) {
        if (this.mMaxHeight != maxHeight) {
            this.mMaxHeight = maxHeight;
            this.requestLayout();
        }
    }
}

