/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.utils;

import android.content.Context;
import android.util.DisplayMetrics;
import com.xuexiang.xui.utils.ResUtils;

public final class DensityUtils {
    private DensityUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static DisplayMetrics getDisplayMetrics() {
        return ResUtils.getResources().getDisplayMetrics();
    }

    public static int dp2px(float dpValue) {
        float scale = ResUtils.getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    public static int dp2px(Context context, float dpValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    public static int px2dp(float pxValue) {
        float scale = ResUtils.getResources().getDisplayMetrics().density;
        return (int)(pxValue / scale + 0.5f);
    }

    public static int px2dp(Context context, float pxValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(pxValue / scale + 0.5f);
    }

    public static int px2sp(float pxValue) {
        float fontScale = ResUtils.getResources().getDisplayMetrics().scaledDensity;
        return (int)(pxValue / fontScale + 0.5f);
    }

    public static int px2sp(Context context, float pxValue) {
        float fontScale = context.getResources().getDisplayMetrics().scaledDensity;
        return (int)(pxValue / fontScale + 0.5f);
    }

    public static int sp2px(float spValue) {
        float fontScale = ResUtils.getResources().getDisplayMetrics().scaledDensity;
        return (int)(spValue * fontScale + 0.5f);
    }

    public static int sp2px(Context context, float spValue) {
        float fontScale = context.getResources().getDisplayMetrics().scaledDensity;
        return (int)(spValue * fontScale + 0.5f);
    }

    public static int getScreenDpi() {
        return DensityUtils.getDisplayMetrics().densityDpi;
    }

    public static int getRealDpi(Context context) {
        DisplayMetrics metric = context.getResources().getDisplayMetrics();
        float xdpi = metric.xdpi;
        float ydpi = metric.ydpi;
        return (int)((xdpi + ydpi) / 2.0f + 0.5f);
    }
}

