/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.adapter.simple;

import android.content.Context;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.xuexiang.xui.R;
import com.xuexiang.xui.adapter.listview.BaseListAdapter;
import com.xuexiang.xui.adapter.simple.AdapterItem;
import com.xuexiang.xui.adapter.simple.ViewHolder;
import com.xuexiang.xui.utils.DensityUtils;
import java.util.ArrayList;
import java.util.List;

public class XUISimpleAdapter
extends BaseListAdapter<AdapterItem, ViewHolder> {
    private int mPaddingLeftPx;

    public XUISimpleAdapter(Context context) {
        super(context);
    }

    public XUISimpleAdapter(Context context, List<AdapterItem> data) {
        super(context, data);
    }

    public XUISimpleAdapter(Context context, AdapterItem[] data) {
        super(context, data);
    }

    @Override
    protected ViewHolder newViewHolder(View convertView) {
        ViewHolder holder = new ViewHolder();
        holder.mLLContentView = (LinearLayout)convertView.findViewById(R.id.ll_content);
        holder.mTvTitle = (TextView)convertView.findViewById(R.id.tv_title);
        holder.mIvIcon = (ImageView)convertView.findViewById(R.id.iv_icon);
        if (this.mPaddingLeftPx != 0) {
            holder.mLLContentView.setPadding(this.mPaddingLeftPx, 0, 0, 0);
            holder.mLLContentView.setGravity(16);
        } else {
            holder.mLLContentView.setGravity(17);
        }
        return holder;
    }

    @Override
    protected int getLayoutId() {
        return R.layout.xui_adapter_listview_simple_item;
    }

    @Override
    protected void convert(ViewHolder holder, AdapterItem item, int position) {
        holder.mTvTitle.setText(item.getTitle());
        if (item.getIcon() != null) {
            holder.mIvIcon.setVisibility(0);
            holder.mIvIcon.setImageDrawable(item.getIcon());
        } else {
            holder.mIvIcon.setVisibility(8);
        }
    }

    public XUISimpleAdapter setPaddingLeftPx(int paddingLeftPx) {
        this.mPaddingLeftPx = paddingLeftPx;
        return this;
    }

    public XUISimpleAdapter setPaddingLeftDp(int paddingLeftDp) {
        this.mPaddingLeftPx = DensityUtils.dp2px(paddingLeftDp);
        return this;
    }

    public static XUISimpleAdapter create(Context context, String[] data) {
        if (data != null && data.length > 0) {
            ArrayList<AdapterItem> lists = new ArrayList<AdapterItem>();
            for (int i = 0; i < data.length; ++i) {
                lists.add(new AdapterItem(data[i]));
            }
            return new XUISimpleAdapter(context, (List<AdapterItem>)lists);
        }
        return new XUISimpleAdapter(context);
    }

    public static XUISimpleAdapter create(Context context, List<String> data) {
        if (data != null && data.size() > 0) {
            ArrayList<AdapterItem> lists = new ArrayList<AdapterItem>();
            for (int i = 0; i < data.size(); ++i) {
                lists.add(new AdapterItem(data.get(i)));
            }
            return new XUISimpleAdapter(context, (List<AdapterItem>)lists);
        }
        return new XUISimpleAdapter(context);
    }
}

