/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.adapter.recyclerview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.v4.view.ViewCompat;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import com.xuexiang.xui.utils.DensityUtils;

public class GridDividerItemDecoration
extends RecyclerView.ItemDecoration {
    private static final int[] ATTRS = new int[]{16843284};
    private Drawable mDivider;
    private int mSpanCount;
    private int mDividerWidth;
    private Paint mPaint;

    public GridDividerItemDecoration(Context context, int spanCount) {
        this.mSpanCount = spanCount;
        TypedArray a = context.obtainStyledAttributes(ATTRS);
        this.mDivider = a.getDrawable(0);
        a.recycle();
        this.mDividerWidth = this.mDivider != null ? this.mDivider.getIntrinsicHeight() : DensityUtils.dp2px(1.0f);
    }

    public GridDividerItemDecoration(Context context, int spanCount, int dividerWidth) {
        this(context, spanCount);
        this.mDividerWidth = dividerWidth;
    }

    public GridDividerItemDecoration(Context context, int spanCount, int dividerWidth, int dividerColor) {
        this(context, spanCount);
        this.mDividerWidth = dividerWidth;
        this.mPaint = new Paint(1);
        this.mPaint.setColor(dividerColor);
        this.mPaint.setStyle(Paint.Style.FILL);
    }

    public void onDraw(@NonNull Canvas canvas, @NonNull RecyclerView parent, @NonNull RecyclerView.State state) {
        super.onDraw(canvas, parent, state);
        int childCount = parent.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = parent.getChildAt(i);
            int position = parent.getChildLayoutPosition(child);
            int column = (position + 1) % 3;
            column = column == 0 ? this.mSpanCount : column;
            RecyclerView.LayoutParams params = (RecyclerView.LayoutParams)child.getLayoutParams();
            int top = child.getBottom() + params.bottomMargin + Math.round(ViewCompat.getTranslationY((View)child));
            int bottom = top + this.mDividerWidth;
            int left = child.getRight() + params.rightMargin + Math.round(ViewCompat.getTranslationX((View)child));
            int right = left + this.mDividerWidth;
            if (this.mPaint != null) {
                this.mDivider.setBounds(child.getLeft(), top, right, bottom);
                this.mDivider.draw(canvas);
            }
            if (this.mPaint != null) {
                canvas.drawRect((float)child.getLeft(), (float)top, (float)right, (float)bottom, this.mPaint);
            }
            if (column >= this.mSpanCount) continue;
            if (this.mPaint != null) {
                this.mDivider.setBounds(left, child.getTop(), right, bottom);
                this.mDivider.draw(canvas);
            }
            if (this.mPaint == null) continue;
            canvas.drawRect((float)left, (float)child.getTop(), (float)right, (float)bottom, this.mPaint);
        }
    }

    public void getItemOffsets(@NonNull Rect outRect, @NonNull View view, @NonNull RecyclerView parent, @NonNull RecyclerView.State state) {
        int position = parent.getChildLayoutPosition(view);
        if ((position + 1) % this.mSpanCount > 0) {
            outRect.set(0, 0, this.mDividerWidth, this.mDividerWidth);
        } else {
            outRect.set(0, 0, 0, this.mDividerWidth);
        }
    }
}

