/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.adapter.recyclerview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import com.xuexiang.xui.utils.DensityUtils;

public class DividerItemDecoration
extends RecyclerView.ItemDecoration {
    private Paint mPaint;
    private Drawable mDivider;
    private int mDividerHeight;
    private int mOrientation;
    private static final int[] ATTRS = new int[]{16843284};
    private int mExtraPadding;

    public DividerItemDecoration(Context context, int orientation) {
        if (orientation != 1 && orientation != 0) {
            throw new IllegalArgumentException("\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u53c2\u6570\uff01");
        }
        this.mOrientation = orientation;
        TypedArray a = context.obtainStyledAttributes(ATTRS);
        this.mDivider = a.getDrawable(0);
        a.recycle();
        this.mDividerHeight = this.mDivider != null ? this.mDivider.getIntrinsicHeight() : DensityUtils.dp2px(1.0f);
    }

    public DividerItemDecoration(Context context, int orientation, int dividerHeight) {
        this(context, orientation);
        this.mDividerHeight = dividerHeight;
    }

    public DividerItemDecoration(Context context, int orientation, int dividerHeight, int dividerColor) {
        this(context, orientation);
        this.mDividerHeight = dividerHeight;
        this.mPaint = new Paint(1);
        this.mPaint.setColor(dividerColor);
        this.mPaint.setStyle(Paint.Style.FILL);
    }

    public DividerItemDecoration setDivider(@NonNull Drawable divider) {
        this.mDivider = divider;
        this.mDividerHeight = this.mDivider.getIntrinsicHeight();
        return this;
    }

    public DividerItemDecoration(Context context, int orientation, int dividerHeight, int dividerColor, int extraPadding) {
        this(context, orientation);
        this.mDividerHeight = dividerHeight;
        this.mExtraPadding = extraPadding;
        this.mPaint = new Paint(1);
        this.mPaint.setColor(dividerColor);
        this.mPaint.setStyle(Paint.Style.FILL);
    }

    public void getItemOffsets(@NonNull Rect outRect, @NonNull View view, @NonNull RecyclerView parent, @NonNull RecyclerView.State state) {
        super.getItemOffsets(outRect, view, parent, state);
        if (this.mOrientation == 1) {
            outRect.set(0, 0, 0, this.mDividerHeight);
        } else {
            outRect.set(0, 0, this.mDividerHeight, 0);
        }
    }

    public void onDraw(@NonNull Canvas canvas, @NonNull RecyclerView parent, @NonNull RecyclerView.State state) {
        super.onDraw(canvas, parent, state);
        if (this.mOrientation == 1) {
            this.drawVertical(canvas, parent);
        } else {
            this.drawHorizontal(canvas, parent);
        }
    }

    private void drawVertical(Canvas canvas, RecyclerView parent) {
        int left = parent.getPaddingLeft() + this.mExtraPadding;
        int right = parent.getMeasuredWidth() - parent.getPaddingRight() - this.mExtraPadding;
        int childSize = parent.getChildCount();
        for (int i = 0; i < childSize - 1; ++i) {
            View child = parent.getChildAt(i);
            RecyclerView.LayoutParams layoutParams = (RecyclerView.LayoutParams)child.getLayoutParams();
            int top = child.getBottom() + layoutParams.bottomMargin;
            int bottom = top + this.mDividerHeight;
            if (this.mDivider != null) {
                this.mDivider.setBounds(left, top, right, bottom);
                this.mDivider.draw(canvas);
            }
            if (this.mPaint == null) continue;
            canvas.drawRect((float)left, (float)top, (float)right, (float)bottom, this.mPaint);
        }
    }

    private void drawHorizontal(Canvas canvas, RecyclerView parent) {
        int top = parent.getPaddingTop() + this.mExtraPadding;
        int bottom = parent.getMeasuredHeight() - parent.getPaddingBottom() - this.mExtraPadding;
        int childSize = parent.getChildCount();
        for (int i = 0; i < childSize - 1; ++i) {
            View child = parent.getChildAt(i);
            RecyclerView.LayoutParams layoutParams = (RecyclerView.LayoutParams)child.getLayoutParams();
            int left = child.getRight() + layoutParams.rightMargin;
            int right = left + this.mDividerHeight;
            if (this.mDivider != null) {
                this.mDivider.setBounds(left, top, right, bottom);
                this.mDivider.draw(canvas);
            }
            if (this.mPaint == null) continue;
            canvas.drawRect((float)left, (float)top, (float)right, (float)bottom, this.mPaint);
        }
    }
}

