/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xtask.thread.pool.cancel;

import com.xuexiang.xtask.thread.pool.cancel.ICancelable;
import com.xuexiang.xtask.thread.pool.cancel.ICancellerPool;
import com.xuexiang.xtask.thread.utils.CancelUtils;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class TaskCancellerPool
implements ICancellerPool {
    private Map<String, ICancelable> mPool = new ConcurrentHashMap<String, ICancelable>();

    @Override
    public boolean add(String name, ICancelable cancelable) {
        if (name == null || cancelable == null) {
            return false;
        }
        return this.mPool.put(name, cancelable) != null;
    }

    @Override
    public boolean remove(String name) {
        if (name == null) {
            return false;
        }
        return this.mPool.remove(name) != null;
    }

    @Override
    public boolean cancel(String name) {
        if (name == null) {
            return false;
        }
        ICancelable cancelable = this.mPool.get(name);
        boolean result = CancelUtils.cancel(cancelable);
        this.mPool.remove(name);
        return result;
    }

    @Override
    public void cancel(String ... names) {
        for (String name : names) {
            this.cancel(name);
        }
    }

    @Override
    public void cancel(Collection<String> names) {
        for (String name : names) {
            this.cancel(name);
        }
    }

    @Override
    public void cancelAll() {
        if (this.mPool.isEmpty()) {
            return;
        }
        CancelUtils.cancel(this.mPool.values());
        this.mPool.clear();
    }

    @Override
    public void clear(boolean ifNeedCancel) {
        if (ifNeedCancel) {
            this.cancelAll();
        } else {
            this.mPool.clear();
        }
    }
}

