/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xtask.thread.pool;

import com.xuexiang.xtask.logger.TaskLogger;
import com.xuexiang.xtask.thread.pool.TaskRecordPolicy;
import com.xuexiang.xtask.thread.pool.TaskThreadFactory;
import com.xuexiang.xtask.thread.pool.base.BaseThreadPoolExecutor;
import com.xuexiang.xtask.thread.priority.IPriority;
import com.xuexiang.xtask.thread.priority.IPriorityComparable;
import com.xuexiang.xtask.thread.priority.IPriorityFuture;
import com.xuexiang.xtask.thread.priority.IPriorityRunnable;
import com.xuexiang.xtask.thread.priority.impl.DefaultPriorityCallable;
import com.xuexiang.xtask.thread.priority.impl.DefaultPriorityFuture;
import com.xuexiang.xtask.thread.priority.impl.DefaultPriorityRunnable;
import com.xuexiang.xtask.thread.priority.impl.Priority;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class PriorityThreadPoolExecutor
extends BaseThreadPoolExecutor {
    private static final String TAG = TaskLogger.getLogTag("PriorityThreadPoolExecutor");

    public static PriorityThreadPoolExecutor getDefault() {
        return new Builder().build();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(int corePoolSize) {
        return new Builder(corePoolSize);
    }

    public static Builder newBuilder(int corePoolSize, long keepAliveTime, TimeUnit unit) {
        return new Builder(corePoolSize, keepAliveTime, unit);
    }

    private PriorityThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, PriorityBlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
    }

    public IPriorityRunnable execute(Runnable command, int priority) {
        if (command instanceof IPriorityRunnable) {
            this.execute(command);
            return (IPriorityRunnable)command;
        }
        DefaultPriorityRunnable runnable = new DefaultPriorityRunnable(new Priority(priority), command);
        this.execute(runnable);
        return runnable;
    }

    public IPriorityFuture<?> submit(Runnable task, int priority) {
        if (task instanceof IPriority) {
            return (IPriorityFuture)this.submit(task);
        }
        return (IPriorityFuture)this.submit(new DefaultPriorityRunnable(new Priority(priority), task));
    }

    public <T> IPriorityFuture<T> submit(Runnable task, T result, int priority) {
        if (task instanceof IPriority) {
            return (IPriorityFuture)this.submit(task, result);
        }
        return (IPriorityFuture)this.submit((Runnable)new DefaultPriorityRunnable(new Priority(priority), task), result);
    }

    public <T> IPriorityFuture<T> submit(Callable<T> task, int priority) {
        if (task instanceof IPriority) {
            return (IPriorityFuture)this.submit(task);
        }
        return (IPriorityFuture)this.submit(new DefaultPriorityCallable<T>(new Priority(priority), task));
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        return new DefaultPriorityFuture<T>(callable);
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
        return new DefaultPriorityFuture<T>(runnable, value);
    }

    @Override
    public void execute(Runnable command) {
        if (command instanceof IPriorityComparable) {
            super.execute(command);
            return;
        }
        if (command instanceof IPriority) {
            super.execute(new DefaultPriorityRunnable((IPriority)((Object)command), command));
            return;
        }
        super.execute(new DefaultPriorityRunnable(new Priority(), command));
    }

    @Override
    public Future<?> submit(Runnable task) {
        if (task instanceof IPriorityComparable) {
            return super.submit(task);
        }
        if (task instanceof IPriority) {
            return super.submit(new DefaultPriorityRunnable((IPriority)((Object)task), task));
        }
        return super.submit(new DefaultPriorityRunnable(new Priority(), task));
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        if (task instanceof IPriorityComparable) {
            return super.submit(task, result);
        }
        if (task instanceof IPriority) {
            return super.submit(new DefaultPriorityRunnable((IPriority)((Object)task), task), result);
        }
        return super.submit(new DefaultPriorityRunnable(new Priority(), task), result);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        if (task instanceof IPriorityComparable) {
            return super.submit(task);
        }
        if (task instanceof IPriority) {
            return super.submit(new DefaultPriorityCallable<T>((IPriority)((Object)task), task));
        }
        return super.submit(new DefaultPriorityCallable<T>(new Priority(), task));
    }

    public static final class Builder {
        private static final int DEFAULT_CORE_POOL_SIZE = Runtime.getRuntime().availableProcessors() + 1;
        private static final long DEFAULT_KEEP_ALIVE_TIME = 30L;
        private static final String DEFAULT_FACTORY_NAME = "Priority";
        int corePoolSize;
        long keepAliveTime;
        TimeUnit unit;
        PriorityBlockingQueue<Runnable> workQueue;
        ThreadFactory threadFactory;
        RejectedExecutionHandler handler;

        public Builder() {
            this(DEFAULT_CORE_POOL_SIZE);
        }

        public Builder(int corePoolSize) {
            this(corePoolSize, 30L, TimeUnit.SECONDS);
        }

        public Builder(int corePoolSize, long keepAliveTime, TimeUnit unit) {
            this.corePoolSize = corePoolSize;
            this.keepAliveTime = keepAliveTime;
            this.unit = unit;
        }

        public Builder setCorePoolSize(int corePoolSize) {
            this.corePoolSize = corePoolSize;
            return this;
        }

        public Builder setKeepAliveTime(long keepAliveTime) {
            this.keepAliveTime = keepAliveTime;
            return this;
        }

        public Builder setUnit(TimeUnit unit) {
            this.unit = unit;
            return this;
        }

        public Builder setWorkQueue(PriorityBlockingQueue<Runnable> workQueue) {
            this.workQueue = workQueue;
            return this;
        }

        public Builder setThreadFactory(ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
            return this;
        }

        public Builder setHandler(RejectedExecutionHandler handler) {
            this.handler = handler;
            return this;
        }

        public PriorityThreadPoolExecutor build() {
            if (this.workQueue == null) {
                this.workQueue = new PriorityBlockingQueue();
            }
            if (this.threadFactory == null) {
                this.threadFactory = TaskThreadFactory.getFactory(DEFAULT_FACTORY_NAME);
            }
            if (this.handler == null) {
                this.handler = new TaskRecordPolicy();
            }
            return new PriorityThreadPoolExecutor(this.corePoolSize, this.corePoolSize, this.keepAliveTime, this.unit, this.workQueue, this.threadFactory, this.handler);
        }
    }
}

