/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xtask.thread.executor.impl;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.xuexiang.xtask.thread.executor.IExecutorCore;
import com.xuexiang.xtask.thread.executor.IPriorityExecutorCore;
import com.xuexiang.xtask.thread.pool.PriorityThreadPoolExecutor;
import com.xuexiang.xtask.thread.pool.TaskThreadFactory;
import com.xuexiang.xtask.thread.pool.cancel.ICancelable;
import com.xuexiang.xtask.thread.utils.ExecutorUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class PriorityExecutorCore
implements IPriorityExecutorCore,
IExecutorCore {
    private static final int CPU_COUNT = Runtime.getRuntime().availableProcessors();
    private static final int GROUP_CORE_POOL_SIZE = Math.max(2, Math.min(CPU_COUNT - 1, 4));
    private static final String GROUP_FACTORY_NAME_PREFIX = "PriorityGroup-";
    private PriorityThreadPoolExecutor mExecutor;
    private Map<String, PriorityThreadPoolExecutor> mGroupExecutorMap = new ConcurrentHashMap<String, PriorityThreadPoolExecutor>();

    @Override
    public ICancelable submit(Runnable task, int priority) {
        return this.submitTask(this.getThreadPoolExecutor(null), task, priority);
    }

    @Override
    public ICancelable submit(String groupName, Runnable task, int priority) {
        return this.submitTask(this.getThreadPoolExecutor(groupName), task, priority);
    }

    @Override
    public void shutdown() {
        ExecutorUtils.shutdown(this.mExecutor);
        this.mExecutor = null;
        ExecutorUtils.shutdown(this.mGroupExecutorMap.values());
        this.mGroupExecutorMap.clear();
    }

    private ICancelable submitTask(@NonNull PriorityThreadPoolExecutor executor, Runnable task, int priority) {
        return executor.submit(task, priority);
    }

    @NonNull
    private PriorityThreadPoolExecutor getThreadPoolExecutor(String groupName) {
        if (TextUtils.isEmpty((CharSequence)groupName)) {
            if (this.mExecutor == null) {
                this.mExecutor = PriorityThreadPoolExecutor.getDefault();
            }
            return this.mExecutor;
        }
        PriorityThreadPoolExecutor executor = this.mGroupExecutorMap.get(groupName);
        if (executor == null) {
            executor = PriorityThreadPoolExecutor.newBuilder(GROUP_CORE_POOL_SIZE).setThreadFactory(TaskThreadFactory.getFactory(GROUP_FACTORY_NAME_PREFIX + groupName)).build();
            this.mGroupExecutorMap.put(groupName, executor);
        }
        return executor;
    }
}

