/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xtask.thread.executor.impl;

import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.xuexiang.xtask.thread.executor.ICategoryExecutorCore;
import com.xuexiang.xtask.thread.pool.DefaultThreadPoolExecutor;
import com.xuexiang.xtask.thread.pool.TaskThreadFactory;
import com.xuexiang.xtask.thread.pool.cancel.CancelHandlerRunnable;
import com.xuexiang.xtask.thread.pool.cancel.ICancelable;
import com.xuexiang.xtask.thread.utils.ExecutorUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.SynchronousQueue;

public class CategoryExecutorCore
implements ICategoryExecutorCore {
    private static final int CPU_COUNT = Runtime.getRuntime().availableProcessors();
    private static final int CORE_POOL_SIZE = 2;
    private static final int GROUP_CORE_POOL_SIZE = Math.max(2, Math.min(CPU_COUNT - 1, 4));
    private static final int IO_POOL_SIZE = CPU_COUNT * 2 + 1;
    private static final int EMERGENT_KEEP_ALIVE_SECONDS = 60;
    private static final String GROUP_FACTORY_NAME_PREFIX = "CategoryGroup-";
    private final Handler mMainHandler = new Handler(Looper.getMainLooper());
    private DefaultThreadPoolExecutor mEmergentExecutor;
    private DefaultThreadPoolExecutor mNormalExecutor;
    private DefaultThreadPoolExecutor mBackgroundExecutor;
    private Map<String, DefaultThreadPoolExecutor> mGroupExecutorMap = new ConcurrentHashMap<String, DefaultThreadPoolExecutor>();
    private DefaultThreadPoolExecutor mIoExecutor;

    @Override
    public boolean postToMain(Runnable task) {
        if (ExecutorUtils.isMainThread()) {
            task.run();
            return true;
        }
        return this.mMainHandler.post(task);
    }

    @Override
    public ICancelable postToMainDelay(Runnable task, long delayMillis) {
        return CancelHandlerRunnable.get(this.mMainHandler, task).startDelayed(delayMillis);
    }

    @Override
    public ICancelable emergentSubmit(Runnable task) {
        return this.submitTask(this.getTargetExecutor(10), task);
    }

    @Override
    public ICancelable submit(Runnable task) {
        return this.submitTask(this.getTargetExecutor(5), task);
    }

    @Override
    public ICancelable backgroundSubmit(Runnable task) {
        return this.submitTask(this.getTargetExecutor(1), task);
    }

    @Override
    public ICancelable ioSubmit(Runnable task) {
        return this.submitTask(this.getIoExecutor(), task);
    }

    @Override
    public ICancelable groupSubmit(String groupName, Runnable task) {
        return this.submitTask(this.getGroupExecutor(groupName), task);
    }

    @Override
    public void shutdown() {
        this.mMainHandler.removeCallbacksAndMessages(null);
        ExecutorUtils.shutdown(this.mEmergentExecutor);
        this.mEmergentExecutor = null;
        ExecutorUtils.shutdown(this.mNormalExecutor);
        this.mNormalExecutor = null;
        ExecutorUtils.shutdown(this.mBackgroundExecutor);
        this.mBackgroundExecutor = null;
        ExecutorUtils.shutdown(this.mIoExecutor);
        this.mIoExecutor = null;
        ExecutorUtils.shutdown(this.mGroupExecutorMap.values());
        this.mGroupExecutorMap.clear();
    }

    private ICancelable submitTask(@NonNull DefaultThreadPoolExecutor executor, Runnable task) {
        return executor.submit(task);
    }

    @NonNull
    private DefaultThreadPoolExecutor getTargetExecutor(int priority) {
        if (priority == 10) {
            return this.getEmergentExecutor();
        }
        if (priority == 5) {
            return this.getNormalExecutor();
        }
        return this.getBackgroundExecutor(priority);
    }

    private DefaultThreadPoolExecutor getEmergentExecutor() {
        if (this.mEmergentExecutor == null) {
            this.mEmergentExecutor = DefaultThreadPoolExecutor.newBuilder(2).setMaximumPoolSize(Integer.MAX_VALUE).setKeepAliveTime(60L).setWorkQueue(new SynchronousQueue<Runnable>()).setThreadFactory(TaskThreadFactory.getFactory("Emergent", 10)).build();
        }
        return this.mEmergentExecutor;
    }

    private DefaultThreadPoolExecutor getNormalExecutor() {
        if (this.mNormalExecutor == null) {
            this.mNormalExecutor = DefaultThreadPoolExecutor.newBuilder(CPU_COUNT).setKeepAliveTime(0L).setThreadFactory(TaskThreadFactory.getFactory("Normal", 5)).build();
        }
        return this.mNormalExecutor;
    }

    private DefaultThreadPoolExecutor getBackgroundExecutor(int priority) {
        if (this.mBackgroundExecutor == null) {
            this.mBackgroundExecutor = DefaultThreadPoolExecutor.newBuilder(2).setKeepAliveTime(0L).setThreadFactory(TaskThreadFactory.getFactory("Background", priority)).build();
        }
        return this.mBackgroundExecutor;
    }

    private DefaultThreadPoolExecutor getIoExecutor() {
        if (this.mIoExecutor == null) {
            this.mIoExecutor = DefaultThreadPoolExecutor.newBuilder(IO_POOL_SIZE).setThreadFactory(TaskThreadFactory.getFactory("Io", 5)).build();
        }
        return this.mIoExecutor;
    }

    @NonNull
    private DefaultThreadPoolExecutor getGroupExecutor(String groupName) {
        if (TextUtils.isEmpty((CharSequence)groupName)) {
            return this.getTargetExecutor(5);
        }
        DefaultThreadPoolExecutor executor = this.mGroupExecutorMap.get(groupName);
        if (executor == null) {
            executor = DefaultThreadPoolExecutor.newBuilder(GROUP_CORE_POOL_SIZE).setThreadFactory(TaskThreadFactory.getFactory(GROUP_FACTORY_NAME_PREFIX + groupName)).build();
            this.mGroupExecutorMap.put(groupName, executor);
        }
        return executor;
    }
}

