/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xqrcode.view;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.View;
import com.google.zxing.ResultPoint;
import com.xuexiang.xqrcode.R;
import com.xuexiang.xqrcode.camera.CameraManager;
import java.util.Collection;
import java.util.HashSet;

public final class ViewfinderView
extends View {
    private static final int DEFAULT_ANIMATION_INTERVAL = 25;
    private static final int OPAQUE = 255;
    private final Paint mPaint = new Paint();
    private Bitmap mResultBitmap;
    private int mMaskColor;
    private int mResultColor;
    private int mResultPointColor;
    private Collection<ResultPoint> mPossibleResultPoints = new HashSet<ResultPoint>(5);
    private Collection<ResultPoint> mLastPossibleResultPoints;
    private int scanLineTop;
    private int scanVelocity;
    private Bitmap scanLight;
    private long scanAnimationInterval;
    private boolean isCircle;
    private int cornerColor;
    private int cornerLength;
    private int cornerWidth;

    public ViewfinderView(Context context) {
        this(context, null);
    }

    public ViewfinderView(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.ViewfinderViewStyle);
    }

    public ViewfinderView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initInnerRect(context, attrs, defStyleAttr);
    }

    private void initInnerRect(Context context, AttributeSet attrs, int defStyleAttr) {
        Resources resources = this.getResources();
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.ViewfinderView, defStyleAttr, 0);
        int innerMarginTop = ta.getDimensionPixelSize(R.styleable.ViewfinderView_inner_marginTop, -1);
        if (innerMarginTop != -1) {
            CameraManager.FRAME_MARGIN_TOP = innerMarginTop;
        }
        CameraManager.FRAME_WIDTH = ta.getDimensionPixelSize(R.styleable.ViewfinderView_inner_width, this.getDefaultScanSize(this.getContext()));
        CameraManager.FRAME_HEIGHT = ta.getDimensionPixelSize(R.styleable.ViewfinderView_inner_height, this.getDefaultScanSize(this.getContext()));
        this.cornerColor = ta.getColor(R.styleable.ViewfinderView_inner_corner_color, resources.getColor(R.color.default_inner_corner_color));
        this.cornerLength = ta.getDimensionPixelSize(R.styleable.ViewfinderView_inner_corner_length, resources.getDimensionPixelSize(R.dimen.default_inner_corner_length));
        this.cornerWidth = ta.getDimensionPixelSize(R.styleable.ViewfinderView_inner_corner_width, resources.getDimensionPixelSize(R.dimen.default_inner_corner_width));
        this.scanLight = BitmapFactory.decodeResource((Resources)this.getResources(), (int)ta.getResourceId(R.styleable.ViewfinderView_inner_scan_bitmap, R.drawable.xqrcode_ic_scan_light));
        int tintColor = ta.getColor(R.styleable.ViewfinderView_inner_scan_bitmap_tint, -1);
        if (tintColor != -1) {
            Bitmap tmp = this.scanLight.copy(Bitmap.Config.ARGB_8888, true);
            this.scanLight.recycle();
            Canvas canvas = new Canvas(tmp);
            canvas.drawColor(tintColor, PorterDuff.Mode.SRC_IN);
            this.scanLight = tmp;
        }
        this.scanVelocity = ta.getDimensionPixelSize(R.styleable.ViewfinderView_inner_scan_speed, resources.getDimensionPixelSize(R.dimen.default_inner_scan_speed));
        this.scanAnimationInterval = ta.getInt(R.styleable.ViewfinderView_inner_scan_animation_interval, 25);
        this.isCircle = ta.getBoolean(R.styleable.ViewfinderView_inner_scan_isCircle, true);
        this.mMaskColor = ta.getColor(R.styleable.ViewfinderView_inner_mask_color, resources.getColor(R.color.default_mask_color));
        this.mResultColor = ta.getColor(R.styleable.ViewfinderView_inner_result_color, resources.getColor(R.color.default_result_color));
        this.mResultPointColor = ta.getColor(R.styleable.ViewfinderView_inner_result_point_color, resources.getColor(R.color.default_result_point_color));
        ta.recycle();
    }

    public void onDraw(Canvas canvas) {
        Rect frame = CameraManager.get().getFramingRect();
        if (frame == null) {
            return;
        }
        int width = canvas.getWidth();
        int height = canvas.getHeight();
        this.mPaint.setColor(this.mResultBitmap != null ? this.mResultColor : this.mMaskColor);
        canvas.drawRect(0.0f, 0.0f, (float)width, (float)frame.top, this.mPaint);
        canvas.drawRect(0.0f, (float)frame.top, (float)frame.left, (float)frame.bottom, this.mPaint);
        canvas.drawRect((float)frame.right, (float)frame.top, (float)width, (float)frame.bottom, this.mPaint);
        canvas.drawRect(0.0f, (float)frame.bottom, (float)width, (float)height, this.mPaint);
        if (this.mResultBitmap != null) {
            this.mPaint.setAlpha(255);
            canvas.drawBitmap(this.mResultBitmap, (float)frame.left, (float)frame.top, this.mPaint);
        } else {
            this.drawFrameBounds(canvas, frame);
            this.drawScanLight(canvas, frame);
            Collection<ResultPoint> currentPossible = this.mPossibleResultPoints;
            Collection<ResultPoint> currentLast = this.mLastPossibleResultPoints;
            if (currentPossible.isEmpty()) {
                this.mLastPossibleResultPoints = null;
            } else {
                this.mPossibleResultPoints = new HashSet<ResultPoint>(5);
                this.mLastPossibleResultPoints = currentPossible;
                this.mPaint.setAlpha(255);
                this.mPaint.setColor(this.mResultPointColor);
                if (this.isCircle) {
                    for (ResultPoint point : currentPossible) {
                        canvas.drawCircle((float)frame.left + point.getX(), (float)frame.top + point.getY(), 6.0f, this.mPaint);
                    }
                }
            }
            if (currentLast != null) {
                this.mPaint.setAlpha(127);
                this.mPaint.setColor(this.mResultPointColor);
                if (this.isCircle) {
                    for (ResultPoint point : currentLast) {
                        canvas.drawCircle((float)frame.left + point.getX(), (float)frame.top + point.getY(), 3.0f, this.mPaint);
                    }
                }
            }
            this.postInvalidateDelayed(this.scanAnimationInterval, frame.left, frame.top, frame.right, frame.bottom);
        }
    }

    private void drawScanLight(Canvas canvas, Rect frame) {
        if (this.scanLineTop == 0) {
            this.scanLineTop = frame.top;
        }
        this.scanLineTop = this.scanLineTop >= frame.bottom - 30 ? frame.top : (this.scanLineTop += this.scanVelocity);
        Rect scanRect = new Rect(frame.left, this.scanLineTop, frame.right, this.scanLineTop + 30);
        canvas.drawBitmap(this.scanLight, null, scanRect, this.mPaint);
    }

    private void drawFrameBounds(Canvas canvas, Rect frame) {
        this.mPaint.setColor(this.cornerColor);
        this.mPaint.setStyle(Paint.Style.FILL);
        int corWidth = this.cornerWidth;
        int corLength = this.cornerLength;
        canvas.drawRect((float)frame.left, (float)frame.top, (float)(frame.left + corWidth), (float)(frame.top + corLength), this.mPaint);
        canvas.drawRect((float)frame.left, (float)frame.top, (float)(frame.left + corLength), (float)(frame.top + corWidth), this.mPaint);
        canvas.drawRect((float)(frame.right - corWidth), (float)frame.top, (float)frame.right, (float)(frame.top + corLength), this.mPaint);
        canvas.drawRect((float)(frame.right - corLength), (float)frame.top, (float)frame.right, (float)(frame.top + corWidth), this.mPaint);
        canvas.drawRect((float)frame.left, (float)(frame.bottom - corLength), (float)(frame.left + corWidth), (float)frame.bottom, this.mPaint);
        canvas.drawRect((float)frame.left, (float)(frame.bottom - corWidth), (float)(frame.left + corLength), (float)frame.bottom, this.mPaint);
        canvas.drawRect((float)(frame.right - corWidth), (float)(frame.bottom - corLength), (float)frame.right, (float)frame.bottom, this.mPaint);
        canvas.drawRect((float)(frame.right - corLength), (float)(frame.bottom - corWidth), (float)frame.right, (float)frame.bottom, this.mPaint);
    }

    public void drawViewfinder() {
        this.mResultBitmap = null;
        this.invalidate();
    }

    public void addPossibleResultPoint(ResultPoint point) {
        this.mPossibleResultPoints.add(point);
    }

    public int getDefaultScanSize(Context context) {
        return Math.min(ViewfinderView.getScreenWidth(context), ViewfinderView.getScreenHeight(context)) * 3 / 4;
    }

    private static int getScreenWidth(Context context) {
        return context.getResources().getDisplayMetrics().widthPixels;
    }

    private static int getScreenHeight(Context context) {
        return context.getResources().getDisplayMetrics().heightPixels;
    }
}

