/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xqrcode.logs;

import android.util.Log;
import androidx.annotation.NonNull;
import com.xuexiang.xqrcode.logs.ILogger;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;

public class LogcatLogger
implements ILogger {
    private static final int MAX_LOG_LENGTH = 4000;

    @Override
    public void log(int priority, String tag, String message, Throwable t) {
        if (message != null && message.length() == 0) {
            message = null;
        }
        if (message == null) {
            if (t == null) {
                return;
            }
            message = this.getStackTraceString(t);
        } else if (t != null) {
            message = message + "\n" + this.getStackTraceString(t);
        }
        this.log(priority, tag, message);
    }

    private String getStackTraceString(Throwable t) {
        StringWriter sw = new StringWriter(256);
        PrintWriter pw = new PrintWriter((Writer)sw, false);
        t.printStackTrace(pw);
        pw.flush();
        return sw.toString();
    }

    public void log(int priority, String tag, String message) {
        int subNum = message.length() / 4000;
        if (subNum > 0) {
            int index = 0;
            for (int i = 0; i < subNum; ++i) {
                int lastIndex = index + 4000;
                String sub = message.substring(index, lastIndex);
                this.logSub(priority, tag, sub);
                index = lastIndex;
            }
            this.logSub(priority, tag, message.substring(index, message.length()));
        } else {
            this.logSub(priority, tag, message);
        }
    }

    private void logSub(int priority, @NonNull String tag, @NonNull String sub) {
        switch (priority) {
            case 2: {
                Log.v((String)tag, (String)sub);
                break;
            }
            case 3: {
                Log.d((String)tag, (String)sub);
                break;
            }
            case 4: {
                Log.i((String)tag, (String)sub);
                break;
            }
            case 5: {
                Log.w((String)tag, (String)sub);
                break;
            }
            case 6: {
                Log.e((String)tag, (String)sub);
                break;
            }
            case 7: {
                Log.wtf((String)tag, (String)sub);
                break;
            }
            default: {
                Log.v((String)tag, (String)sub);
            }
        }
    }
}

