/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xqrcode.decoding;

import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.Result;
import com.xuexiang.xqrcode.R;
import com.xuexiang.xqrcode.camera.CameraManager;
import com.xuexiang.xqrcode.decoding.DecodeThread;
import com.xuexiang.xqrcode.logs.QCLog;
import com.xuexiang.xqrcode.ui.ICaptureView;
import com.xuexiang.xqrcode.view.ViewfinderResultPointCallback;
import com.xuexiang.xqrcode.view.ViewfinderView;
import java.util.Vector;

public final class CaptureViewHandler
extends Handler {
    private static final String TAG = CaptureViewHandler.class.getSimpleName();
    private final ICaptureView mCaptureView;
    private final DecodeThread mDecodeThread;
    private State mState;

    public CaptureViewHandler(ICaptureView captureView, Vector<BarcodeFormat> decodeFormats, String characterSet, ViewfinderView viewfinderView) {
        this.mCaptureView = captureView;
        this.mDecodeThread = new DecodeThread(captureView, decodeFormats, characterSet, new ViewfinderResultPointCallback(viewfinderView));
        this.mDecodeThread.start();
        this.mState = State.SUCCESS;
        CameraManager.get().startPreview();
        this.restartPreviewAndDecode();
    }

    public void handleMessage(Message message) {
        if (message.what == R.id.auto_focus) {
            if (this.mState == State.PREVIEW) {
                CameraManager.get().requestAutoFocus(this, R.id.auto_focus);
            }
        } else if (message.what == R.id.restart_preview) {
            QCLog.dTag(TAG, "Got restart preview message");
            this.restartPreviewAndDecode();
        } else if (message.what == R.id.decode_succeeded) {
            QCLog.dTag(TAG, "Got decode succeeded message");
            this.mState = State.SUCCESS;
            Bundle bundle = message.getData();
            Bitmap barcode = bundle == null ? null : (Bitmap)bundle.getParcelable("barcode_bitmap");
            this.mCaptureView.handleDecode((Result)message.obj, barcode);
        } else if (message.what == R.id.decode_failed) {
            this.mState = State.PREVIEW;
            CameraManager.get().requestPreviewFrame(this.mDecodeThread.getHandler(), R.id.decode);
        } else if (message.what == R.id.return_scan_result) {
            QCLog.dTag(TAG, "Got return scan result message");
            this.mCaptureView.getActivity().setResult(-1, (Intent)message.obj);
            this.mCaptureView.getActivity().finish();
        } else if (message.what == R.id.launch_product_query) {
            QCLog.dTag(TAG, "Got product query message");
            String url = (String)message.obj;
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
            intent.addFlags(524288);
            this.mCaptureView.getActivity().startActivity(intent);
        }
    }

    public void quitSynchronously() {
        this.mState = State.DONE;
        CameraManager.get().stopPreview();
        Message quit = Message.obtain((Handler)this.mDecodeThread.getHandler(), (int)R.id.quit);
        quit.sendToTarget();
        try {
            this.mDecodeThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.removeMessages(R.id.decode_succeeded);
        this.removeMessages(R.id.decode_failed);
    }

    private void restartPreviewAndDecode() {
        if (this.mState == State.SUCCESS) {
            this.mState = State.PREVIEW;
            CameraManager.get().requestPreviewFrame(this.mDecodeThread.getHandler(), R.id.decode);
            CameraManager.get().requestAutoFocus(this, R.id.auto_focus);
            this.mCaptureView.drawViewfinder();
        }
    }

    private static enum State {
        PREVIEW,
        SUCCESS,
        DONE;

    }
}

