/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xpage.core;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.xuexiang.xpage.R;
import com.xuexiang.xpage.enums.CoreAnim;
import java.util.Arrays;

public class CoreSwitchBean
implements Parcelable {
    public static final String KEY_SWITCHBEAN = "SwitchBean";
    public static final String KEY_START_ACTIVITY_FOR_RESULT = "startActivityForResult";
    public static final Parcelable.Creator<CoreSwitchBean> CREATOR = new Parcelable.Creator<CoreSwitchBean>(){

        public CoreSwitchBean createFromParcel(Parcel in) {
            return new CoreSwitchBean(in);
        }

        public CoreSwitchBean[] newArray(int size) {
            return new CoreSwitchBean[size];
        }
    };
    private String mPageName;
    private Bundle mBundle;
    private int[] mAnim = null;
    private boolean mAddToBackStack = true;
    private boolean mNewActivity = false;
    private int mRequestCode = -1;

    public CoreSwitchBean(String pageName) {
        this.mPageName = pageName;
    }

    public CoreSwitchBean(String pageName, Bundle bundle) {
        this.mPageName = pageName;
        this.mBundle = bundle;
    }

    public CoreSwitchBean(String pageName, Bundle bundle, CoreAnim coreAnim) {
        this.mPageName = pageName;
        this.mBundle = bundle;
        this.setAnim(coreAnim);
    }

    public void setAnim(CoreAnim anim2) {
        this.mAnim = CoreSwitchBean.convertAnimations(anim2);
    }

    public static int[] convertAnimations(CoreAnim coreAnim) {
        if (coreAnim == CoreAnim.present) {
            int[] animations = new int[]{R.anim.xpage_push_in_down, R.anim.xpage_push_no_ani, R.anim.xpage_push_no_ani, R.anim.xpage_push_out_down};
            return animations;
        }
        if (coreAnim == CoreAnim.fade) {
            int[] animations = new int[]{R.anim.xpage_alpha_in, R.anim.xpage_alpha_out, R.anim.xpage_alpha_in, R.anim.xpage_alpha_out};
            return animations;
        }
        if (coreAnim == CoreAnim.slide) {
            int[] animations = new int[]{R.anim.xpage_slide_in_right, R.anim.xpage_slide_out_left, R.anim.xpage_slide_in_left, R.anim.xpage_slide_out_right};
            return animations;
        }
        if (coreAnim == CoreAnim.zoom) {
            int[] animations = new int[]{R.anim.xpage_zoom_in, R.anim.xpage_zoom_out, R.anim.xpage_zoom_in, R.anim.xpage_zoom_out};
            return animations;
        }
        return null;
    }

    public CoreSwitchBean(String pageName, Bundle bundle, int[] anim2) {
        this.mPageName = pageName;
        this.mBundle = bundle;
        this.mAnim = anim2;
    }

    public CoreSwitchBean(String pageName, Bundle bundle, CoreAnim coreAnim, boolean addToBackStack) {
        this.mPageName = pageName;
        this.mBundle = bundle;
        this.setAnim(coreAnim);
        this.mAddToBackStack = addToBackStack;
    }

    public CoreSwitchBean(String pageName, Bundle bundle, int[] anim2, boolean addToBackStack) {
        this.mPageName = pageName;
        this.mBundle = bundle;
        this.mAnim = anim2;
        this.mAddToBackStack = addToBackStack;
    }

    public CoreSwitchBean(String pageName, Bundle bundle, CoreAnim coreAnim, boolean addToBackStack, boolean newActivity) {
        this.mPageName = pageName;
        this.mBundle = bundle;
        this.setAnim(coreAnim);
        this.mAddToBackStack = addToBackStack;
        this.mNewActivity = newActivity;
    }

    public CoreSwitchBean(String pageName, Bundle bundle, int[] anim2, boolean addToBackStack, boolean newActivity) {
        this.mPageName = pageName;
        this.mBundle = bundle;
        this.mAnim = anim2;
        this.mAddToBackStack = addToBackStack;
        this.mNewActivity = newActivity;
    }

    public CoreSwitchBean(String pageName, Bundle bundle, int[] anim2, boolean addToBackStack, boolean newActivity, int requestCode) {
        this.mPageName = pageName;
        this.mBundle = bundle;
        this.mAnim = anim2;
        this.mAddToBackStack = addToBackStack;
        this.mNewActivity = newActivity;
        this.mRequestCode = requestCode;
    }

    protected CoreSwitchBean(Parcel in) {
        this.mPageName = in.readString();
        this.mBundle = in.readBundle();
        int[] a = new int[]{in.readInt(), in.readInt(), in.readInt(), in.readInt()};
        this.mAnim = a;
        this.mAddToBackStack = in.readInt() == 1;
        this.mNewActivity = in.readInt() == 1;
        this.mRequestCode = in.readInt();
    }

    public String getPageName() {
        return this.mPageName;
    }

    public CoreSwitchBean setPageName(String pageName) {
        this.mPageName = pageName;
        return this;
    }

    public boolean isNewActivity() {
        return this.mNewActivity;
    }

    public CoreSwitchBean setNewActivity(boolean newActivity) {
        this.mNewActivity = newActivity;
        return this;
    }

    public boolean isAddToBackStack() {
        return this.mAddToBackStack;
    }

    public CoreSwitchBean setAddToBackStack(boolean addToBackStack) {
        this.mAddToBackStack = addToBackStack;
        return this;
    }

    public int[] getAnim() {
        return this.mAnim;
    }

    public CoreSwitchBean setAnim(int[] anim2) {
        this.mAnim = anim2;
        return this;
    }

    public Bundle getBundle() {
        return this.mBundle;
    }

    public CoreSwitchBean setBundle(Bundle bundle) {
        this.mBundle = bundle;
        return this;
    }

    public int getRequestCode() {
        return this.mRequestCode;
    }

    public CoreSwitchBean setRequestCode(int requestCode) {
        this.mRequestCode = requestCode;
        return this;
    }

    public String toString() {
        return "SwitchBean{mPageName='" + this.mPageName + '\'' + ", mBundle=" + this.mBundle + ", mAnim=" + Arrays.toString(this.mAnim) + ", mAddToBackStack=" + this.mAddToBackStack + ", mNewActivity=" + this.mNewActivity + ", mRequestCode=" + this.mRequestCode + '}';
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        if (this.mPageName == null) {
            this.mPageName = "";
        }
        if (this.mBundle == null) {
            this.mBundle = new Bundle();
        }
        if (this.mAnim == null) {
            int[] a = new int[]{-1, -1, -1, -1};
            this.mAnim = a;
        }
        out.writeString(this.mPageName);
        this.mBundle.writeToParcel(out, flags);
        if (this.mAnim != null && this.mAnim.length == 4) {
            out.writeInt(this.mAnim[0]);
            out.writeInt(this.mAnim[1]);
            out.writeInt(this.mAnim[2]);
            out.writeInt(this.mAnim[3]);
        } else {
            out.writeInt(-1);
            out.writeInt(-1);
            out.writeInt(-1);
            out.writeInt(-1);
        }
        out.writeInt(this.mAddToBackStack ? 1 : 0);
        out.writeInt(this.mNewActivity ? 1 : 0);
        out.writeInt(this.mRequestCode);
    }
}

