/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xhttp2.utils;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.provider.MediaStore;
import android.support.annotation.RequiresApi;
import com.xuexiang.xhttp2.XHttp;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import okhttp3.MediaType;

public final class Utils {
    private static final String EXT_STORAGE_PATH = Utils.getExtStoragePath();
    private static final String EXT_STORAGE_DIR = EXT_STORAGE_PATH + File.separator;
    private static final String APP_EXT_STORAGE_PATH = EXT_STORAGE_DIR + "Android";
    private static final String EXT_DOWNLOADS_PATH = Utils.getExtDownloadsPath();
    private static final String EXT_PICTURES_PATH = Utils.getExtPicturesPath();
    private static final String EXT_DCIM_PATH = Utils.getExtDCIMPath();

    private Utils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static <T> T checkNotNull(T t, String message) {
        if (t == null) {
            throw new NullPointerException(message);
        }
        return t;
    }

    public static boolean isNetworkAvailable(Context context) {
        ConnectivityManager manager = (ConnectivityManager)context.getApplicationContext().getSystemService("connectivity");
        if (null == manager) {
            return false;
        }
        NetworkInfo info = manager.getActiveNetworkInfo();
        return null != info && info.isAvailable();
    }

    public static void closeIO(Closeable ... closeables) {
        if (closeables == null) {
            return;
        }
        for (Closeable closeable : closeables) {
            if (closeable == null) continue;
            try {
                closeable.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static File getDiskCacheDir(Context context, String uniqueName) {
        String cachePath = Utils.isSDCardExist() && context.getExternalCacheDir() != null ? context.getExternalCacheDir().getPath() : context.getCacheDir().getPath();
        return new File(cachePath + File.separator + uniqueName);
    }

    private static boolean isSDCardExist() {
        return "mounted".equals(Environment.getExternalStorageState()) || !Environment.isExternalStorageRemovable();
    }

    private static String getDiskFilesDir() {
        return Utils.isSDCardExist() && XHttp.getContext().getExternalFilesDir(null) != null ? XHttp.getContext().getExternalFilesDir(null).getPath() : XHttp.getContext().getFilesDir().getPath();
    }

    public static String getDiskFilesDir(String fileDir) {
        return Utils.getDiskFilesDir() + File.separator + fileDir;
    }

    public static boolean isScopedStorageMode() {
        return Build.VERSION.SDK_INT >= 29 && !Environment.isExternalStorageLegacy();
    }

    public static boolean isPublicPath(File file) {
        if (file == null) {
            return false;
        }
        try {
            return Utils.isPublicPath(file.getCanonicalFile());
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isPublicPath(String filePath) {
        if (Utils.isEmpty(filePath)) {
            return false;
        }
        return filePath.startsWith(EXT_STORAGE_PATH) && !filePath.startsWith(APP_EXT_STORAGE_PATH);
    }

    public static String getExtDownloadsPath() {
        return Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DOWNLOADS).getAbsolutePath();
    }

    public static String getExtPicturesPath() {
        return Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_PICTURES).getAbsolutePath();
    }

    public static String getExtDCIMPath() {
        return Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DCIM).getAbsolutePath();
    }

    public static String getExtStoragePath() {
        return Environment.getExternalStorageDirectory().getAbsolutePath();
    }

    public static boolean isEmpty(CharSequence s) {
        return s == null || s.length() == 0;
    }

    public static long toLong(String value, long defValue) {
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return defValue;
        }
    }

    @RequiresApi(api=29)
    public static Uri getDownloadFileUri(String dirPath, String fileName, MediaType mediaType) {
        ContentValues values = new ContentValues();
        values.put("title", fileName);
        values.put("_display_name", fileName);
        values.put("mime_type", mediaType.toString());
        values.put("relative_path", Utils.getRelativePath(dirPath));
        return Utils.getContentResolver().insert(MediaStore.Downloads.EXTERNAL_CONTENT_URI, values);
    }

    @RequiresApi(api=29)
    public static Uri getMediaFileUri(String dirPath, String fileName, MediaType mediaType) {
        ContentValues values = new ContentValues();
        values.put("title", fileName);
        values.put("_display_name", fileName);
        values.put("date_added", Long.valueOf(System.currentTimeMillis()));
        values.put("mime_type", mediaType.toString());
        values.put("orientation", Integer.valueOf(0));
        values.put("relative_path", Utils.getRelativePath(dirPath));
        if ("image".equals(mediaType.type())) {
            return Utils.getContentResolver().insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, values);
        }
        if ("audio".equals(mediaType.type())) {
            return Utils.getContentResolver().insert(MediaStore.Audio.Media.EXTERNAL_CONTENT_URI, values);
        }
        if ("video".equals(mediaType.type())) {
            return Utils.getContentResolver().insert(MediaStore.Video.Media.EXTERNAL_CONTENT_URI, values);
        }
        return Utils.getContentResolver().insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, values);
    }

    public static Uri getNormalFileUri(String dirPath, String fileName, MediaType mediaType) {
        ContentValues values = new ContentValues();
        values.put("_data", Utils.getFilePath(dirPath, fileName));
        values.put("mime_type", mediaType.toString());
        return Utils.getContentResolver().insert(MediaStore.Files.getContentUri((String)"external"), values);
    }

    private static String getRelativePath(String dirPath) {
        int index = dirPath.indexOf(EXT_STORAGE_DIR);
        if (index != -1) {
            return dirPath.substring(EXT_STORAGE_DIR.length());
        }
        return dirPath;
    }

    @RequiresApi(api=29)
    public static OutputStream getOutputStream(String dirPath, String fileName, MediaType mediaType) throws FileNotFoundException {
        Uri uri = Utils.getFileUri(dirPath, fileName, mediaType);
        return Utils.openOutputStream(uri);
    }

    @RequiresApi(api=29)
    public static Uri getFileUri(String dirPath, String fileName, MediaType mediaType) {
        Uri uri = dirPath.startsWith(EXT_DOWNLOADS_PATH) ? Utils.getDownloadFileUri(dirPath, fileName, mediaType) : (dirPath.startsWith(EXT_PICTURES_PATH) || dirPath.startsWith(EXT_DCIM_PATH) ? Utils.getMediaFileUri(dirPath, fileName, mediaType) : Utils.getNormalFileUri(dirPath, fileName, mediaType));
        return uri;
    }

    public static OutputStream openOutputStream(Uri uri) throws FileNotFoundException {
        return Utils.getContentResolver().openOutputStream(uri);
    }

    private static ContentResolver getContentResolver() {
        return XHttp.getContext().getContentResolver();
    }

    public static String getFilePath(String dirPath, String fileName) {
        return Utils.getDirPath(dirPath) + fileName;
    }

    public static String getDirPath(String dirPath) {
        if (Utils.isEmpty(dirPath)) {
            return "";
        }
        if (!dirPath.trim().endsWith(File.separator)) {
            dirPath = dirPath.trim() + File.separator;
        }
        return dirPath;
    }
}

