/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xhttp2.utils;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.gson.Gson;
import com.xuexiang.xhttp2.annotation.ParamKey;
import com.xuexiang.xhttp2.logs.HttpLog;
import com.xuexiang.xhttp2.model.ApiResult;
import com.xuexiang.xhttp2.model.XHttpRequest;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import org.json.JSONObject;

public final class HttpUtils {
    public static final Charset UTF8 = Charset.forName("UTF-8");

    private HttpUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static RequestBody getJsonRequestBody(Object object) {
        return RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)new Gson().toJson(object));
    }

    public static RequestBody getJsonRequestBody(String json) {
        return RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)json);
    }

    public static ResponseBody getJsonResponseBody(String json) {
        return ResponseBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)json);
    }

    @Nullable
    public static byte[] getResponseBody(@NonNull Response response) {
        ResponseBody responseBody = response.body();
        byte[] source = null;
        try {
            source = responseBody.bytes();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return source;
    }

    @NonNull
    public static String getResponseBodyString(Response response) throws IOException {
        ResponseBody responseBody = response.body();
        BufferedSource source = responseBody.source();
        source.request(Long.MAX_VALUE);
        Buffer buffer = source.buffer();
        Charset charset = UTF8;
        MediaType contentType = responseBody.contentType();
        if (contentType != null) {
            charset = contentType.charset(UTF8);
        }
        return buffer.clone().readString(charset);
    }

    public static boolean isText(MediaType mediaType) {
        return mediaType != null && (mediaType.type() != null && mediaType.type().equals("text") || mediaType.subtype() != null && mediaType.subtype().equals("json"));
    }

    public static boolean isPlaintext(MediaType mediaType) {
        if (mediaType == null) {
            return false;
        }
        if (mediaType.type() != null && mediaType.type().equals("text")) {
            return true;
        }
        String subtype = mediaType.subtype();
        if (subtype != null) {
            return (subtype = subtype.toLowerCase()).contains("x-www-form-urlencoded") || subtype.contains("json") || subtype.contains("xml") || subtype.contains("html");
        }
        return false;
    }

    public static String getAnnotationParamString(XHttpRequest xHttpRequest) throws IllegalAccessException {
        Field[] fields;
        TreeMap<String, Object> params = new TreeMap<String, Object>();
        for (Field field : fields = xHttpRequest.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            ParamKey paramKey = field.getAnnotation(ParamKey.class);
            if (paramKey != null) {
                params.put(paramKey.key(), field.get(xHttpRequest));
                continue;
            }
            params.put(field.getName(), field.get(xHttpRequest));
        }
        return new Gson().toJson(params);
    }

    public static Request updateRequestBody(Request oldRequest, HashMap<String, Object> params) {
        String requestBody = HttpUtils.getRequestBodyString(oldRequest);
        try {
            JSONObject jsonObject = new JSONObject(requestBody);
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                jsonObject.put(entry.getKey(), entry.getValue());
            }
            return oldRequest.newBuilder().post(HttpUtils.getJsonRequestBody(jsonObject.toString())).build();
        }
        catch (Throwable e) {
            e.printStackTrace();
            return oldRequest;
        }
    }

    public static String getRequestBodyString(Request request) {
        try {
            Request copy = request.newBuilder().build();
            Buffer buffer = new Buffer();
            copy.body().writeTo((BufferedSink)buffer);
            Charset charset = UTF8;
            MediaType contentType = copy.body().contentType();
            if (contentType != null) {
                charset = contentType.charset(UTF8);
            }
            return buffer.readString(charset);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static Response getErrorResponse(Response oldResponse, int code, String message) {
        ApiResult apiResult = new ApiResult().setCode(code).setMsg(message);
        return oldResponse.newBuilder().body(HttpUtils.getJsonResponseBody(new Gson().toJson((Object)apiResult))).build();
    }

    public static Request resetUrlParams(Request oldRequest, String key, Object value) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put(key, value);
        return HttpUtils.resetUrlParams(oldRequest, params);
    }

    public static Request resetUrlParams(Request oldRequest, Map<String, Object> params) {
        String url = HttpUtils.createUrlFromParams(HttpUtils.parseUrl(oldRequest.url().toString()), params);
        return oldRequest.newBuilder().url(url).build();
    }

    public static Request updateUrlParams(Request oldRequest, String key, Object value) {
        return oldRequest.newBuilder().url(HttpUtils.updateUrlParams(oldRequest.url().toString(), key, value)).build();
    }

    public static Request updateUrlParams(Request oldRequest, Map<String, Object> params) {
        return oldRequest.newBuilder().url(HttpUtils.updateUrlParams(oldRequest.url().toString(), params)).build();
    }

    public static String updateUrlParams(String url, String key, Object value) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put(key, value);
        return HttpUtils.updateUrlParams(url, params);
    }

    public static String updateUrlParams(String url, Map<String, Object> params) {
        LinkedHashMap<String, String> newParams = new LinkedHashMap<String, String>();
        Map<String, String> oldParams = HttpUtils.getUrlParams(url);
        if (oldParams != null) {
            newParams.putAll(oldParams);
        }
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            newParams.put(entry.getKey(), String.valueOf(entry.getValue()));
        }
        StringBuilder sb = new StringBuilder();
        sb.append(HttpUtils.parseUrl(url)).append("?");
        try {
            for (Map.Entry entry : newParams.entrySet()) {
                String urlValue = URLEncoder.encode((String)entry.getValue(), UTF8.name());
                sb.append((String)entry.getKey()).append("=").append(urlValue).append("&");
            }
            sb.deleteCharAt(sb.length() - 1);
            return sb.toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            HttpLog.e(unsupportedEncodingException);
            return url;
        }
    }

    public static String parseUrl(String url) {
        if (!"".equals(url) && url.contains("?")) {
            url = url.substring(0, url.indexOf(63));
        }
        return url;
    }

    public static String createUrlFromParams(String url, Map<String, Object> params) {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append(url);
            if (url.indexOf(38) > 0 || url.indexOf(63) > 0) {
                sb.append("&");
            } else {
                sb.append("?");
            }
            for (Map.Entry<String, Object> urlParams : params.entrySet()) {
                String urlValues = String.valueOf(urlParams.getValue());
                String urlValue = URLEncoder.encode(urlValues, UTF8.name());
                sb.append(urlParams.getKey()).append("=").append(urlValue).append("&");
            }
            sb.deleteCharAt(sb.length() - 1);
            return sb.toString();
        }
        catch (UnsupportedEncodingException e) {
            HttpLog.e(e);
            return url;
        }
    }

    public static Map<String, String> getUrlParams(String url) {
        LinkedHashMap<String, String> params = null;
        try {
            String[] urlParts = url.split("\\?");
            if (urlParts.length > 1) {
                params = new LinkedHashMap<String, String>();
                String query = urlParts[1];
                for (String param : query.split("&")) {
                    String[] pair = param.split("=");
                    String key = URLDecoder.decode(pair[0], UTF8.name());
                    String value = "";
                    if (pair.length > 1) {
                        value = URLDecoder.decode(pair[1], UTF8.name());
                    }
                    params.put(key, value);
                }
            }
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
        }
        return params;
    }
}

